import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class SumNotification {
  String sumNotificationID;
  String employeeID;
  String notificationID;
  String authenKey;

  SumNotification(
      {this.sumNotificationID,
      this.employeeID,
      this.notificationID,
      this.authenKey});

  static getData() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.SumNotification_ReadList +
            "?SumNotificationID=" +
            AppUrl.SumNotificationID +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.SumNotification_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String sumNotificationID,
  ) async {
    Map<String, dynamic> data = {
      "SumNotificationID": sumNotificationID,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.SumNotification_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String sumNotificationID,
    String employeeID,
    String notificationID,
    String authenKey,
  ) async {
    Map<String, dynamic> data = {
      "SumNotificationID": sumNotificationID,
      "EmployeeID": employeeID,
      "NotificationID": notificationID,
      "AuthenKey": authenKey,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.SumNotification_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<SumNotification> data = []; // ตัวแปรที่จะเรียกใช้งาน

  SumNotification.fromJson(Map<String, dynamic> json) {
    sumNotificationID = json['SumNotificationID'];
    employeeID = json['EmployeeID'];
    notificationID = json['NotificationID'];
    authenKey = json['AuthenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['SumNotificationID'] = this.sumNotificationID;
    data['EmployeeID'] = this.employeeID;
    data['NotificationID'] = this.notificationID;
    data['AuthenKey'] = this.authenKey;
    return data;
  }
}
