import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class SumActivityNotification {
  String customerID;
  String authenKey;
  String sumActivityNotification;

  SumActivityNotification(
      {this.customerID, this.authenKey, this.sumActivityNotification});

  static getData() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.SumActivityNotification_ReadList +
            "?CA=" +
            AppUrl.CA +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static List<SumActivityNotification> data = []; // ตัวแปรที่จะเรียกใช้งาน

  SumActivityNotification.fromJson(Map<String, dynamic> json) {
    customerID = json['CustomerID'];
    authenKey = json['AuthenKey'];
    sumActivityNotification = json['SumActivityNotification'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['CustomerID'] = this.customerID;
    data['AuthenKey'] = this.authenKey;
    data['SumActivityNotification'] = this.sumActivityNotification;
    return data;
  }
}
