import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class StatusReadMasterReadList {
  String id;
  String chatId;
  String userId;
  String userName;
  String status;
  String customerName;
  String createDate;

  StatusReadMasterReadList({
    this.id,
    this.chatId,
    this.userId,
    this.userName,
    this.status,
    this.customerName,
    this.createDate,
  });

  static List<StatusReadMasterReadList> data = [];
  static getData(chatId) async {
    print(AppUrl.StatusReadMaster_ReadList +
        "?ChatId=" +
        chatId +
        "&AuthenKey=" +
        AppUrl.AuthenKey);

    final response = await AppApi.apiGetRequest(
        AppUrl.StatusReadMaster_ReadList +
            "?ChatId=" +
            chatId +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api

    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  StatusReadMasterReadList.fromJson(Map<String, dynamic> json) {
    id = json['Id'];
    chatId = json['ChatId'];
    userId = json['UserId'];
    userName = json['UserName'];
    status = json['Status'];
    customerName = json['CustomerName'];
    createDate = json['CreateDate'];
  }
}
