import 'package:mwf_app/service/alert.dart';
import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/navigator.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/set6/service_question_user.dart';

class Research {
  String rQDId;
  String rAId;
  String rAAnswer1;
  String rAAnswer2;
  String customerId;
  String createDate;

  Research(
      {this.rQDId,
      this.rAId,
      this.rAAnswer1,
      this.rAAnswer2,
      this.customerId,
      this.createDate});

  static getData() async {
    final response = await AppApi.apiGetRequest(AppUrl.Research_ReadList +
        "?RQD_Id=" +
        AppUrl.RQD_Id +
        "&AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.Research_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      alertForm(context, "สำเร็จ", "เพิ่มข้อมูลสำเร็จ");
      Nav.push(context, ServiceQuestionUser());
    }
  }

  static deleteData(
    context,
    String rQDId,
  ) async {
    Map<String, dynamic> data = {
      "RQD_Id": rQDId,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.Research_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String rQDId,
    String rAId,
    String rAanswer1,
    String rAanswer2,
    String customerId,
    DateTime createDate,
  ) async {
    Map<String, dynamic> data = {
      "RQD_Id": rQDId,
      "RA_Id": rAId,
      "RA_Answer1": rAanswer1,
      "RA_Answer2": rAanswer2,
      "CustomerId": customerId,
      "CreateDate": createDate,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.Research_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<dynamic> questionList = [
    {
      "no": "1",
      "sGId": "S0004",
      "sQName": "ความพึงพอใจในการใช้รถไฟฟ้า",
      "statDate": "10/02/2563 10:00:00",
      "endDate": "12/02/2563 16:00:00",
    },
    {
      "no": "2",
      "sGId": "S0005",
      "sQName": "ความพึงพอใจในการใช้รถสาธารณะ",
      "statDate": "10/02/2563 10:00:00",
      "endDate": "12/02/2563 16:00:00",
    },
    {
      "no": "3",
      "sGId": "S0006",
      "sQName": "ความพึงพอใจในการใช้รถสาธารณะ",
      "statDate": "10/02/2563 10:00:00",
      "endDate": "12/02/2563 16:00:00",
    },
  ]; // รายการ

  static List<Research> data = []; // ตัวแปรที่จะเรียกใช้งาน

  Research.fromJson(Map<String, dynamic> json) {
    rQDId = json['RQD_Id'];
    rAId = json['RA_Id'];
    rAAnswer1 = json['RA_Answer1'];
    rAAnswer2 = json['RA_Answer2'];
    customerId = json['CustomerId'];
    createDate = json['CreateDate'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['RQD_Id'] = this.rQDId;
    data['RA_Id'] = this.rAId;
    data['RA_Answer1'] = this.rAAnswer1;
    data['RA_Answer2'] = this.rAAnswer2;
    data['CustomerId'] = this.customerId;
    data['CreateDate'] = this.createDate;
    return data;
  }
}
