import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class ResearchQuestion {
  String rQId;
  String rGId;
  String rQName;
  String rQDescription;
  String rQStatusName;
  bool rQStatus;
  bool isComplete;
  String startDate;
  String endDate;
  String rQcode;

  ResearchQuestion(
      {this.rQId,
      this.rGId,
      this.rQName,
      this.rQDescription,
      this.rQStatus,
      this.rQStatusName,
      this.isComplete,
      this.startDate,
      this.endDate,
      this.rQcode});

  static getData() async {
    print(AppUrl.ResearchQuestion_ReadList +
            "?AuthenKey=" +
            AppUrl.AuthenKey);
    final response = await AppApi.apiGetRequest(
        AppUrl.ResearchQuestion_ReadList +
            "?AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static List<ResearchQuestion> data = []; // ตัวแปรที่จะเรียกใช้งาน

  ResearchQuestion.fromJson(Map<String, dynamic> json) {
    rQId = json['RQ_Id'];
    rGId = json['RG_Id'];
    rQName = json['RQ_Name'];
    rQDescription = json['RQ_Description'];
    rQStatus = json['RQ_Status'];
    rQStatusName = json['RQ_StatusName'];
    isComplete = json['Is_Complete'];
    startDate = json['StartDate'];
    endDate = json['EndDate'];
    rQcode = json['RQ_Code'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['RQ_Id'] = this.rQId;
    data['RG_Id'] = this.rGId;
    data['RQ_Name'] = this.rQName;
    data['RQ_Description'] = this.rQDescription;
    data['RQ_Status'] = this.rQStatus;
    data['RQ_StatusName'] = this.rQStatusName;
    data['Is_Complete'] = this.isComplete;
    data['StartDate'] = this.startDate;
    data['EndDate'] = this.endDate;
    data['RQ_Code'] = this.rQcode;
    return data;
  }
}
