import 'dart:convert';
import 'package:http/http.dart' as http;

import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/set6/answer_question.dart';

class ResearchAnswer {
  String RQD_Id;
  String RQ_Id;
  String RQD_Question;
  String RQD_Type;
  String RQD_Sequence;
  String startDate;
  String endDate;
  List<QuestionChoice> dataChoice = [];

  ResearchAnswer(
      {this.RQD_Id,
      this.RQ_Id,
      this.RQD_Question,
      this.RQD_Type,
      this.RQD_Sequence,
      this.startDate,
      this.endDate,
      this.dataChoice});

  static getData(RQ_Id) async {
    final response = await AppApi.apiGetRequest(AppUrl.ResearchQuestion_Read +
        "?RQ_Id=" +
        RQ_Id +
        "&AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, listAnswer) async {
    final response = await http.post(AppUrl.ResearchAnswer,
        headers: <String, String>{
          'Content-Type': 'application/json; charset=UTF-8',
          "Accept": "application/json"
        },
        body: json.encode(AnswerListSend(listanswer: listAnswer).listanswer));

    print(response.body);

    if (response.statusCode == 200) {
      AppLoader.showSuccess('ส่งข้อมูลสำเร็จ');
      return true;
    } else {
      AppLoader.showError('ส่งไม่ข้อมูลสำเร็จ');
      return false;
    }
  }

  static List<ResearchAnswer> data = []; // ตัวแปรที่จะเรียกใช้งาน

  ResearchAnswer.fromJson(Map<String, dynamic> json) {
    RQD_Id = json['RQD_Id'];
    RQ_Id = json['RQ_Id'];
    RQD_Question = json['RQD_Question'];
    RQD_Type = json['RQD_Type'].toString();
    RQD_Sequence = json['RQD_Sequence'].toString();
    startDate = json['strStartDate'];
    endDate = json['strEndDate'];
    final list = json['QuestionChoice'];
    list.forEach((v) {
      final planList = QuestionChoice.fromJson(v);
      dataChoice.add(planList);
    });
  }
}

class QuestionChoice {
  String RQC_Id;
  String RQD_Id;
  String RQC_Sequence;
  String RQC_Name;
  String RQC_Type;
  bool IsRequired;
  bool RQ_Status;
  String RQC_Formate;
  String RQC_Err_Msg;
  String RQC_Ans;
  QuestionChoice(
      {this.RQC_Id,
      this.RQD_Id,
      this.RQC_Sequence,
      this.RQC_Name,
      this.RQC_Type,
      this.IsRequired,
      this.RQ_Status,
      this.RQC_Formate,
      this.RQC_Err_Msg,
      this.RQC_Ans});
  static List<QuestionChoice> data = []; // ตัวแปรที่จะเรียกใช้งาน
  QuestionChoice.fromJson(Map<String, dynamic> json) {
    RQC_Id = json['RQC_Id'];
    RQD_Id = json['RQD_Id'];
    RQC_Sequence = json['RQC_Sequence'].toString();
    RQC_Name = json['RQC_Name'];
    RQC_Type = json['RQC_Type'];
    IsRequired = json['IsRequired'];
    RQ_Status = json['RQ_Status'];
    RQC_Formate = json['RQC_Formate'];
    RQC_Err_Msg = json['RQC_Err_Msg'];
  }
}

class AnswerList {
  String RQ_Id;
  String RQC_Id;
  String RQD_Id;
  String customerId;
  String RA_Answer1;
  String CreateBy;
  AnswerList(
    this.RQ_Id,
    this.RQC_Id,
    this.RQD_Id,
    this.customerId,
    this.RA_Answer1,
    this.CreateBy,
  );
  static List<AnswerList> data = [];

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['RQ_Id'] = this.RQ_Id;
    data['RQC_Id'] = this.RQC_Id;
    data['RQD_Id'] = this.RQD_Id;
    data['customerId'] = this.customerId;
    data['RA_Answer1'] = this.RA_Answer1;
    data['CreateBy'] = this.CreateBy;
    return data;
  }
}
