import 'dart:convert';

import 'package:mwf_app/service/pref.dart';
import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class Permission {
  Permission({
    this.authenId,
    this.saleInfoId,
    this.employeeId,
    this.authenGroup,
    this.employeename,
    this.insertdate,
    this.updatedate,
    this.authenGroupId,
    this.menuname,
    this.system,
    this.actionView,
    this.actionAdd,
    this.actionUpdate,
    this.actionDelete,
    this.actionAll,
    this.employeeSurname,
    this.email,
    this.strInsertdate,
    this.strUpdatedate,
    this.strCreateDate,
    this.strUpdateDate,
    this.all,
    this.add,
    this.edit,
    this.delete,
    this.view,
  });

  String authenId;
  String saleInfoId;
  String employeeId;
  String authenGroup;
  String employeename;
  DateTime insertdate;
  DateTime updatedate;
  String authenGroupId;
  String menuname;
  String system;
  int actionView;
  int actionAdd;
  int actionUpdate;
  int actionDelete;
  int actionAll;
  String employeeSurname;
  String email;
  dynamic strInsertdate;
  dynamic strUpdatedate;
  dynamic strCreateDate;
  dynamic strUpdateDate;
  String add;
  String edit;
  String delete;
  String view;
  String all;

  static List<Permission> listPermission = [];
  static List<Permission> menuNames = [];

  static Future<dynamic> getData() async {
    print(
        " ---- > Permission Check : " + AppUrl.userID.toString() + " <----- ");
    try {
      final response = await AppApi.apiGetRequest(AppUrl.Permission_Read +
          //"?saleInfoId=C5388C95-D54A-4EC3-B76B-9979AC0F40E0" +
          "?saleInfoId=" +
          AppUrl.userID +
          "&authenkey=" +
          AppUrl.AuthenKey); // เรียกใช้ api
      listPermission.clear(); // เคลียข้อมูลเดิมออกก่อน
      return response;
    } catch (e) {
      print(e);
    }
  }

  static getResource(String prefName) async {
    await setStatus();
    var data = await getPref('String', prefName);
    var dataOutput = Permission.fromJsonSetPermission(jsonDecode(data));
    return dataOutput;
  }

  static Future<dynamic> setStatus() async { 
    final listPermis = await Permission.getData();
    listPermission.clear();
    listPermis?.forEach((v) {
      final permis = Permission.fromJson(v);
      listPermission.add(permis);
      // Wait............to fix
      if (permis.menuname == "คุณลักษณะลูกค้า") {
        var data = jsonEncode({
          "name" : "คุณลักษณะลูกค้า",
          "edit" : permis.actionUpdate.toString(),
          "add" : permis.actionAdd.toString(),
          "all" : permis.actionAll.toString(),
          "delete" : permis.actionDelete.toString(),
        });
        setPref("String", "menuTypeUserData", data);
        setPref("String", "menuTypeUser", permis.actionView.toString());
      }
      if (permis.menuname  == "เยี่ยมเยือนลูกค้า") {
        var data = jsonEncode({
          "name" : "เยี่ยมเยือนลูกค้า",
          "edit" : permis.actionUpdate.toString(),
          "add" : permis.actionAdd.toString(),
          "all" : permis.actionAll.toString(),
          "delete" : permis.actionDelete.toString(),
        });
        setPref("String", "menuVisitUserData", data);
        setPref("String", "menuVisitUser", permis.actionView.toString());
      }
      if (permis.menuname  == "กิจกรรมสร้างความสัมพันธ์") {
        var data = jsonEncode({
          "name" : "กิจกรรมสร้างความสัมพันธ์",
          "edit" : permis.actionUpdate.toString(),
          "add" : permis.actionAdd.toString(),
          "all" : permis.actionAll.toString(),
          "delete" : permis.actionDelete.toString(),
        });
       
        setPref("String", "menuActivityUserData", data);
        setPref("String", "menuActivityUser", permis.actionView.toString());
      }
      if (permis.menuname  == "เสนอบริการเสริม") {
        var data = jsonEncode({
          "name" : "เสนอบริการเสริม",
          "edit" : permis.actionUpdate.toString(),
          "add" : permis.actionAdd.toString(),
          "all" : permis.actionAll.toString(),
          "delete" : permis.actionDelete.toString(),
        });
       
        setPref("String", "menuServicesUserData", data);
        setPref("String", "menuServicesUser", permis.actionView.toString());
      }
      if (permis.menuname == "แผนที่ และการนำทาง") {
        var data = jsonEncode({
          "name" : "แผนที่ และการนำทาง",
          "edit" : permis.actionUpdate.toString(),
          "add" : permis.actionAdd.toString(),
          "all" : permis.actionAll.toString(),
          "delete" : permis.actionDelete.toString(),
        });
       
        setPref("String", "menuMapUserData", data);
        setPref("String", "menuMapUser", permis.actionView.toString());
      }
      if (permis.menuname  == "ประวัติการชำระค่าไฟฟ้า") {
        var data = jsonEncode({
          "name" : "ประวัติการชำระค่าไฟฟ้า",
          "edit" : permis.actionUpdate.toString(),
          "add" : permis.actionAdd.toString(),
          "all" : permis.actionAll.toString(),
          "delete" : permis.actionDelete.toString(),
        });
       
        setPref("String", "menuHistoryPayUserData", data);
        setPref("String", "menuHistoryPayUser", permis.actionView.toString());
      }
      if (permis.menuname ==
          "ไฟฟ้าขัดข้องและแผนดับไฟฟ้า") {
            var data = jsonEncode({
              "name" : "ไฟฟ้าขัดข้องและแผนดับไฟฟ้า",
              "edit" : permis.actionUpdate.toString(),
              "add" : permis.actionAdd.toString(),
              "all" : permis.actionAll.toString(),
              "delete" : permis.actionDelete.toString(),
            });
         
          setPref("String", "menuHistoryElectUserData", data);
          setPref("String", "menuHistoryElectUser", permis.actionView.toString());
      }
      if (permis.menuname  == "สถิติการใช้ไฟฟ้า") {
        var data = jsonEncode({
          "name" : "สถิติการใช้ไฟฟ้า",
          "edit" : permis.actionUpdate.toString(),
          "add" : permis.actionAdd.toString(),
          "all" : permis.actionAll.toString(),
          "delete" : permis.actionDelete.toString(),
        });
       
        setPref("String", "menuStatisticsUserData", data);
        setPref("String", "menuStatisticsUser", permis.actionView.toString());
      }
      if (permis.menuname  == "พนักงานดูแลลูกค้า") {
        var data = jsonEncode({
          "name" : "พนักงานดูแลลูกค้า",
          "edit" : permis.actionUpdate.toString(),
          "add" : permis.actionAdd.toString(),
          "all" : permis.actionAll.toString(),
          "delete" : permis.actionDelete.toString(),
        });
       
        setPref("String", "menuCareUserData", data);
        setPref("String", "menuCareUser", permis.actionView.toString());
      }
      if (permis.menuname  == "ข้อมูลผู้ติดต่อ") {
        var data = jsonEncode({
          "name" : "ข้อมูลผู้ติดต่อ",
          "edit" : permis.actionUpdate.toString(),
          "add" : permis.actionAdd.toString(),
          "all" : permis.actionAll.toString(),
          "delete" : permis.actionDelete.toString(),
        });
       
        setPref("String", "menuListUserData", data);
        setPref("String", "menuListUser", permis.actionView.toString());
      }
      if (permis.menuname  == "จุดติดตั้งมิเตอร์ไฟฟ้า") {
        var data = jsonEncode({
          "name" : "จุดติดตั้งมิเตอร์ไฟฟ้า",
          "edit" : permis.actionUpdate.toString(),
          "add" : permis.actionAdd.toString(),
          "all" : permis.actionAll.toString(),
          "delete" : permis.actionDelete.toString(),
        });
       
        setPref("String", "menuPointOfMeterUserData", data);
        setPref("String", "menuPointOfMeterUser", permis.actionView.toString());
      }
      if (permis.menuname  == "เสียงลูกค้า") {
        var data = jsonEncode({
          "name" : "เสียงลูกค้า",
          "edit" : permis.actionUpdate.toString(),
          "add" : permis.actionAdd.toString(),
          "all" : permis.actionAll.toString(),
          "delete" : permis.actionDelete.toString(),
        });
       
        setPref("String", "menuReportUserData", data);
        setPref("String", "menuReportUser", permis.actionView.toString());
      }
      if (permis.menuname  == "บันทึกแบบสอบถาม") {
        var data = jsonEncode({
          "name" : "บันทึกแบบสอบถาม",
          "edit" : permis.actionUpdate.toString(),
          "add" : permis.actionAdd.toString(),
          "all" : permis.actionAll.toString(),
          "delete" : permis.actionDelete.toString(),
        });
       
        setPref("String", "menuQuestionUserData", data);
        setPref("String", "menuQuestionUser", permis.actionView.toString());
      }
      if (permis.menuname  == "บันทีกแบบสำรวจ") {
        var data = jsonEncode({
          "name" : "บันทีกแบบสำรวจ",
          "edit" : permis.actionUpdate.toString(),
          "add" : permis.actionAdd.toString(),
          "all" : permis.actionAll.toString(),
          "delete" : permis.actionDelete.toString(),
        });
       
        setPref("String", "menuSurveyUserData", data);
        setPref("String", "menuSurveyUser", permis.actionView.toString());
      }
      if (permis.menuname  == "ประวัติการติดต่อสื่อสาร") {
        var data = jsonEncode({
          "name" : "ประวัติการติดต่อสื่อสาร",
          "edit" : permis.actionUpdate.toString(),
          "add" : permis.actionAdd.toString(),
          "all" : permis.actionAll.toString(),
          "delete" : permis.actionDelete.toString(),
        });
       
        setPref("String", "menuContactUserData", data);
        setPref("String", "menuContactUser", permis.actionView.toString());
      }
    });
  }

   Permission.fromJsonSetPermission(Map<String, dynamic> jsonData) {
    all = jsonData["all"];
    add = jsonData["add"];
    edit = jsonData["edit"];
    delete = jsonData["delete"];
  }

  Permission.fromJson(Map<String, dynamic> json) {
    authenId = json["AuthenID"];
    saleInfoId = json["saleInfoId"];
    employeeId = json["EmployeeID"];
    authenGroup = json["AuthenGroup"];
    employeename = json["Employeename"];
    insertdate = DateTime.parse(json["insertdate"]);
    updatedate = DateTime.parse(json["updatedate"]);
    authenGroupId = json["AuthenGroupID"];
    menuname = json["Menuname"];
    system = json["System"];
    actionView = json["Action_View"];
    actionAdd = json["Action_Add"];
    actionUpdate = json["Action_Update"];
    actionDelete = json["Action_Delete"];
    actionAll = json["Action_All"];
    employeeSurname = json["EmployeeSurname"];
    email = json["Email"];
    strInsertdate = json["strInsertdate"];
    strUpdatedate = json["strUpdatedate"];
    strCreateDate = json["strCreateDate"];
    strUpdateDate = json["strUpdateDate"];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> listPermission = new Map<String, dynamic>();
    listPermission["AuthenID"] = this.authenId;
    listPermission["saleInfoId"] = saleInfoId;
    listPermission["EmployeeID"] = employeeId;
    listPermission["AuthenGroup"] = authenGroup;
    listPermission["Employeename"] = employeename;
    listPermission["insertdate"] = insertdate.toIso8601String();
    listPermission["updatedate"] = updatedate.toIso8601String();
    listPermission["AuthenGroupID"] = authenGroupId;
    listPermission["Menuname"] = menuname;
    listPermission["System"] = system;
    listPermission["Action_View"] = actionView;
    listPermission["Action_Add"] = actionAdd;
    listPermission["Action_Update"] = actionUpdate;
    listPermission["Action_Delete"] = actionDelete;
    listPermission["Action_All"] = actionAll;
    listPermission["EmployeeSurname"] = employeeSurname;
    listPermission["Email"] = email;
    listPermission["strInsertdate"] = strInsertdate;
    listPermission["strUpdatedate"] = strUpdatedate;
    listPermission["strCreateDate"] = strCreateDate;
    listPermission["strUpdateDate"] = strUpdateDate;
    return listPermission;
  }
}
