import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';
import 'dart:convert';

class PerformanceLine {
  String text;
  String value;
  PerformanceLine({this.text, this.value});

  static getDataDashboardChartlineActivity() async {
    print(AppUrl.DashboardChartline_Activity +
        "?employeeNumber=" +
        AppUrl.EmployeeID +
        "&AuthenKey=" +
        AppUrl.AuthenKey);
    final response = await AppApi.apiGetRequest(
        AppUrl.DashboardChartline_Activity +
            "?employeeNumber=" +
            AppUrl.EmployeeID +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getDataDashboardChartlineVisit() async {
    print(AppUrl.DashboardChartline_Visit +
        "?employeeNumber=" +
        AppUrl.EmployeeID +
        "&AuthenKey=" +
        AppUrl.AuthenKey);
    final response = await AppApi.apiGetRequest(
        AppUrl.DashboardChartline_Visit +
            "?employeeNumber=" +
            AppUrl.EmployeeID +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getDataDashboardChartlineVoc() async {
    print(AppUrl.DashboardChartline_Voc +
        "?employeeNumber=" +
        AppUrl.EmployeeID +
        "&AuthenKey=" +
        AppUrl.AuthenKey);
    final response = await AppApi.apiGetRequest(AppUrl.DashboardChartline_Voc +
        "?employeeNumber=" +
        AppUrl.EmployeeID +
        "&AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getDashboardCricleActivity() async {
    print(AppUrl.DashboardCricle_Activity +
        "?employeeNumber=" +
        AppUrl.EmployeeID +
        "&AuthenKey=" +
        AppUrl.AuthenKey);
    final response = await AppApi.apiGetRequest(
        AppUrl.DashboardCricle_Activity +
            "?employeeNumber=" +
            AppUrl.EmployeeID +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getDashboardCricleVisit() async {
    print(AppUrl.DashboardCriclle_Visit +
        "?employeeNumber=" +
        AppUrl.EmployeeID +
        "&AuthenKey=" +
        AppUrl.AuthenKey);
    final response = await AppApi.apiGetRequest(AppUrl.DashboardCriclle_Visit +
        "?employeeNumber=" +
        AppUrl.EmployeeID +
        "&AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getDashboardCricleVoc() async {
    print(AppUrl.DashboardCricle_Voc +
        "?employeeNumber=" +
        AppUrl.EmployeeID +
        "&AuthenKey=" +
        AppUrl.AuthenKey);
    final response = await AppApi.apiGetRequest(AppUrl.DashboardCricle_Voc +
        "?employeeNumber=" +
        AppUrl.EmployeeID +
        "&AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getDataDashboardChartlineOffer() async {
    print(AppUrl.DashboardChartline_Offer +
        "?employeeNumber=" +
        AppUrl.EmployeeID +
        "&AuthenKey=" +
        AppUrl.AuthenKey);
    final response = await AppApi.apiGetRequest(
        AppUrl.DashboardChartline_Offer +
            "?employeeNumber=" +
            AppUrl.EmployeeID +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getDashboardCricleOffer() async {
    print(AppUrl.DashboardCricle_Offer +
        "?employeeNumber=" +
        AppUrl.EmployeeID +
        "&AuthenKey=" +
        AppUrl.AuthenKey);
    final response = await AppApi.apiGetRequest(AppUrl.DashboardCricle_Offer +
        "?employeeNumber=" +
        AppUrl.EmployeeID +
        "&AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static List<PerformanceLine> data = []; // ตัวแปรที่จะเรียกใช้งาน
  static List<LineValue> dataLineActivity = []; // ตัวแปรที่จะเรียกใช้งาน
  static List<LineValue> dataLineVisit = [];
  static List<LineValue> dataLineVoc = [];
  static List<CircleValue> dataCricleActivity = []; // ตัวแปรที่จะเรียกใช้งาน
  static List<CircleValue> dataCricleVisit = [];
  static List<CircleValue> dataCricleVoc = [];
  PerformanceLine.fromJsonActivity(Map<String, dynamic> json) {
    final list = json['DashboardChartlineValues'];
    list.forEach((v) {
      final planList = LineValue.fromJson(v);
      dataLineActivity.add(planList);
    });
    text = json['DashboardChartlineName'];
  }
  PerformanceLine.fromJsonVisit(Map<String, dynamic> json) {
    final list = json['DashboardChartlineValues'];
    list.forEach((v) {
      final planList = LineValue.fromJson(v);
      dataLineVisit.add(planList);
    });
    text = json['DashboardChartlineName'];
  }
  PerformanceLine.fromJsonVoc(Map<String, dynamic> json) {
    final list = json['DashboardChartlineValues'];
    list.forEach((v) {
      final planList = LineValue.fromJson(v);
      dataLineVoc.add(planList);
    });
    text = json['DashboardChartlineName'];
  }
}

class LineValue {
  String text;
  String value;

  LineValue({this.text, this.value});

  LineValue.fromJson(Map<String, dynamic> json) {
    text = json['Text'];
    value = json['Value'].toString();
  }
}

class CircleValue {
  String text;
  String value;
  String percent;
  CircleValue({this.text, this.value, this.percent});

  CircleValue.fromJson(Map<String, dynamic> json) {
    text = json['Text'];
    value = json['Value'].toString();
    percent = json['Percent'].toString();
  }
}

PerformanceStatistic performanceStaticFromJson(String str) => PerformanceStatistic.fromJson(json.decode(str));

String performanceStatisticToJson(PerformanceStatistic data) => json.encode(data.toJson());

class PerformanceStatistic {
    PerformanceStatistic({
        this.dataChart,
        this.waitingProcessTotal,
        this.processTotal,
        this.completedTotal,
        this.cancelTotal,
    });

    List<DataChart> dataChart;
    int waitingProcessTotal;
    int processTotal;
    int completedTotal;
    int cancelTotal;
    static List<PerformanceStatistic> data = []; // ตัวแปรที่จะเรียกใช้งาน

    static getData() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.DashboardChartline_Offer +
            "?saleinfoId="+
            AppUrl.EmpID+
        "&authenKey="+
          AppUrl.AuthenKey
        ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน  
    return jsonDecode(response);
  }

  static calcStatistic(int total, int value){
    if(total != 0 && total != null ){
      double result = (value/total)*100;
      return result;
    }else{
      return 0.0;
    }
  }

    factory PerformanceStatistic.fromJson(Map<String, dynamic> json) => PerformanceStatistic(
        dataChart: json["DataChart"] == null ? null : List<DataChart>.from(json["DataChart"].map((x) => DataChart.fromJson(x))),
        waitingProcessTotal: json["WaitingProcessTotal"] == null ? null : json["WaitingProcessTotal"],
        processTotal: json["ProcessTotal"] == null ? null : json["ProcessTotal"],
        completedTotal: json["CompletedTotal"] == null ? null : json["CompletedTotal"],
        cancelTotal: json["CancelTotal"] == null ? null : json["CancelTotal"],
    );

    Map<String, dynamic> toJson() => {
        "DataChart": dataChart == null ? null : List<dynamic>.from(dataChart.map((x) => x.toJson())),
        "WaitingProcessTotal": waitingProcessTotal == null ? null : waitingProcessTotal,
        "ProcessTotal": processTotal == null ? null : processTotal,
        "CompletedTotal": completedTotal == null ? null : completedTotal,
        "CancelTotal": cancelTotal == null ? null : cancelTotal,
    };
}

class DataChart {
    DataChart({
        this.yearMonths,
        this.total,
        this.waitingProcess,
        this.processing,
        this.completed,
        this.cancel,
    });

    String yearMonths;
    int total;
    int waitingProcess;
    int processing;
    int completed;
    int cancel;

    factory DataChart.fromJson(Map<String, dynamic> json) => DataChart(
        yearMonths: json["YearMonths"] == null ? null : json["YearMonths"],
        total: json["Total"] == null ? null : json["Total"],
        waitingProcess: json["WaitingProcess"] == null ? null : json["WaitingProcess"],
        processing: json["Processing"] == null ? null : json["Processing"],
        completed: json["Completed"] == null ? null : json["Completed"],
        cancel: json["Cancel"] == null ? null : json["Cancel"],
    );

    Map<String, dynamic> toJson() => {
        "YearMonths": yearMonths == null ? null : yearMonths,
        "Total": total == null ? null : total,
        "WaitingProcess": waitingProcess == null ? null : waitingProcess,
        "Processing": processing == null ? null : processing,
        "Completed": completed == null ? null : completed,
        "Cancel": cancel == null ? null : cancel,
    };
}