import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/service/loader.dart';

class PackageRequest {
  String prId;
  String pId;
  String pCode;
  String ca;
  String customerName;
  String customerAddress;
  dynamic prStatusType;
  String prStatusName;
  String statusType;
  String createBy;
  String createDate;
  int createTypeAccount;
  String prDescreption;
  dynamic strStartDate;
  dynamic strEndDate;
  String strCreateDate;
  dynamic strUpdateDate;
  String pName;
  String pDetail;
  String imageFile;
  String appointmentDate;

  PackageRequest({
    this.prId,
    this.pId,
    this.pCode,
    this.ca,
    this.customerName,
    this.customerAddress,
    this.prStatusType,
    this.statusType,
    this.prStatusName,
    this.createBy,
    this.createDate,
    this.createTypeAccount,
    this.prDescreption,
    this.strStartDate,
    this.strEndDate,
    this.strCreateDate,
    this.strUpdateDate,
    this.pName,
    this.pDetail,
    this.imageFile,
    this.appointmentDate,
  });

  static getData() async {
    print(AppUrl.PackageRequest_ReadList +
        "?CA=" +
        AppUrl.CA +
        "&authenKey=" +
        AppUrl.AuthenKey);
    final response = await AppApi.apiGetRequest(AppUrl.PackageRequest_ReadList +
        "?CA=" +
        AppUrl.CA +
        "&authenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getDataList() async {
    try {
      print(AppUrl.PackageRequest_CustomerList +
          "?authenKey=" +
          AppUrl.AuthenKey);
      final response = await AppApi.apiGetRequest(
          AppUrl.PackageRequest_CustomerList +
              "?authenKey=" +
              AppUrl.AuthenKey); // เรียกใช้ api
      data.clear(); // เคลียข้อมูลเดิมออกก่อน
      return response;
    } catch (e) {
      print(e);
    }
  }

  static getDataReadList() async {
    print(AppUrl.PackageRequest_Read +
        "?PR_Id=" +
        AppUrl.PR_Id +
        "&AuthenKey=" +
        AppUrl.AuthenKey);
    final response = await AppApi.apiGetRequest(AppUrl.PackageRequest_Read +
        "?PR_Id=" +
        AppUrl.PR_Id +
        "&AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getDataCyCA() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.PackageRequest_CAReadList +
            "?CA=" +
            AppUrl.CA +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getHistoryData() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.PackageRequestHistory_ReadList +
            "?CA=" +
            AppUrl.CA +
            "&authenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    dataHistory.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.PackageRequest_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(context, String pRID) async {
    Map<String, dynamic> data = {"PR_Id": pRID, "AuthenKey": AppUrl.AuthenKey};

    final response =
        await AppApi.post(AppUrl.PackageRequest_Delete, data); // เรียกใช้ api
    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String pRID,
    String pID,
    String cA,
    dynamic pRStatusType,
    String createBy,
    String pRDescreption,
  ) async {
    Map<String, dynamic> data = {
      "PR_Id": pRID,
      "P_Id": pID,
      "CA": cA,
      "PR_StatusType": pRStatusType,
      "CreateBy": createBy,
      "PR_Descreption": pRDescreption,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.PackageRequest_Update, data); // เรียกใช้ api
    if (response['statusCode'] == 200) {
      AppLoader.showSuccess('บันทึกเรียบร้อย');
    } else {
      AppLoader.showError('บันทึกไม่สำเร็จ');
    }
  }

  static updateDataNoPushBack(
    context,
    String pRID,
    String pID,
    String cA,
    dynamic pRStatusType,
    String createBy,
    String pRDescreption,
    String startDate,
    String startTime,
    String employeeid,
    String pName,
  ) async {
    Map<String, dynamic> data = {
      "PR_Id": pRID,
      "P_Id": pID,
      "CA": cA,
      "PR_StatusType": pRStatusType,
      "CreateBy": createBy,
      "PR_Descreption": pRDescreption,
      "AppointmentDate": startDate + " " + startTime,
      "EmployeeID": employeeid, 
      "P_Name" : pName,
      "AuthenKey": AppUrl.AuthenKey
    };
    print(AppUrl.PackageRequest_Update);
    final response =
        await AppApi.post(AppUrl.PackageRequest_Update, data); // เรียกใช้ api
    if (response['statusCode'] == 200) {
      AppLoader.showSuccess('บันทึกเรียบร้อย');
      await new Future.delayed(const Duration(milliseconds: 3000));
      return true;
    } else {
      AppLoader.showError('บันทึกไม่สำเร็จ');
      return false;
    }
  }

  static List<PackageRequest> data = []; // ตัวแปรที่จะเรียกใช้งาน
  static List<PackageRequest> dataHistory = []; // ตัวแปรที่จะเรียกใช้งาน

  factory PackageRequest.fromJson(Map<String, dynamic> json) => PackageRequest(
        prId: json["PR_Id"] == null ? null : json["PR_Id"],
        pId: json["P_Id"] == null ? null : json["P_Id"],
        pCode: json["P_Code"] == null ? null : json["P_Code"],
        ca: json["CA"] == null ? null : json["CA"],
        customerName:
            json["CustomerName"] == null ? null : json["CustomerName"],
        customerAddress:
            json["CustomerAddress"] == null ? null : json["CustomerAddress"],
        prStatusType:
            json["PR_StatusType"] == null ? null : json["PR_StatusType"],
        statusType: json["StatusType"] == null ? null : json["StatusType"],
        prStatusName:
            json["PR_StatusName"] == null ? null : json["PR_StatusName"],
        createBy: json["CreateBy"] == null ? null : json["CreateBy"],
        createDate: json["CreateDate"] == null ? null : json["CreateDate"],
        createTypeAccount: json["CreateTypeAccount"] == null
            ? null
            : json["CreateTypeAccount"],
        prDescreption:
            json["PR_Descreption"] == null ? null : json["PR_Descreption"],
        strStartDate: json["strStartDate"],
        strEndDate: json["strEndDate"],
        strCreateDate:
            json["strCreateDate"] == null ? null : json["strCreateDate"],
        strUpdateDate: json["strUpdateDate"],
        pName: json["P_Name"] == null ? null : json["P_Name"],
        pDetail: json["P_Detail"] == null ? null : json["P_Detail"],
        imageFile: json["ImageFile"] == null ? null : json["ImageFile"],
        appointmentDate: json["AppointmentDate"] == null ? null : json["AppointmentDate"],
      );

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['PR_Id'] = this.prId;
    data['P_Id'] = this.pId;
    data['P_Code'] = this.pCode;
    data['CA'] = this.ca;
    data['PR_StatusType'] = this.prStatusType;
    data['StatusType'] = this.statusType;
    data['PR_StatusName'] = this.prStatusName;
    data['CreateBy'] = this.createBy;
    data['CreateDate'] = this.createDate;
    data['PR_Descreption'] = this.prDescreption;
    data['strStartDate'] = this.strStartDate;
    data['strEndDate'] = this.strEndDate;
    data['strCreateDate'] = this.strCreateDate;
    data['strUpdateDate'] = this.strUpdateDate;
    data['P_Detail'] = this.pDetail;
    return data;
  }
}
