import 'package:flutter/widgets.dart';
import 'package:get/get.dart';
import 'package:mwf_app/service/alert.dart';
import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/navigator.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/set3/offer_additional_list.dart';

class PackageOption {
  String packageOptionID;
  String cA;
  String pId;
  String packageID;
  String packageName;
  int packageStatus;
  String imagePackage;
  String packageOption;
  String packageOptionName;
  String packageDetail;
  String authenKey;
  int packageOptionStatus;

  PackageOption(
      {this.packageOptionID,
      this.cA,
      this.pId,
      this.packageID,
      this.packageName,
      this.packageStatus,
      this.imagePackage,
      this.packageOption,
      this.packageOptionName,
      this.packageDetail,
      this.packageOptionStatus,
      this.authenKey});

  static getDataOption() async {
    print(AppUrl.PackageOption_ReadList + "?AuthenKey=" + AppUrl.AuthenKey);
    final response = await AppApi.apiGetRequest(AppUrl.PackageOption_ReadList +
        "?AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    dataOption.clear(); // เคลียข้อมูลเดิมออกก่อน

    print(AppUrl.PackageOption_ReadList + "?AuthenKey=" + AppUrl.AuthenKey);
    return response;
  }

  static getDataReadList() async {
    final response = await AppApi.apiGetRequest(AppUrl.Package_ReadList +
        "?AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    print(response);
    dataReadList.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.PackageOption_Create, data); // เรียกใช้ api
    print(data);
    print(response);
    if (response['statusCode'] == 200) {
      AppLoader.showSuccess("บันทึกสำเร็จ");
      
      Get.offAll(OfferAdditionalList());

      return true;
    } else {
      return false;
    }
  }

  static deleteData(context, String packageOptionID) async {
    bool conf = await alertConfirm(context, "แจ้งเตือน", "ยืนยันการลบ");
    if (conf) {
      Map<String, dynamic> data = {
        "PackageOptionID": packageOptionID,
        "AuthenKey": AppUrl.AuthenKey
      };
      final response =
          await AppApi.post(AppUrl.PackageOption_Delete, data); // เรียกใช้ api
      if (response['statusCode'] == 200) {
        Nav.push(context, OfferAdditionalList());
        return true;
      } else {
        return false;
      }
    }
  }

  static updateData(
    context,
    String packageOptionID,
    String cA,
    String pID,
    String packageID,
    String packageName,
    int packageStatus,
    String imagePackage,
    String packageOption,
    String packageOptionName,
    int packageOptionStatus,
    String packageDetail,
  ) async {
    Map<String, dynamic> data = {
      "PackageOptionID": packageOptionID,
      "CA": cA,
      "P_Id": pID,
      "PackageID": packageID,
      "PackageName": packageName,
      "PackageStatus": packageStatus,
      "ImagePackage": imagePackage,
      "PackageOption": packageOption,
      "PackageOptionName": packageOptionName,
      "PackageOptionStatus": packageOptionStatus,
      "packageDetail": packageDetail,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.PackageOption_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<PackageOption> dataOption = []; // ตัวแปรหน้าสถานะบริการเสริม
  static List<PackageOption> dataReadList =
      []; // ตัวแปรหน้ารายการแสนอบริการเสริม

  PackageOption.fromJson(Map<String, dynamic> json) {
    packageOptionID = json['PackageOptionID'];
    cA = json['CA'];
    pId = json['P_Id'];
    packageID = json['PackageID'];
    packageName = json['PackageName'];
    packageStatus = json['PackageStatus'];
    imagePackage = json['ImagePackage'];
    if (imagePackage == "") {
      imagePackage =
          'https://www.freeiconspng.com/uploads/no-image-icon-11.PNG';
    }
    packageOption = json['PackageOption'];
    packageOptionName = json['PackageOptionName'];
    packageOptionStatus = json['PackageOptionStatus'];
    authenKey = json['AuthenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['PackageOptionID'] = this.packageOptionID;
    data['CA'] = this.cA;
    data['P_Id'] = this.pId;
    data['PackageID'] = this.packageID;
    data['PackageName'] = this.packageName;
    data['PackageStatus'] = this.packageStatus;
    data['ImagePackage'] = this.imagePackage;
    data['PackageOption'] = this.packageOption;
    data['PackageOptionName'] = this.packageOptionName;
    data['PackageOptionStatus'] = this.packageOptionStatus;
    data['AuthenKey'] = this.authenKey;
    return data;
  }
}
