import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class News {
  String nId;
  String nGId;
  String nName;
  String nDetail;
  String startDate;
  String endDate;
  bool isAvtive;
  String createBy;
  String createDate;
  String updateBy;
  String updateDate;
  String imageFile;

  News(
      {this.nId,
      this.nGId,
      this.nName,
      this.nDetail,
      this.startDate,
      this.endDate,
      this.isAvtive,
      this.createBy,
      this.createDate,
      this.updateBy,
      this.updateDate,
      this.imageFile});

  static List<dynamic> newsList = [
    {
      "nDetail":
          "การไฟฟ้าส่วนภูมิภาค (PEA) ได้ติดตั้งสถานีอัดประจุไฟฟ้า รองรับการใช้งานรถยนต์ไฟฟ้า",
      "startDate": "วันที่ : 29/03/2563   I   15:32:00",
      "imageFile": "assets/images/additional/add_1.png",
    },
    {
      "nDetail": "กำลังใจจากพนักงาน PEA และประชาชน สู่ทีมแพทย์และพยาบาล",
      "startDate": "วันที่ : 29/03/2563   I   15:32:00",
      "imageFile": "assets/images/additional/add_2.png",
    },
    {
      "nDetail":
          "PEA ร่วมแถลงมาตรการการคืนเงินประกันการใช้ไฟฟ้า เริ่มคืนเงินประกันตั้งแต่ 31 มีนาคม",
      "startDate": "ววันที่ : 29/03/2563   I   15:32:00",
      "imageFile": "assets/images/additional/add_3.png",
    },
  ]; // รายการข่าวประชาสัมพันธ์

  static getData() async {
    print(AppUrl.NewsDetail_ReadList + "?AuthenKey=" + AppUrl.AuthenKey);
    final response = await AppApi.apiGetRequest(AppUrl.NewsDetail_ReadList +
        "?AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api

    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.News_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String nID,
  ) async {
    Map<String, dynamic> data = {"N_Id": nID, "AuthenKey": AppUrl.AuthenKey};
    final response =
        await AppApi.post(AppUrl.NewsDetail_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String nId,
    String nGId,
    String nName,
    String nDetail,
    String startDate,
    String endDate,
    bool isAvtive,
    String createBy,
    String createDate,
    String updateBy,
    String updateDate,
    String imageFile,
  ) async {
    Map<String, dynamic> data = {
      "N_Id": nId,
      "NG_Id": nGId,
      "N_Name": nName,
      "N_Detail": nDetail,
      "StartDate": startDate,
      "EndDate": endDate,
      "IsAvtive": isAvtive,
      "CreateBy": createBy,
      "CreateDate": createDate,
      "UpdateBy": updateBy,
      "UpdateDate": updateDate,
      "ImageFile": imageFile,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.NewsDetail_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<News> data = []; // ตัวแปรที่จะเรียกใช้งาน

  News.fromJson(Map<String, dynamic> json) {
    nId = json['N_Id'];
    nGId = json['NG_Id'];
    nName = json['N_Name'];
    nDetail = json['N_Detail'];
    startDate = json['StartDate'];
    endDate = json['EndDate'];
    isAvtive = json['IsAvtive'];
    createBy = json['CreateBy'];
    createDate = json['CreateDate'];
    updateBy = json['UpdateBy'];
    updateDate = json['UpdateDate'];
    imageFile = json['ImageFile'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['N_Id'] = this.nId;
    data['NG_Id'] = this.nGId;
    data['N_Name'] = this.nName;
    data['N_Detail'] = this.nDetail;
    data['StartDate'] = this.startDate;
    data['EndDate'] = this.endDate;
    data['IsAvtive'] = this.isAvtive;
    data['CreateBy'] = this.createBy;
    data['CreateDate'] = this.createDate;
    data['UpdateBy'] = this.updateBy;
    data['UpdateDate'] = this.updateDate;
    data['ImageFile'] = this.imageFile;
    return data;
  }
}
