import 'dart:ui';
import 'package:get/get.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:provider/provider.dart';
import 'package:firebase_core/firebase_core.dart';
import 'package:flutter_easyloading/flutter_easyloading.dart';
import 'package:flutter_localizations/flutter_localizations.dart';

import 'package:mwf_app/check_login.dart';
import 'package:mwf_app/set1/serve_customers.dart';
import 'package:mwf_app/set1/customer_property.dart';
import 'package:mwf_app/set2/visiting_plan_add.dart';
import 'package:mwf_app/set2/visiting_plan_find.dart';
import 'package:mwf_app/set2/visiting_plan_save.dart';
import 'package:mwf_app/set4/related_documents.dart';
import 'package:mwf_app/set4/service_visit_user.dart';
import 'package:mwf_app/set4/visiting_plan.dart';

import 'package:mwf_app/service/color.dart';
import 'service/notification_background.dart';
import 'package:mwf_app/service/background_main.dart';
import 'package:mwf_app/service/notification_count.dart';

void main() async {
  WidgetsFlutterBinding.ensureInitialized();
  await Firebase.initializeApp();
  await sharedPrefs.init();

  runApp(
    ChangeNotifierProvider(
      create: (context) => NotificationCount(),
      child: MyApp(),
    ),
    // MyApp()
  );
  var channel = const MethodChannel('com.pea/background_service');
  var callbackHandle = PluginUtilities.getCallbackHandle(backgroundMain);

  await channel.invokeMethod('startService', callbackHandle.toRawHandle());
  NotificationBackground.instance().startNotification();
  configLoading();
}

void configLoading() {
  EasyLoading.instance
    ..displayDuration = const Duration(milliseconds: 2000)
    ..indicatorType = EasyLoadingIndicatorType.threeBounce // รูปแบบ loader
    ..loadingStyle = EasyLoadingStyle.custom // loader แบบ  custom
    ..indicatorSize = 50.0 // ขนาด loader
    ..radius = 10.0
    ..progressColor = Colors.deepOrange
    ..backgroundColor = AppColors.color // พื้นหลัง loader
    ..indicatorColor = Colors.white // สี loader
    ..textColor = Colors.white // สีข้อความ ใน loader
    ..maskColor = Colors.deepPurple.withOpacity(0.3) // สีพื้นหลัง loader
    ..userInteractions =
        false // พอมี loader ขึ้นมาแล้วจะกดข้างหลังได้หรือไม่ true จะกดได้ false จะกดไ่ม่ได้
    ..maskType = EasyLoadingMaskType.custom; // พื้นหลัง loader แบบ custom
}

class MyApp extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return GetMaterialApp(
      debugShowCheckedModeBanner: false,
      theme: ThemeData(
        fontFamily: 'Kanit',
        scaffoldBackgroundColor: Color(0xFFf2f5f7),
        primarySwatch: Colors.purple,
      ),
      localizationsDelegates: [
        GlobalMaterialLocalizations.delegate,
        GlobalWidgetsLocalizations.delegate,
      ],
      supportedLocales: [
        const Locale('en', 'US'), // English
        const Locale('th', 'TH'), // Thai
      ],
      home: CheckLogin(),
      builder: (BuildContext context, Widget child) {
        /// make sure that loading can be displayed in front of all other widgets
        return FlutterEasyLoading(child: child);
      },
      title: 'CRM Mobile Workforce',
      routes: <String, WidgetBuilder>{
        '/servcustomer': (BuildContext context) => ServeCustomer(),
        '/visitPlanSaveWithoutId': (BuildContext context) => VisitingPlanSave(),
        '/visitPlanAdd': (BuildContext context) => VisitingPlanAdd(),
        '/visitPlanFind': (BuildContext context) => VisitingPlanFind(),
        '/customerInfo': (BuildContext context) => CustomerProperty(),
        '/serviceVisitUser': (BuildContext context) => ServiceVisitUser(''),
        '/relateDocument': (BuildContext context) => RelatedDocuments(''),
        '/visitingPlandProblem': (BuildContext context) => VisitingPlan(''),
      },
    );
  }
}
