import 'package:flutter/material.dart';
import 'package:flutter_easyloading/flutter_easyloading.dart';

class AppLoader {
  static show() {
    EasyLoading.show(status: 'loading...');
  }

  static hide() {
    // To calcel loading progress
    EasyLoading.dismiss();
  }

  static showError(msg) {
    EasyLoading.showError(msg);
  }

  static showSuccess(msg) {
    EasyLoading.showSuccess(msg);
  }

  static showInfo(msg) {
    EasyLoading.showInfo(msg);
  }

  static loaderWaitPage() {
    return Material(
      color: Colors.white.withOpacity(0.2),
      child: Center(
        child: show(),
      ),
    );
  }
}
