import 'package:flutter/material.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/pref.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/shadow.dart';
import 'package:mwf_app/service/strings.dart';
import 'package:mwf_app/set5/personal_info.dart';
import 'package:mwf_app/set9/about_app.dart';
import 'package:mwf_app/service/assets.dart';

class Drawers extends StatefulWidget {
  @override
  _DrawersState createState() => _DrawersState();
}

class _DrawersState extends State<Drawers> {
  @override
  Widget build(BuildContext context) {
    double _width = MediaQuery.of(context).size.width;
    double _height = MediaQuery.of(context).size.height;

    return Container(
      width: _width,
      height: _height,
      decoration: BoxDecoration(
        image: DecorationImage(
          image: AssetImage(
            AppAssets.bg_drawer,
          ),
          fit: BoxFit.fill,
        ),
      ),
      child: Column(
        children: <Widget>[
          Container(
            width: _width,
            height: mediaQuery(context, 'h', 700),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                Container(
                  width: mediaQuery(context, 'h', 270),
                  height: mediaQuery(context, 'h', 270),
                  margin: EdgeInsets.only(
                    top: mediaQuery(context, 'h', 70),
                  ),
                  decoration: new BoxDecoration(
                    shape: BoxShape.circle,
                    border: Border.all(
                      color: Colors.white,
                      width: 2,
                    ),
                    boxShadow: [
                      appShadow(),
                    ],
                    image: new DecorationImage(
                      fit: BoxFit.fill,
                      image: AssetImage(AppAssets.imageProfile),
                    ),
                  ),
                ),
                SizedBox(
                  height: mediaQuery(context, 'h', 50),
                ),
                Text(
                  AppStrings.profileFullName,
                  style: TextStyle(
                    fontSize: mediaQuery(context, 'h', 36),
                    color: Colors.white,
                    fontWeight: FontWeight.bold,
                  ),
                ),
                Text(
                  AppStrings.profilePositionName,
                  style: TextStyle(
                    fontSize: mediaQuery(context, 'h', 36),
                    color: Colors.white,
                  ),
                ),
              ],
            ),
          ),
          Container(
            width: _width,
            height: mediaQuery(context, 'h', 1480),
            padding: EdgeInsets.only(
              left: mediaQuery(context, 'w', 70),
              top: mediaQuery(context, 'h', 100),
            ),
            child: SingleChildScrollView(
              child: Column(
                mainAxisAlignment: MainAxisAlignment.start,
                children: <Widget>[
                  _buildMenu(
                    AppAssets.img_home_service,
                    'ข้อมูลส่วนตัว',
                    PersonalInfo(),
                  ),
                  _buildMenu(
                    AppAssets.img_setting,
                    'เกี่ยวกับโปรแกรม',
                    AboutApp(),
                  ),
                  _buildMenuLogOut(
                    AppAssets.img_logout,
                    'ออกจากระบบ',
                  ),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }

  _buildMenu(photo, menu, page) {
    return GestureDetector(
      onTap: () {
        Navigator.push(
          context,
          MaterialPageRoute(builder: (context) => page),
        );
      },
      child: Container(
        margin: EdgeInsets.symmetric(
          vertical: mediaQuery(context, 'h', 25),
        ),
        child: Row(
          children: <Widget>[
            Image.asset(
              photo,
              width: mediaQuery(context, 'w', 100),
              height: mediaQuery(context, 'h', 100),
            ),
            SizedBox(
              width: mediaQuery(context, 'w', 30),
            ),
            Text(
              menu,
              textAlign: TextAlign.center,
              style: TextStyle(
                fontSize: mediaQuery(context, 'h', 45),
              ),
            ),
          ],
        ),
      ),
    );
  }

  _buildMenuLogOut(photo, menu) {
    return GestureDetector(
      onTap: () {
        comfirmLogut(context);
      },
      child: Container(
        margin: EdgeInsets.symmetric(
          vertical: mediaQuery(context, 'h', 25),
        ),
        child: Row(
          children: <Widget>[
            Image.asset(
              photo,
              width: mediaQuery(context, 'w', 100),
              height: mediaQuery(context, 'h', 100),
            ),
            SizedBox(
              width: mediaQuery(context, 'w', 30),
            ),
            Text(
              menu,
              textAlign: TextAlign.center,
              style: TextStyle(
                fontSize: mediaQuery(context, 'h', 45),
              ),
            ),
          ],
        ),
      ),
    );
  }

  static comfirmLogut(context) {
    return showDialog(
      barrierDismissible: false,
      context: context,
      builder: (BuildContext context) {
        return Center(
          child: AlertDialog(
            shape: RoundedRectangleBorder(
              borderRadius: BorderRadius.all(
                Radius.circular(
                  mediaQuery(context, 'h', 50),
                ),
              ),
            ),
            title: Column(
              children: <Widget>[
                Container(
                  child: Image.asset(
                    'assets/images/question.png',
                    width: mediaQuery(context, 'w', 200),
                    height: mediaQuery(context, 'h', 200),
                  ),
                ),
              ],
            ),
            content: Container(
              child: Column(
                mainAxisSize: MainAxisSize.min,
                children: <Widget>[
                  Text(
                    'ออกจากระบบ',
                    style: TextStyle(
                      fontWeight: FontWeight.bold,
                      fontSize: mediaQuery(context, 'h', 60),
                    ),
                    textAlign: TextAlign.center,
                  ),
                  SizedBox(
                    height: mediaQuery(context, 'h', 10),
                  ),
                  Text(
                    'คุณแน่ใจว่าต้องการออกจากระบบ?',
                    style: TextStyle(
                      fontSize: mediaQuery(context, 'h', 46),
                    ),
                    textAlign: TextAlign.center,
                  ),
                  SizedBox(
                    height: mediaQuery(context, 'h', 40),
                  ),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                    children: <Widget>[
                      ButtonTheme(
                        minWidth: mediaQuery(context, 'h', 320),
                        height: mediaQuery(context, 'h', 120),
                        child: RaisedButton(
                          color: Colors.white,
                          shape: new RoundedRectangleBorder(
                            borderRadius: new BorderRadius.circular(
                              mediaQuery(context, 'h', 50),
                            ),
                            side: BorderSide(
                              color: AppColors.color.withOpacity(0.51),
                            ),
                          ),
                          onPressed: () {
                            logout(context);
                            Navigator.pop(context);
                          },
                          splashColor: AppColors.color,
                          child: Text(
                            'ยืนยัน',
                            style: TextStyle(
                              color: AppColors.color,
                              fontSize: mediaQuery(context, 'h', 46),
                            ),
                          ),
                        ),
                      ),
                      SizedBox(
                        width: mediaQuery(context, 'w', 20),
                      ),
                      ButtonTheme(
                        minWidth: mediaQuery(context, 'h', 320),
                        height: mediaQuery(context, 'h', 120),
                        child: RaisedButton(
                          color: Colors.white,
                          shape: new RoundedRectangleBorder(
                            borderRadius: new BorderRadius.circular(
                              mediaQuery(context, 'h', 50),
                            ),
                            side: BorderSide(
                              color: AppColors.color.withOpacity(0.51),
                            ),
                          ),
                          onPressed: () {
                            Navigator.of(context).pop(false);
                          },
                          splashColor: AppColors.color,
                          child: Text(
                            "ยกเลิก",
                            style: TextStyle(
                              color: AppColors.color,
                              fontSize: mediaQuery(context, 'h', 46),
                            ),
                          ),
                        ),
                      ),
                    ],
                  ),
                ],
              ),
            ),
          ),
        );
      },
    );
  }
}
