import 'package:html/parser.dart';

class AppConvert {

  static dateThaiToEng(date){
    if(date != null || date != ""){
      var day = date.toString().split(" ")[0].split("/")[0].toString();
      var month = date.toString().split(" ")[0].split("/")[1].toString();
      var year = (int.parse(date.toString().split(" ")[0].split("/")[2].toString())-543).toString();
      if(day.length == 1) {
        day = "0"+day;
      }
      if(month.length == 1){
        month = "0"+month;
      }

      return year+"-"+month+"-"+day;
    }
  }

  static dateEngToThai(data){
    if(data != null || data != ""){
      String day = data.split("-")[2];
      String month = data.split("-")[1];
      String year = data.split("-")[0];
      String yearTH = (int.parse(year) + 543).toString();
      
      if(day.length == 1) {
        day = "0"+day;
      }
      if(month.length == 1){
        month = "0"+month;
      }

      return yearTH+"-"+month+"-"+day;
    }
  }

  static dateTimeThaiToEng(date){
    var day = date.toString().split(" ")[0].split("/")[0].toString();
    var month = date.toString().split(" ")[0].split("/")[1].toString();
    var year = (int.parse(date.toString().split(" ")[0].split("/")[2].toString())-543).toString();
    var time = date.toString().substring(10,16);
    if(day.length == 1) {
        day = "0"+day;
      }
    if(month.length == 1){
        month = "0"+month;
    }
    return year+"-"+month+"-"+day+" "+time;
  }

  static date(datetime) {
    var date = datetime.split('T')[0];
    var day = date.split('-')[2];
    var month = date.split('-')[1];
    var year = date.split('-')[0];
    var yearTH = int.parse(year) + 543;
    
    return "$day/$month/$yearTH";
  }

  static dateToBud(datetime) { //input type string 2020-01-01 00:00:00
    var date = datetime.toString().substring(0,10);
    var day = date.split('-')[2];
    var month = date.split('-')[1];
    var year = date.split('-')[0];
    var yearTH = int.parse(year) + 543;
    
    //convert to 12/2/2563
    return "$day/$month/$yearTH";
  }

  static dateTimeThai(String date) { // Input 25/09/2020 9:09 น.
    String day = date.split("/")[0];
    String month = date.split("/")[1];
    String yearTH = (int.parse(date.split("/",)[2].substring(0,5))+543).toString();
    String dateTH = "$day/$month/$yearTH";
    String time = date.split(" ")[1].substring(0, 5);

    return "$dateTH $time";
  }

  // Input 07/12/2020 21:28
  static dateTimeEngSeperate(String dateTime) {
    String day = dateTime.split("/")[0];
    String month = dateTime.split("/")[1];
    String year = dateTime.split("/",)[2].substring(0,5).toString();
    String time = dateTime.split(" ")[1];
    // Output 2020-12-31 21:28
    return "$year-$month-$day $time";
  }

  static time(datetime) {
    var time = datetime.split('T')[1];
    return time.substring(0, 5);
  }

  static getTime(datetime){
    var time = datetime.toString().substring(11,16);
    return time;
  }

  static dateThai(datetime){
    var conDate = datetime.toString().substring(0,10);
    return conDate;
  }

  static dateOnly(datetime){
    if(datetime.isNotEmpty){
      var convert = dateTimeConvert(datetime);
      if(convert != false){
        var date = convert.toString().substring(0,10);
        return date;
      }else{
        return "";
      }
    }
  }

  static parseHtmlString(String htmlString) {
    var document = parse(htmlString);

    String parsedString = parse(document.body.text).documentElement.text;

    return parsedString;
  }

//  แปลงจาก 2020-06-24T20:22:15.17 เป็น 2020-06-24 20:22
  static dateTimeConvert(String dateTime) {
    String data = dateTime.split("T")[0];
    if(int.parse(data.split("-")[0]) > 1900){
      String day = data.split("-")[2];
      String month = data.split("-")[1];
      String year = data.split("-")[0];
      String yearTH = (int.parse(year) + 543).toString();
      String dateTH = "$day/$month/$yearTH";
      String time = dateTime.split("T")[1].substring(0, 5);
      return "$dateTH $time";
    }else{
      return false;
    }
  }

  static fillZeroTime(timeOfDay, String hours, String minutes){
    String timeString;
    String hour = hours;
    String min = minutes;
    if( min.length == 1){
      min = "0"+min;
    }
    if( hour.length == 1){
      hour = "0"+hour;
    }
    timeString = hour+":"+min;
    return timeString;
  }
} //class

class MonthThai{
  static convertMonthToThai(monthdigit){
    int numMonth = int.parse(monthdigit.toString().substring(4,6));
    final List<String> months = 
      [
        "เดือน",
        "ม.ค.",
        "ก.พ.",
        "มี.ค.",
        "เม.ย.",
        "พ.ค.",
        "มิ.ย.",
        "ก.ค.",
        "ส.ค.",
        "ก.ย.",
        "ต.ค.",
        "พ.ย.",
        "ธ.ค."
      ];
    String month = months[numMonth].toString(); 
    return month;
  }
}// End Class Month

class CheckTime{
  static checkTime(stringStartTime, stringEndTime){
    //Input time type TextEdittingController.
    var startHour = int.parse(stringStartTime.text.substring(0,2).replaceAll(":", ""));
    var endHour = int.parse(stringEndTime.text.substring(0,2).replaceAll(":", ""));
    var lenStart = int.parse(stringStartTime.text.length.toString());
    var lenEnd = int.parse(stringEndTime.text.length.toString());        
    var endMin;
    var startMin;
    var startTime;
    var endTime;
    var result;
    print("convert start : "+stringStartTime.text);
    print("convert end : "+stringEndTime.text);
    if(lenStart == 5 && lenEnd == 4){ // สำหรับหน่วยนาทีหลักสิบ          
      startMin = int.parse(stringStartTime.text.substring(2,5).replaceFirst(":", ""));
      endMin = int.parse(stringEndTime.text.substring(2,4).replaceFirst(":", ""));
    }
    if( lenStart == 4 && lenEnd == 5){          
      startMin = int.parse(stringStartTime.text.substring(2,4).replaceFirst(":", ""));
      endMin = int.parse(stringEndTime.text.substring(2,5).replaceFirst(":", ""));
    }
    if(lenStart == 5 && lenEnd == 5){
      startMin = int.parse(stringStartTime.text.substring(2,5).replaceFirst(":", ""));
      endMin = int.parse(stringEndTime.text.substring(2,5).replaceFirst(":", ""));
    }
    if( lenStart == 4 && lenEnd == 4){
      startMin = int.parse(stringStartTime.text.substring(2,4).replaceFirst(":", ""));
      endMin = int.parse(stringEndTime.text.substring(2,4).replaceFirst(":", ""));
    }
    
    if(endHour.toString().length == 1){
      endTime =  "0"+endHour.toString()+":"+endMin.toString();
    }else{
      endTime = endHour.toString()+":"+endMin.toString();
    }
    
    if(startHour.toString().length == 1){
      startTime = "0"+startHour.toString()+":"+startMin.toString();
    }else{
      startTime =  startHour.toString()+":"+startMin.toString();
    }

    if(endTime == "00:0"){
      print("zero :: "+endTime);
      return true;
    }
    result = endTime.compareTo(startTime);
    print("result : "+result.toString());

    if(result > -1){
      return true;
    }else{
      return false;
    }
  }

  static getHour(hours){
    int hour = int.parse(hours.text.substring(0,2).replaceAll(":", ""));
    return hour;
  }

  static getMin(minutes){
    int lenMin = int.parse(minutes.text.length.toString());        
    int endMin;

    if( lenMin == 4){ // สำหรับหน่วยนาทีหลักสิบ
      endMin = int.parse(minutes.text.substring(2,4).replaceFirst(":", ""));
    }
    if(lenMin == 5){          
      endMin = int.parse(minutes.text.substring(2,5).replaceFirst(":", ""));
    }
    return endMin;
  }
}// End Class Time