import 'dart:io';
import 'dart:ui';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:mwf_app/service/background_main.dart';

class AppRetainWidget extends StatelessWidget {
  AppRetainWidget({Key key, this.child}) : super(key: key);

  final Widget child;

  final _channel = const MethodChannel('com.pea/app_retain');
  final callbackHandle = PluginUtilities.getCallbackHandle(backgroundMain);

  

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        if (Platform.isAndroid) {
          if (Navigator.of(context).canPop()) {
            await _channel.invokeMethod('sendToBackground', callbackHandle.toRawHandle());
            return false;
          } else {
            await _channel.invokeMethod('sendToBackground', callbackHandle.toRawHandle());
            //_channel.invokeMethod('sendToBackground');
            return false;
          }
        } else {
          return true;
        }
      },
      child: child,
    );
  }
}
