import 'dart:convert';
import 'dart:io';
import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:get/get.dart';
import 'package:http/http.dart' as http;
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/service/pref.dart';
import 'package:mwf_app/model/ResearchAnswer_model.dart';
import 'package:mwf_app/set9/login.dart';
import 'package:shared_preferences/shared_preferences.dart';

class AppApi {
  static Future<dynamic> apiGetRequest(String url) async {
    var response = await http.get(url);
    if(response.statusCode == 401){
      print("====== Go to Login ======");
      FirebaseMessaging firebaseMessaging = FirebaseMessaging();
      SharedPreferences prefs = await SharedPreferences.getInstance();
      prefs.clear();
      await setPref("bool", "loginStatus", false);
      firebaseMessaging.unsubscribeFromTopic("pea_notification");
      firebaseMessaging.unsubscribeFromTopic("FB0593BF-BEE9-4350-845F-9AAD236F7186");
      Get.offAll(Login());
    }else{
      if(response.body != ""){
        var xx = jsonDecode(response.body);
        return xx;
      }
    }
  }

  static Future<dynamic> apiPostRequest(String url, json) async {
    var response = await http.post(url, body: json);
    if(response.statusCode == 401){
      print("====== Go to Login ======");
      FirebaseMessaging firebaseMessaging = FirebaseMessaging();
      SharedPreferences prefs = await SharedPreferences.getInstance();
      prefs.clear();
      await setPref("bool", "loginStatus", false);
      firebaseMessaging.unsubscribeFromTopic("pea_notification");
      firebaseMessaging.unsubscribeFromTopic("FB0593BF-BEE9-4350-845F-9AAD236F7186");
      Get.offAll(Login());
    }else{
      var xx = jsonDecode(response.body);
      return xx;
    }
  }

  static Future<dynamic> get(String url) async {
    HttpClient httpClient = new HttpClient();
    HttpClientRequest request = await httpClient.postUrl(Uri.parse(url));
    request.headers.set('content-type', 'application/json');
    HttpClientResponse response = await request.close();
    String reply = await response.transform(utf8.decoder).join();
    httpClient.close();
    var jsonResponse = json.decode(reply);
    return jsonResponse;
  }

  static Future<dynamic> post(String url, Map jsonMap) async {
    HttpClient httpClient = new HttpClient();
    HttpClientRequest request = await httpClient.postUrl(Uri.parse(url));
    request.headers.set('content-type', 'application/json');
    request.add(utf8.encode(json.encode(jsonMap)));
    HttpClientResponse response = await request.close();
    String reply = await response.transform(utf8.decoder).join();
    httpClient.close();
    print(reply);
    var jsonResponse = json.decode(reply);
    return jsonResponse;
  }

  static Future<dynamic> postWithMap(
      String url, Map<String, dynamic> jsonMap) async {
    var jsonData = jsonEncode(jsonMap);
    var response = await http.post(url,
        headers: <String, String>{
          'Content-Type': 'application/json; charset=UTF-8',
        },
        body: jsonData);
    var xx = jsonDecode(response.body);
    print(xx);
    return xx;
  }

  static Future<dynamic> post2(String url, Map jsonData) async {
    var response = await http.post(url, body: jsonData);
    var xx = json.decode(response.body);
    return xx;
  }

  static Future<dynamic> post3(String url, List<AnswerList> jsonData) async {
    var response = await http.post(url, body: jsonData);
    var xx = json.decode(response.body);
    return xx;
  }

  static Future<dynamic> postString(String url, String jsonData) async {
    var response = await http.post(url,
        headers: {
          'Content-type': 'application/json',
          "Accept": "application/json",
        },
        body: jsonData);
    var xx = json.decode(response.body);
    return xx;
  }

  static Future<dynamic> httpDelete(String url) async {
    var response = await http.delete(url);
    var xx = json.decode(response.body);
    return xx;
  }
}
