import 'package:flutter/material.dart';
import 'package:intl/intl.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/shadow.dart';

//HistoryPayment_model
class PaymentDetail extends StatefulWidget {
  final itemList;
  final payDate;
  PaymentDetail(this.itemList, this.payDate);

  @override
  State<StatefulWidget> createState() {
//    return _PaymentDetail();
    return _PaymentDetail(this.itemList, this.payDate);
  }
}

class _PaymentDetail extends State<PaymentDetail> {
  dynamic itemList;
  String payDate;
  _PaymentDetail(this.itemList, this.payDate);
  String units;
  double inttotalPay = 0.0;
  double sum = 0.0;
  String totalPay = "";
  @override
  void initState() {
    super.initState();
    var f = NumberFormat("#,###.0#", "en_US");
    int listLen = itemList.length;
    if (listLen > 1) {
      for (var value in itemList) {
        sum = double.parse(value.amount.replaceAll(",", ""));
        inttotalPay += sum;
      }
    } else {
      inttotalPay = double.parse(itemList[0].amount.replaceAll(",", ""));
    }
    totalPay = f.format(inttotalPay).toString();
  }

  @override
  Widget build(BuildContext context) {
    var mediaquery = MediaQuery.of(context);

    return Container(
      width: mediaquery.size.width,
      margin: EdgeInsets.only(
        top: mediaQuery(context, 'h', 200),
      ),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.only(
          topLeft: Radius.circular(40.0),
          topRight: Radius.circular(40.0),
        ),
        color: Colors.white,
      ),
      child: Container(
        margin: EdgeInsets.all(mediaQuery(context, 'w', 35)),
        //color: Colors.black26,
        child: Scaffold(
          appBar: AppBar(
            backgroundColor: Colors.white,
            elevation: 0.0,
            leading: SizedBox(),
            title: Row(
              mainAxisSize: MainAxisSize.min,
              children: <Widget>[
                Spacer(),
                Text(
                  "รายละเอียด",
                  style: TextStyle(
                      fontSize: mediaQuery(context, 'h', 70),
                      color: AppColors.color_gold),
                ),
                Spacer(),
              ],
            ),
            actions: <Widget>[
              IconButton(
                icon: Icon(
                  Icons.close,
                  color: Colors.black,
                ),
                onPressed: () {
                  Navigator.pop(context);
                },
              ),
            ],
          ),
          body: Container(
            margin: EdgeInsets.all(mediaQuery(context, 'w', 10)),
            color: AppColors.WHITE,
            child: Column(
              children: <Widget>[
                Row(
                  children: <Widget>[
                    Text(
                      'วันที่ชำระ : ',
                      style: TextStyle(
                        fontWeight: FontWeight.bold,
                        fontSize: mediaQuery(context, 'h', 50),
                      ),
                    ),
                    Text(
                      payDate,
                      style: TextStyle(
                        fontSize: mediaQuery(context, 'h', 50),
                      ),
                    ),
                  ],
                ),
                Container(
                  height: mediaQuery(context, 'h', 1650),
                  child: SingleChildScrollView(
                    child: Column(
                      children: <Widget>[
                        SizedBox(
                          height: mediaQuery(context, 'h', 40),
                        ),
                        Column(
                          children: List.generate(itemList.length, (index) {
                            return _buildContent(
                              context,
                              (index + 1).toString(),
                              itemList[index].itemName,
                              itemList[index].amount.toString(),
                            );
                          }),
                        ),
                        Container(
                          width: mediaQuery(context, 'w', 1005),
                          padding: EdgeInsets.all(
                            mediaQuery(context, 'h', 50),
                          ),
                          margin: EdgeInsets.only(
                            bottom: mediaQuery(context, 'h', 40),
                            left: mediaQuery(context, 'h', 10),
                            right: mediaQuery(context, 'h', 10),
                          ),
                          decoration: BoxDecoration(
                            borderRadius: BorderRadius.all(
                              Radius.circular(
                                mediaQuery(context, 'h', 20),
                              ),
                            ),
                            color: Color(0xFFE6EDF0),
                          ),
                          child: Row(
                            children: <Widget>[
                              Container(
                                width: mediaQuery(context, 'w', 780),
                                child: Wrap(
                                  spacing: 5.0,
                                  runSpacing: 5.0,
                                  direction: Axis.vertical,
                                  children: <Widget>[
                                    Column(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: <Widget>[
                                        Row(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: <Widget>[
                                            Text(
                                              'รวมยอดชำระ : ',
                                              style: TextStyle(
                                                color: AppColors.color_text,
                                                fontSize: mediaQuery(
                                                    context, 'h', 42),
                                              ),
                                            ),
                                            Text(
                                              totalPay.toString(),
                                              style: TextStyle(
                                                color: AppColors.color_text,
                                                fontSize: mediaQuery(
                                                    context, 'h', 42),
                                              ),
                                            ),
                                            Text(
                                              ' บาท',
                                              style: TextStyle(
                                                color: AppColors.color_text,
                                                fontSize: mediaQuery(
                                                    context, 'h', 46),
                                              ),
                                            ),
                                          ],
                                        ),
                                      ],
                                    ),
                                  ],
                                ),
                              )
                            ],
                          ),
                        )
                      ],
                    ),
                  ),
                ),
              ],
            ),
          ),
          backgroundColor: Colors.white,
        ),
      ),
    );
  }
}

_buildContent(
  context,
  number,
  list,
  price,
) {
  // var f = NumberFormat("#,###.0#", "en_US");
  //String amount = f.format(double.parse(price));
  String amount = price;
  return Container(
    width: mediaQuery(context, 'w', 1005),
//      height: mediaQuery(context, 'h', 380),
    padding: EdgeInsets.all(
      mediaQuery(context, 'h', 50),
    ),
    margin: EdgeInsets.only(
      bottom: mediaQuery(context, 'h', 40),
      left: mediaQuery(context, 'h', 10),
      right: mediaQuery(context, 'h', 10),
    ),
    decoration: BoxDecoration(
      border: Border.all(
        color: AppColors.bgColor,
      ),
      borderRadius: BorderRadius.all(
        Radius.circular(
          mediaQuery(context, 'h', 20),
        ),
      ),
      boxShadow: [
        appShadow(),
      ],
      color: Colors.white,
    ),
    child: Row(
      children: <Widget>[
        GestureDetector(
          onTap: () {},
          child: Container(
            width: mediaQuery(context, 'w', 780),
            child: Wrap(
              spacing: 5.0,
              runSpacing: 5.0,
              direction: Axis.vertical,
              children: <Widget>[
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Row(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          number + ". " + list + " " + amount + " บาท",
                          style: TextStyle(
                            color: AppColors.color_text,
                            fontSize: mediaQuery(context, 'h', 46),
                          ),
                        ),
                      ],
                    ),
                  ],
                ),
              ],
            ),
          ),
        ),
      ],
    ),
  );
}
