import 'package:flutter/material.dart';
import 'package:mwf_app/service/assets.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/screen.dart';

class About extends StatefulWidget {
  @override
  _AboutState createState() => _AboutState();
}

class _AboutState extends State<About> {
  @override
  Widget build(BuildContext context) {
    double _width = MediaQuery.of(context).size.width;

    return Material(
      child: Container(
        color: AppColors.color_bg_grey,
        child: Stack(
          children: <Widget>[
            Row(
              children: <Widget>[
                Container(
                  height: 150,
                  width: _width,
                  color: Colors.white,
                )
              ],
            ),
            Row(
              children: <Widget>[
                Image.asset(
                  AppAssets.bg_about_layer2,
//                  fit: BoxFit.cover,
                  width: _width,
                  height: mediaQuery(context, "h", 1600),
                ),
              ],
            ),
            Container(
              margin: EdgeInsets.only(top: mediaQuery(context, "h", 289)),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  SizedBox(
                    width: mediaQuery(context, "w", 630),
                    height: mediaQuery(context, "h", 630),
                    child: Image.asset(
                      AppAssets.PEA_logo,
                      width: mediaQuery(context, "w", 630),
                      height: mediaQuery(context, "h", 630),
                    ),
                  ),
                ],
              ),
            ),
            Container(
              margin: EdgeInsets.only(
                top: mediaQuery(context, "h", 1000),
              ),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  Text(
                    "CRM MOBILE WORKFORCE",
                    style: TextStyle(
                        fontSize: mediaQuery(context, "h", 70),
                        color: AppColors.color),
                  ),
                ],
              ),
            ),
            Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                Container(
                  margin: EdgeInsets.only(
                    top: mediaQuery(context, "h", 400),
                    left: mediaQuery(context, "w", 100),
                    right: mediaQuery(context, "w", 100),
                  ),
//                  color: Colors.red,
                  child: Column(
                    children: <Widget>[
                      _buildRow(context, "ผู้พัฒนา",
                          ": บริษัท ทูเฟลโลส์ เน็ตเวิร์ค แอนด์ ดีไซน์ จำกัด"),
                      _buildRow(context, "เวอร์ชัน", ": 0.1"),
                      _buildRow(context, "ติดต่อ",
                          ": 434/1 ซอยพหลโยธิน 12 ถนนพหลโยธิน\n แขวงสามเสนใน เขตพญาไท กรุงเทพมหานคร\n 10400"),
                    ],
                  ),
                ),
              ],
            ),
          ],
        ),
      ),
    );
  }

  _buildRow(context, text1, text2) {
    return Row(
      children: <Widget>[
        Container(
          width: 80,
          alignment: Alignment.bottomLeft,
          child: Text(
            text1,
            style: TextStyle(
                fontSize: mediaQuery(context, "w", 32),
                color: AppColors.color_grey),
          ),
        ),
        Container(
          alignment: Alignment.bottomLeft,
          child: Text(
            text2,
            style: TextStyle(
                fontSize: mediaQuery(context, "w", 32),
                color: AppColors.color_grey),
          ),
        ),
      ],
    );
  }
} //class
