import 'dart:async';

import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/set7/public_relation.dart';
import 'package:webview_flutter/webview_flutter.dart';

class PublicRelationView extends StatefulWidget {
  // PublicRelationView(
  //   this.nName,
  //   this.nDetail,
  //   this.startDate,
  //   this.imageFile,
  // ); // รับค่าที่ส่งมาจากหน้าก่อนหน้านี้
  PublicRelationView(
    this.id
  ); // รับค่าที่ส่งมาจากหน้าก่อนหน้านี้
  final id;
  // final nName;
  // final nDetail;
  // final startDate;
  // final imageFile;

  @override
  _PublicRelationViewState createState() => _PublicRelationViewState(
      this.id,
        // this.nName,
        // this.nDetail,
        // this.startDate,
        // this.imageFile,
      );
}


class _PublicRelationViewState extends State<PublicRelationView> {
  _PublicRelationViewState(
    this.id,
    // this.nName,
    // this.nDetail,
    // this.startDate,
    // this.imageFile,
  );

  final Completer<WebViewController> _webviewController =
      Completer<WebViewController>();
  var id;
  var urlMain = AppUrl.New_View + "/NewView?id={id}"+"&authenKey="+AppUrl.AuthenKey;
  bool isLoading = false;


  @override
  void initState() {
    super.initState();
    Header.routes = PublicRelation();
    setState(() {
      isLoading = true;
    });
    wait();
  }

  wait() async {
    await Future.delayed(const Duration(milliseconds: 2000));
    setState(() {
      isLoading = false;
    });
  }

  @override
  void dispose() {
    super.dispose();
  }

  JavascriptChannel _saveFinnishJavascriptChannel(BuildContext context) {
    
    return JavascriptChannel(
        name: 'saveFinnish',
        onMessageReceived: (message) {
          Navigator.pop(context);
        });
  }

  _bulidWebView3() {
    setState(() {
      urlMain = Uri.encodeFull(urlMain.replaceAll("{id}", id));
      print(urlMain);
    });
    return Container(
      width: MediaQuery.of(context).size.width,
      height: MediaQuery.of(context).size.height - 177,
      margin: EdgeInsets.only(
        top: mediaQuery(context, 'h', 345),
      ),
      child: WebView(
        initialUrl: urlMain,
        javascriptMode: JavascriptMode.unrestricted,
        javascriptChannels: <JavascriptChannel>[
          _saveFinnishJavascriptChannel(context),
        ].toSet(),
        onWebViewCreated: (WebViewController webViewController) {
          _webviewController.complete(webViewController);
        },
        onPageStarted: (url) {},
      ),
    );
  }

  @override
  Widget build(BuildContext context) {
    if (isLoading == true) {
      AppLoader.show();
    }
    if (isLoading == false) {
      AppLoader.hide();
    }

    return Material(
      color: AppColors.bgColor,
      child: WillPopScope(
        onWillPop: () async {
          Get.offAll(Header.routes);
          return false;
        },
        child: Stack(
          children: <Widget>[
            Header.mainMenu(context),
            _bulidWebView3(),
            Header.header2ListPage(context),
          ],
        ),
      ),
    );
  }
}


// class _PublicRelationViewState extends State<PublicRelationView> {
//   _PublicRelationViewState(
//     this.nName,
//     this.nDetail,
//     this.startDate,
//     this.imageFile,
//   );

//   var nName;
//   var nDetail;
//   var startDate;
//   var imageFile;
//   var dropdownValue;

//   @override
//   void initState() {
//     super.initState();
//     Header.routes = PublicRelation();
//     print("PublicRelationView screen");

//     print(nName);
//     print(nDetail);
//     print(startDate);
//     print(imageFile);
//   }

//   @override
//   Widget build(BuildContext context) {
//     double _width = MediaQuery.of(context).size.width;
    
//     var decorationImage = DecorationImage(
//       image: NetworkImage(
//         imageFile,
//       ),
//       fit: BoxFit.contain,
//     );

//     return Material(
//       color: AppColors.bgColor,
//       child: WillPopScope(
//         onWillPop: () async {
//           Get.offAll(Header.routes);
//           return false;
//         },
//         child: Stack(
//           children: <Widget>[
//             Header.header2ListPage(context),
//             Header.mainMenu(context),
//             Stack(
//               children: <Widget>[
//                 //imageFile != "" ?
//                 // Container(
//                 //   width: _width,
//                 //   height: mediaQuery(context, 'h', 300),
//                 //   margin: EdgeInsets.only(
//                 //     top: mediaQuery(context, 'h', 380),
//                 //     left: mediaQuery(context, 'w', 60),
//                 //     right: mediaQuery(context, 'w', 60),
//                 //   ),
//                 //   decoration: BoxDecoration(
//                 //     image: decorationImage
//                 //   ),
//                 // ) : SizedBox(height: 0, width: 0,),
//                 Container(
//                   width: _width,
//                   height: mediaQuery(context, 'h', 1550),
//                   margin: EdgeInsets.only(
//                     top: mediaQuery(context, 'h', 300),
//                   ),
//                   padding: EdgeInsets.all(
//                     mediaQuery(context, 'h', 60),
//                   ),
//                   decoration: BoxDecoration(
//                     borderRadius: BorderRadius.only(
//                       bottomLeft: Radius.circular(
//                         mediaQuery(context, 'h', 120),
//                       ),
//                     ),
//                   ),
//                   child: SingleChildScrollView(
//                     child: Column(
//                       children: <Widget>[
//                         Container(
//                           width: _width,
//                           padding: EdgeInsets.all(
//                             mediaQuery(context, 'h', 30),
//                           ),
//                           child: Column(
//                             crossAxisAlignment: CrossAxisAlignment.start,
//                             children: <Widget>[
//                               Text(
//                                 nName != null ? nName : "",
//                                 style: TextStyle(
//                                   color: AppColors.color,
//                                   fontSize: mediaQuery(context, "h", 60),
//                                 ),
//                               ),
//                               SizedBox(
//                                 height: mediaQuery(context, "h", 30),
//                               ),
//                               Text(
//                                 startDate != null ? startDate : "",
//                                 style: TextStyle(
//                                   color: Color(0xFF979797),
//                                   fontSize: mediaQuery(context, "h", 36),
//                                 ),
//                               ),
//                               SizedBox(
//                                 height: mediaQuery(context, "h", 30),
//                               ),
//                               HtmlWidget(
//                                 nDetail,
//                                 enableCaching: false,
//                                 webView: true,
//                                 customWidgetBuilder: (element) {
//                                   if (element.localName == 'img') {
//                                     return Image.network(
//                                       element.attributes['src'],
//                                     );
//                                   }
//                                   return null;
//                                 },
//                               ),
//                             ],
//                           ),
//                         ),
//                       ],
//                     ),
//                   ),
//                 ),
//               ],
//             ),
//           ],
//         ),
//       ),
//     );
//   }
// } //class
