import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mwf_app/service/assets.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/convert.dart';
import 'package:mwf_app/service/fontsize.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/navigator.dart';
import 'package:mwf_app/service/notification_count.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/shadow.dart';
import 'package:mwf_app/home.dart';
import 'package:mwf_app/model/News_model.dart';
import 'package:mwf_app/set7/public_relation_view.dart';

//News_model
class PublicRelation extends StatefulWidget {
  @override
  _PublicRelationState createState() => _PublicRelationState();
}

class _PublicRelationState extends State<PublicRelation> {
  List<dynamic> newsList = News.newsList; // รายการข่าวประชาสัมพันธ์
  bool isLoading = false;

  @override
  void initState() {
    super.initState();
    Header.routes = HomePage();
    Header.currentPage = "";
    setState(() {
      NotificationCount.newsCount = 0;
    });
    loadData();
  }

  loadData() async {
    setState(() {
      AppLoader.show();
    });
    try{
      print('load News PublicRelation screen');
      final list = await News.getData(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
      setState(() {
        list.forEach((v) {
          final list = News.fromJson(v);
          News.data.add(list); // loop เก็บข้อมูล
        });
        AppLoader.hide();
      });
    }catch(e){
      setState(() {
        AppLoader.hide();
      });
      print(e);
    }
  }

  @override
  Widget build(BuildContext context) {
    double _width = MediaQuery.of(context).size.width;
    return Material(
      color: AppColors.bgColor,
      child: WillPopScope(
        onWillPop: () async {
          Get.offAll(Header.routes);
          return false;
        },
        child: Stack(
          children: <Widget>[
            Header.header2ListPage(context),
            Header.mainMenu(context),
            Container(
              width: _width,
              height: mediaQuery(context, 'h', 1850),
              margin: EdgeInsets.only(
                top: mediaQuery(context, 'h', 350),
                left: mediaQuery(context, 'w', 60),
                right: mediaQuery(context, 'w', 60),
              ),
              child: Column(
                  children: <Widget>[
                    Container(
                      margin: EdgeInsets.only(
                        top: mediaQuery(context, 'h', 30),
                        bottom: mediaQuery(context, 'h', 50),
                      ),
                      child: Text(
                        'ข่าวประชาสัมพันธ์',
                        textAlign: TextAlign.center,
                        style: TextStyle(
                          color: Color(0xFFB58E38),
                          fontSize:
                              mediaQuery(context, 'h', AppFontSize.headText),
                        ),
                      ),
                    ),
                    Container(
                      width: _width,
                      height: mediaQuery(context, 'h', 1662),
                      child: ListView.builder(
                        padding: EdgeInsets.only(
                        top: mediaQuery(context, 'h', 30),
                      ),
                        itemCount: News.data.length,                          
                        itemBuilder: (
                          BuildContext context, index) { 
                            return _buildContent(
                              context,
                              _width,
                              News.data[index].nId,
                              News.data[index].nName,
                              News.data[index].nDetail,
                              News.data[index].startDate,
                              News.data[index].imageFile,
                            );
                          },
                        ),
                    )
                  ],
                ),
            ),
          ],
        ),
      ),
    );
  }

  _buildContent(context, _width, id, topic, text, datetime, image) {
  
    Widget _networkImg = Image.network(
      image,
      width: mediaQuery(context, 'w', 360),
      height: mediaQuery(context, 'h', 270),
      fit: BoxFit.cover,
      errorBuilder: (context, error, stackTrace) {
        return Image.asset(
          AppAssets.img_home_interrupted,
          width: mediaQuery(context, 'w', 360),
          height: mediaQuery(context, 'h', 270),
          fit: BoxFit.fill,
        );
      },
    );
    Widget _defaultimg = Image.asset(
      AppAssets.iconPicture,
      width: mediaQuery(context, 'w', 300),
      height: mediaQuery(context, 'h', 300),
      fit: BoxFit.fill,
    );
    return GestureDetector(
      onTap: () {
        Nav.push(
          context,
          PublicRelationView(id),
        );
      },
      child: Container(
        width: mediaQuery(context, 'w', 1005),
        //height: mediaQuery(context, 'h', 380),
        padding: EdgeInsets.all(
          mediaQuery(context, 'h', 40),
        ),
        margin: EdgeInsets.only(
          bottom: mediaQuery(context, 'h', 40),
        ),
        decoration: BoxDecoration(
          borderRadius: new BorderRadius.all(
            Radius.circular(
              mediaQuery(context, 'h', 20),
            ),
          ),
          boxShadow: [
            appShadow(),
          ],
          color: Colors.white,
        ),
        child: Row(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: <Widget>[
            image != "" ? _networkImg : _defaultimg,
            SizedBox(
              width: mediaQuery(context, 'w', 40),
            ),
            Flexible(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: <Widget>[
                  Text(
                    topic.length > 40
                        ? AppConvert.parseHtmlString(topic).substring(0, 40) +
                            '...'
                        : AppConvert.parseHtmlString(topic),
                    style: TextStyle(
                      color: AppColors.color_text,
                      fontSize: mediaQuery(context, 'h', 40),
                    ),
                  ),
                  SizedBox(
                    height: mediaQuery(context, 'h', 50),
                  ),
                  Text(
                    datetime,
                    style: TextStyle(
                      color: Color(0xFF979797),
                      fontSize: mediaQuery(context, 'h', 40),
                    ),
                  )
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }
} //class
