import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:intl/date_symbol_data_local.dart';
import 'package:intl/intl.dart';
import 'package:mwf_app/service/alert.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/convert.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/model/history_contact.dart';
import 'package:buddhist_datetime_dateformat/buddhist_datetime_dateformat.dart';
import 'package:flutter_rounded_date_picker/rounded_picker.dart';
import 'package:mwf_app/set4/visiting_plan.dart';
import 'package:mwf_app/set7/contact_user.dart';

//HistoryContact model
class HistoryCommunication extends StatefulWidget {
  @override
  _HistoryCommunicationState createState() => _HistoryCommunicationState();
}

class _HistoryCommunicationState extends State<HistoryCommunication> {
  TextEditingController date = TextEditingController(); // วันที่แจ้ง
  TextEditingController time = TextEditingController(); // เวลา
  String contactType = ""; // แบบการติดต่อ
  String contactWay = ""; // ช่องทางการติดต่อ
  String contactNamePEA = ""; // ชื่อผู้ติดต่อ กฟภ
  String contactNameCus = ""; // ชื่อผู้ติดต่อ ลูกค้า
  String contactReason = ""; // เหตุผลที่ติดต่อ
  TextEditingController contactDetails = TextEditingController(); // รายละเอียด

  var dropdownValue;
  TextEditingController teContactNamePEA = TextEditingController();
  TextEditingController teContactNameCus = TextEditingController();
  TextEditingController teContactReason = TextEditingController();
  List<KeyValueModel> contactTypeList = [
    //รายการแบบการติดต่อ
    KeyValueModel(key: "เลือก", value: ""),
  ];

  List<KeyValueModel> contactWayList = [
    //รายการช่องทางการติดต่อ
    KeyValueModel(key: "เลือก", value: ""),
  ];

  List<KeyValueModel> contactNamePEAList = [
    //รายการชื่อผู้ติดต่อ กฟภ
    KeyValueModel(key: "เลือก", value: ""),
  ];

  List<KeyValueModel> contactNameCusList = [
    //รายการช ชื่อผู้ติดต่อ ลูกค้า
    KeyValueModel(key: "เลือก", value: ""),
  ];

  List<KeyValueModel> contactReasonList = [
    //รายการเหตุผลที่ติดต่อ
    KeyValueModel(key: "เลือก", value: ""),
  ];
//  Map mapCheck  = {};
  var mapCheck = [];
  String dateCreate;

  @override
  void initState() {
    super.initState();
    print("On Add set7/history_communication.dart");
    loadDataDropDown();
    Intl.defaultLocale = 'th';
    initializeDateFormatting();
    setState(() {
      contactNamePEA = AppUrl.userName;
      teContactNamePEA.text = contactNamePEA;
    });
  }

  @override
  void dispose() {
    super.dispose();
  }

  loadDataDropDown() async {
    setState(() {
      isLoading = true;
    });
    final listContactReasonReadList = await HistoryContact
        .getCategoryContactList(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
    mapCheck.clear();
    try {
      for (var i = 0; i < listContactReasonReadList.length; i++) {
        setState(() {
          if (!mapCheck.contains(
              listContactReasonReadList[i]['CategoryContactName'].toString())) {
            mapCheck.add(
                listContactReasonReadList[i]['CategoryContactName'].toString());
            contactReasonList.add(
              KeyValueModel(
                key: listContactReasonReadList[i]['CategoryContactName']
                    .toString(), // key คือค่าที่แสดง
                value: listContactReasonReadList[i]['CategoryContactName']
                        .toString() +
                    "|" +
                    listContactReasonReadList[i]
                        ['CategoryContactId'], // value ค่าที่บันทึก
              ),
            );
          }
        });
      }
    } catch (e) {
      setState(() {
        isLoading = false;
      });
    }

    final listContactChanelReadList = await HistoryContact
        .getCommunicateChannelList(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
    mapCheck.clear();
    for (var i = 0; i < listContactChanelReadList.length; i++) {
      setState(() {
        if (!mapCheck.contains(listContactChanelReadList[i]
                ['CommunicateChannelName']
            .toString())) {
          mapCheck.add(listContactChanelReadList[i]['CommunicateChannelName']
              .toString());
          contactWayList.add(
            KeyValueModel(
              key: listContactChanelReadList[i]['CommunicateChannelName']
                  .toString(), // key คือค่าที่แสดง
              value: listContactChanelReadList[i]['CommunicateChannelName']
                      .toString() +
                  "|" +
                  listContactChanelReadList[i]
                      ['CommunicateChannelId'], // value ค่าที่บันทึก
            ),
          );
        }
      });
    }
//

    final listCustomerCareReadList = await HistoryContact
        .getCustomerCareReadList(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
    mapCheck.clear();
    for (var i = 0; i < listCustomerCareReadList.length; i++) {
      setState(() {
        if (!mapCheck.contains(
          listCustomerCareReadList[i]['EmployeeFullName'].toString(),
        )) {
          mapCheck
              .add(listCustomerCareReadList[i]['EmployeeFullName'].toString());
          contactNamePEAList.add(
            KeyValueModel(
              key: listCustomerCareReadList[i]['EmployeeFullName']
                  .toString(), // key คือค่าที่แสดง
              value:
                  listCustomerCareReadList[i]['EmployeeFullName'].toString() +
                      "|" +
                      listCustomerCareReadList[i]
                          ['EmployeeNumber'], // value ค่าที่บันทึก
            ),
          );
        }
      });
    }

    final listCustomerContactReadList = await HistoryContact
        .getCustomerContactReadList(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
    mapCheck.clear();
    for (var i = 0; i < listCustomerContactReadList.length; i++) {
      setState(() {
        if (!mapCheck.contains(
          listCustomerContactReadList[i]['contactName'].toString(),
        )) {
          mapCheck
              .add(listCustomerContactReadList[i]['contactName'].toString());
          contactNameCusList.add(
            KeyValueModel(
              key: listCustomerContactReadList[i]['contactName']
                  .toString(), // key คือค่าที่แสดง
              value: listCustomerContactReadList[i]['contactName'].toString() +
                  "|" +
                  listCustomerContactReadList[i]
                      ['customerContactInfoId'], // value ค่าที่บันทึก
            ),
          );
        }
      });
    }

    final listContactTypeList = await HistoryContact
        .getCommunicateDirectionList(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
    mapCheck.clear();
    for (var i = 0; i < listContactTypeList.length; i++) {
      setState(() {
        if (!mapCheck.contains(
            listContactTypeList[i]['CommunicateDirectionName'].toString())) {
          mapCheck.add(
              listContactTypeList[i]['CommunicateDirectionName'].toString());
          contactTypeList.add(
            KeyValueModel(
              key: listContactTypeList[i]['CommunicateDirectionName']
                  .toString(), // key คือค่าที่แสดง
              value: listContactTypeList[i]['CommunicateDirectionName']
                      .toString() +
                  "|" +
                  listContactTypeList[i]
                      ['CommunicateDirectionId'], // value ค่าที่บันทึก
            ),
          );
        }
      });
    }
    setState(() {
      isLoading = false;
    });
    return "xx";
  } // function

  @override
  Widget build(BuildContext context) {
    if (isLoading == true) {
      AppLoader.show();
    }
    if (isLoading == false) {
      AppLoader.hide();
    }

    double _width = MediaQuery.of(context).size.width;
    double _height = MediaQuery.of(context).size.height;
    Header.routes = ContactUser();
    return GestureDetector(
      onTap: (){
        FocusScope.of(context).unfocus();
      },
      child: Material(
        color: AppColors.bgColor,
        child: WillPopScope(
            onWillPop: () async {
              Get.offAll(Header.routes);
              return false;
            },
          child: Stack(
            children: <Widget>[
              Header.headerListPage(context),
              Header.mainMenu(context),
              Container(
                margin: EdgeInsets.only(
                  top: mediaQuery(context, 'h', 990),
                ),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: <Widget>[
                    Text(
                      'ประวัติการติดต่อสื่อสาร',
                      style: TextStyle(
                        fontSize: mediaQuery(context, 'h', 60),
                        color: AppColors.color_gold,
                      ),
                      textAlign: TextAlign.center,
                    ),
                  ],
                ),
              ),
              Container(
                //            icon เมนู
                width: _width,
                height: mediaQuery(context, 'h', 1100),
                margin: EdgeInsets.only(
                  top: mediaQuery(context, 'h', 1100),
                  left: mediaQuery(context, 'w', 60),
                  right: mediaQuery(context, 'w', 60),
                ),
                child: SingleChildScrollView(
                  padding: EdgeInsets.only(
                    bottom: _height / 3.5),
                  child: Column(
                    children: <Widget>[
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: <Widget>[
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: <Widget>[
                              Text(
                                'วันที่แจ้ง :',
                                style: TextStyle(
                                  fontSize: mediaQuery(context, 'h', 40),
                                  color: AppColors.Black,
                                ),
                                textAlign: TextAlign.center,
                              ),
                              Container(
                                height: mediaQuery(context, 'h', 105),
                                width: mediaQuery(context, 'w', 490),
                                child: GestureDetector(
                                  onTap: () async {
                                    DateTime newDate = await showRoundedDatePicker(
                                      context: context,
                                      initialDate: dateCreate != null
                                          ? DateTime.parse(dateCreate)
                                          : DateTime.now(),
                                      firstDate: DateTime(DateTime.now().year - 10),
                                      lastDate: DateTime(DateTime.now().year + 10),
                                      locale: Locale('th', 'TH'),
                                      era: EraMode.BUDDHIST_YEAR,
                                      theme: ThemeData(
                                        primarySwatch: Colors.deepPurple,
                                      ),
                                      height: 280,
                                    );
                                    if (newDate != null) {
                                      List<String> dtArray =
                                          newDate.toString().split(" ");
                                      setState(() {
                                        var formatter = DateFormat.yMd();
                                        var showDate = formatter
                                            .formatInBuddhistCalendarThai(newDate);
                                        date.text = showDate;
                                        dateCreate = dtArray[0];
                                      });
                                    }
                                  },
                                  child: Container(
                                    height: mediaQuery(context, 'h', 105),
                                    width: mediaQuery(context, 'w', 490),
                                    padding: EdgeInsets.only(
                                      left: mediaQuery(context, 'h', 20),
                                      right: mediaQuery(context, 'h', 20),
                                    ),
                                    decoration: BoxDecoration(
                                      borderRadius: BorderRadius.all(
                                        Radius.circular(
                                          mediaQuery(
                                            context,
                                            'h',
                                            150,
                                          ),
                                        ),
                                      ),
                                      border: Border.all(
                                        color: Colors.grey[500],
                                      ),
                                      color: Colors.white,
                                    ),
                                    child: Row(
                                      mainAxisAlignment:
                                          MainAxisAlignment.spaceBetween,
                                      children: <Widget>[
                                        Text(date.text),
                                        Icon(
                                          Icons.calendar_today,
                                          color: Colors.grey,
                                          size: mediaQuery(
                                            context,
                                            'h',
                                            80,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                ),
                              ),
                            ],
                          ),
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: <Widget>[
                              Text(
                                'เวลา :',
                                style: TextStyle(
                                    fontSize: mediaQuery(context, 'h', 40),
                                    color: AppColors.Black),
                                textAlign: TextAlign.center,
                              ),
                              Container(
                                height: mediaQuery(context, 'h', 105),
                                width: mediaQuery(context, 'w', 490),
                                child: GestureDetector(
                                  onTap: () async {
                                    TimeOfDay newTime = await showTimePicker(
                                      context: context,
                                      initialTime: time.text.isNotEmpty
                                          ? TimeOfDay(
                                              hour: CheckTime.getHour(time),
                                              minute: CheckTime.getMin(time),
                                            )
                                          : TimeOfDay.now(),
                                      builder: (context, child) {
                                        return Container(
                                          child: Column(
                                            children: <Widget>[
                                              MediaQuery(
                                                  data: MediaQuery.of(context)
                                                      .copyWith(
                                                    alwaysUse24HourFormat: true,
                                                  ),
                                                  child: child),
                                              Theme(
                                                data: Theme.of(context).copyWith(
                                                  primaryColor: AppColors.color,
                                                  accentColor: AppColors.color_gold,
                                                  colorScheme: ColorScheme.light(
                                                    primary: AppColors.color,
                                                  ),
                                                  buttonTheme: ButtonThemeData(
                                                    textTheme:
                                                        ButtonTextTheme.primary,
                                                  ),
                                                ),
                                                child: Container(
                                                  height: 0,
                                                  width: 0,
                                                  child: child,
                                                ),
                                              ),
                                            ],
                                          ),
                                        );
                                      },
                                    );
                                    if (newTime != null) {
                                      String hour = newTime.hour.toString();
                                      String min = newTime.minute.toString();
                                      var times = AppConvert.fillZeroTime(
                                          newTime, hour, min);
                                      setState(() {
                                        time.text = times;
                                        print(time.text);
                                      });
                                    }
                                  },
                                  child: Container(
                                    height: mediaQuery(context, 'h', 105),
                                    width: mediaQuery(context, 'w', 490),
                                    padding: EdgeInsets.only(
                                      left: mediaQuery(context, 'h', 20),
                                      right: mediaQuery(context, 'h', 20),
                                    ),
                                    decoration: BoxDecoration(
                                      borderRadius: BorderRadius.all(
                                        Radius.circular(
                                          mediaQuery(
                                            context,
                                            'h',
                                            150,
                                          ),
                                        ),
                                      ),
                                      border: Border.all(
                                        color: Colors.grey[500],
                                      ),
                                      color: Colors.white,
                                    ),
                                    child: Row(
                                      mainAxisAlignment:
                                          MainAxisAlignment.spaceBetween,
                                      children: <Widget>[
                                        Text(time.text),
                                        Icon(
                                          Icons.access_time,
                                          color: Colors.grey,
                                          size: mediaQuery(
                                            context,
                                            'h',
                                            80,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                ),
                              ),
                            ],
                          ),
                        ],
                      ),
                      _buildSizeBox(context),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: <Widget>[
                          _buildTextMenu(context, 'แบบการติดต่อ :'),
                        ],
                      ),
                      _buildSizeBox(context),
                      Row(
                        children: <Widget>[
                          _buildDropDownRow1(context),
                        ],
                      ),
                      _buildSizeBox(context),
                      Row(
                        children: <Widget>[
                          _buildTextMenu(context, 'ช่องทางการติดต่อ :'),
                        ],
                      ),
                      _buildSizeBox(context),
                      Row(
                        children: <Widget>[
                          _buildDropDownRow2(context),
                        ],
                      ),
                      _buildSizeBox(context),
                      Row(
                        children: <Widget>[
                          _buildTextMenu(context, 'ชื่อผู้ติดต่อ (กฟภ.) :'),
                        ],
                      ),
                      _buildSizeBox(context),
                      Row(
                        children: <Widget>[
                          _buildTextField(context, teContactNamePEA),
                        ],
                      ),
                      _buildSizeBox(context),
                      Row(
                        children: <Widget>[
                          _buildTextMenu(context, 'ชื่อผู้ติดต่อ (ลูกค้า) :'),
                        ],
                      ),
                      _buildSizeBox(context),
                      Row(
                        children: <Widget>[
                          _buildTextField(context, teContactNameCus),
                        ],
                      ),
                      _buildSizeBox(context),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: <Widget>[
                          _buildTextMenu(context, 'เหตุผลที่ติดต่อ :'),
                        ],
                      ),
                      _buildSizeBox(context),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: <Widget>[
                          _buildDropDownRow5(context),
                        ],
                      ),
                      _buildSizeBox(context),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: <Widget>[
                          _buildTextMenu(context, 'รายละเอียด :'),
                        ],
                      ),
                      _buildSizeBox(context),
                      Card(
                        color: Colors.white,
                        child: Padding(
                          padding: EdgeInsets.all(
                            mediaQuery(context, 'h', 40),
                          ),
                          child: TextField(
                            controller: contactDetails,
                            maxLines: 5,
                            style: TextStyle(
                              fontSize: mediaQuery(context, 'h', 36),
                              color: Color(0xFF707070),
                            ),
                            decoration: InputDecoration.collapsed(
                              hintText: "",
                            ),
                          ),
                        ),
                      ),
                      SizedBox(
                        height: mediaQuery(context, "h", 60),
                      ),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                        children: <Widget>[
                          _buildButtonCancel(context),
                          _buildButtonSave(context),
                        ],
                      ),
                    ],
                  ),
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }

  _buildTextMenu(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        Text(
          text + " :",
          style: TextStyle(
            fontSize: mediaQuery(context, 'h', 40),
            color: AppColors.Black,
          ),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildTextField(context, controller) {
    return Container(
      height: mediaQuery(context, 'h', 110),
      width: mediaQuery(context, 'w', 1005),
      child: TextField(
        enabled: true,
        controller: controller,
        decoration: InputDecoration(
          border: OutlineInputBorder(
            borderRadius: const BorderRadius.all(
              const Radius.circular(50.0),
            ),
          ),
          filled: true,
          counterText: "",
          contentPadding: EdgeInsets.fromLTRB(10.0, 0.0, 20.0, 10.0),
          hintStyle: TextStyle(color: Colors.grey[800]),
          fillColor: Colors.white70,
        ),
      ),
    );
  }

  _buildSizeBox(context) {
    return SizedBox(
      height: mediaQuery(context, "h", 15),
    );
  }

  _buildDropDownRow1(context) {
    return Container(
      height: mediaQuery(context, 'h', 130),
      width: mediaQuery(context, 'w', 1005),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(20),
        border: Border.all(
          color: Color(0xFF999C9D),
          width: 0.5,
        ),
        color: Colors.white,
      ),
      child: Container(
        margin: EdgeInsets.only(
          left: mediaQuery(context, 'w', 25),
        ),
        child: DropdownButtonHideUnderline(
          child: DropdownButton<String>(
            iconSize: 30,
            icon: Icon(Icons.keyboard_arrow_down),
            underline: SizedBox(),
            items: contactTypeList
                .map(
                  (data) => DropdownMenuItem<String>(
                    child: Container(
                      child: Text(
                        data.key,
                        style: TextStyle(
                          fontSize: mediaQuery(context, "h", 50),
                        ),
                        textScaleFactor: 0.7,
                      ),
                    ),
                    value: data.value,
                  ),
                )
                .toList(),
            isExpanded: true,
            onChanged: (String value) {
              setState(() {
                contactType = value;
              });
            },
            value: contactType,
          ),
        ),
      ),
    );
  }

  _buildDropDownRow2(context) {
    return Container(
      height: mediaQuery(context, 'h', 130),
      width: mediaQuery(context, 'w', 1005),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(20),
        border: Border.all(
          color: Color(0xFF999C9D),
          width: 0.5,
        ),
        color: Colors.white,
      ),
      child: Container(
        margin: EdgeInsets.only(
          left: mediaQuery(context, 'w', 25),
        ),
        child: DropdownButton<String>(
          icon: Icon(Icons.expand_more),
          iconSize: 30,
          elevation: 16,
          underline: SizedBox(),
          items: contactWayList
              .map(
                (data) => DropdownMenuItem<String>(
                  child: Container(
                    child: Text(
                      data.key,
                      style: TextStyle(
                        fontSize: mediaQuery(context, "h", 50),
                      ),
                      textScaleFactor: 0.7,
                    ),
                  ),
                  value: data.value,
                ),
              )
              .toList(),
          isExpanded: true,
          onChanged: (String value) {
            setState(() {
              contactWay = value;
              print(contactWay);
            });
          },
          value: contactWay,
        ),
      ),
    );
  }

  _buildDropDownRow5(context) {
    return Container(
      height: mediaQuery(context, 'h', 130),
      width: mediaQuery(context, 'w', 1005),
      decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(20),
          border: Border.all(
            color: Color(0xFF999C9D),
            width: 0.5,
          ),
          color: Colors.white),
      child: Container(
        margin: EdgeInsets.only(
          left: mediaQuery(context, 'w', 25),
        ),
        child: DropdownButton<String>(
        //  value: dropdownValue,
          icon: Icon(Icons.expand_more),
          iconSize: 30,
          elevation: 16,
//          style: TextStyle(color: AppColors.Black),
          underline: SizedBox(),
          items: contactReasonList
              .map(
                (data) => DropdownMenuItem<String>(
                  child: Container(
                    child: Text(
                      data.key,
                      style: TextStyle(
                        fontSize: mediaQuery(context, "h", 50),
                      ),
                      textScaleFactor: 0.7,
                    ),
                  ),
                  value: data.value,
                ),
              )
              .toList(),
          isExpanded: true,
          onChanged: (String value) {
            setState(() {
              contactReason = value;
              print(contactReason);
            });
          },
          value: contactReason,
        ),
      ),
    );
  }

  _buildButtonCancel(context) {
    return ButtonTheme(
      minWidth: mediaQuery(context, "w", 477),
      height: mediaQuery(context, "h", 120),
      child: FlatButton(
        shape: RoundedRectangleBorder(
          borderRadius: BorderRadius.circular(
            mediaQuery(context, "w", 50),
          ),
          side: BorderSide(color: AppColors.color),
        ),
        color: AppColors.color,
        textColor: Colors.red,
        padding: EdgeInsets.all(
          mediaQuery(context, "w", 10),
        ),
        onPressed: () {
          print('ยกเลิก');
          Get.offAll(Header.routes);
          return false;
        },
        child: Text(
          'ยกเลิก',
          style: TextStyle(
            fontSize: 14.0,
            color: Colors.white,
          ),
        ),
      ),
    );
  }

  _buildButtonSave(context) {
    return ButtonTheme(
      minWidth: mediaQuery(context, "w", 477),
      height: mediaQuery(context, "h", 120),
      child: FlatButton(
        shape: RoundedRectangleBorder(
          borderRadius: BorderRadius.circular(
            mediaQuery(context, "w", 50),
          ),
          side: BorderSide(color: AppColors.color),
        ),
        color: AppColors.color,
        textColor: Colors.red,
        padding: EdgeInsets.all(
          mediaQuery(context, "w", 10),
        ),
        onPressed: () {
          print('บันทึก');

          saveCommu(context);
        },
        child: Text(
          'บันทึก',
          style: TextStyle(
            fontSize: 14.0,
            color: Colors.white,
          ),
        ),
      ),
    );
  }

  saveCommu(context) async {
    if (!await checkForm([
      date.text,
      time.text,
      contactType,
      contactWay,
      contactNamePEA,
      teContactNameCus.text,
      contactReason,
      contactDetails.text,
    ])) {
      alertForm(context, "แจ้งเตือน", "กรอกข้อมูลไม่ครบ");
    } else {
      Map<String, dynamic> data = {
        "customerId": AppUrl.CustomerID,
        "communicateDate": dateCreate + " " + time.text,
        "communicateWith": teContactNameCus.text,
        "communicateDirectionId": contactType.split("|")[1],
        "communicateDetail": contactDetails.text,
        "communicateEmployee": teContactNamePEA.text,
        "communicateChannelId": contactWay.split("|")[1],
        "categoryContactId": contactReason.split("|")[1],
        "AuthenKey": AppUrl.AuthenKey
      };
      await HistoryContact.saveData(context, data);
    }
  }
} //class

class KeyValueModel {
  String key;
  String value;

  KeyValueModel({this.key, this.value});
}
