import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:intl/date_symbol_data_local.dart';
import 'package:intl/intl.dart';
import 'package:mwf_app/service/alert.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/shadow.dart';
import 'package:mwf_app/service/style.dart';
import 'package:mwf_app/model/Survey_model.dart';
import 'package:buddhist_datetime_dateformat/buddhist_datetime_dateformat.dart';

//Survey_model
class SurveySave extends StatefulWidget {
  final index;

  SurveySave(this.index);

  @override
  _SurveySaveState createState() => _SurveySaveState(this.index);
}

class _SurveySaveState extends State<SurveySave> {
  var index;

  _SurveySaveState(this.index);

  TextEditingController watt = TextEditingController(); // กำลังไฟฟ้า วัตต์
  TextEditingController manufacturingCompany =
      TextEditingController(); // บริษัทผู้ผลิต
  TextEditingController serialNumber = TextEditingController(); // serial number
  TextEditingController latestMaintenanceDate =
      TextEditingController(); // วันที่บำรุงรักษาล่าสุด
  TextEditingController wattMaintenance =
      TextEditingController(); //  กำลังไฟฟ้า วัตต์ ข้อมูลการบำรุงรักษา

  String id;
  String name;
  String voltageSize; //ขนาดแรงดัน
  String startDate; //วันที่เริ่มต้น
  String endDate; //วันที่สิ้นสุด
  bool underMaintenance; // อยู่ระหว่างบำรุงรักษา

  static List<KeyValueModel> dataTransForm = [];

  String transformerType = ""; // ประเภทหม้อแปลง
  String keyTransForm = "";
  int _radioValue = 0;
  bool monVal = false;

  final List<KeyValueModel> _dropdownTransformType = [
    KeyValueModel(key: "เลือก", value: ""),
  ]; // ประเภทหม้อแปลงList

  @override
  void initState() {
    super.initState();
    Intl.defaultLocale = 'th';
    initializeDateFormatting();
    setState(() {
      id = Survey.dataList[index].sQCode;
      name = Survey.dataList[index].sQName;
      startDate = Survey.dataList[index].statDate;
      endDate = Survey.dataList[index].endDate;
    });
    print("หน้าแก้ไขแบบสำรวจ set6/survey_save.dart");
    getTransformType('7CC64CA9-1DDF-49DC-970D-B25F83558B15');
  }

  getTransformType(String id) async {
    final listTransForm =
        await Survey.getDataBySQIDForm(id); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
    //print(" "+listTransForm['QuestionDetail'][3]['SurveyQuestionChoice'][0]['SQC_Name']);
    //print(" "+listTransForm['QuestionDetail'][3]['SurveyQuestionChoice'][0]['SurveySubChoiceList'].length.toString());
    var loopChoiceList = 0;
    var questionDetail = listTransForm['QuestionDetail'];
    for (var i = 0; i < questionDetail.length; i++) {
      int count = listTransForm['QuestionDetail'][i]['SurveyQuestionChoice'][0]
              ['SurveySubChoiceList']
          .length;
      if (count > 0) {
        var inShort = listTransForm['QuestionDetail'][i]['SurveyQuestionChoice']
            [0]['SurveySubChoiceList'];
        //print("Count "+count.toString());
        for (var j = 0; j < count; j++) {
          print("Key: " +
              questionDetail[i]['SQD_Type'].toString() +
              ", value: " +
              inShort[j]['SSC_Name']);
          setState(() {
            _dropdownTransformType.add(
              KeyValueModel(
                key: inShort[j]['SSC_Name'],
                value: questionDetail[i]['SQD_Type'],
              ),
            );
          });
        }
        loopChoiceList = 1 + 1;
      } else {
        continue;
      }
    }
    print("Sum Question List : " + loopChoiceList.toString());
  }

  save() async {
    List<dynamic> checkValue = [
      transformerType,
      watt,
      voltageSize,
      wattMaintenance.text, // กำลังไฟฟ้า วัตต์ ข้อมูลการบำรุงรักษา
      latestMaintenanceDate.text, //  วันที่บำรุงรักษาล่าสุด
      serialNumber.text, //  serial number
      manufacturingCompany.text //  บริษัทผู้ผลิต
    ];
    print("------------");
    print("Formty: " + transformerType);
    print("Wat : " + watt.text);
    print("Voltage : " + voltageSize);
    print("Mainten : " + wattMaintenance.text);
    print("Last Mainten : " + latestMaintenanceDate.text);
    print("Serial no. : " + serialNumber.text);
    print("Company : " + manufacturingCompany.text);
    print("Undermainten : " + underMaintenance.toString());
    print("------------");
    var chk = checkForm(checkValue);
    if (chk == true) {
      Map<String, dynamic> data = {
        "sQCFormat": transformerType, // ประเภทหม้อแปลง
        "sQName": watt.text, // กำลังไฟฟ้า วัตต์
        "sQCType": voltageSize, // กำลังไฟฟ้า วัตต์
        "statDate":
            wattMaintenance.text, //  กำลังไฟฟ้า วัตต์ ข้อมูลการบำรุงรักษา
        "endDate": latestMaintenanceDate.text, //  วันที่บำรุงรักษาล่าสุด
        "sQCType": serialNumber.text, //  serial number
        "sQCName": manufacturingCompany.text, //  บริษัทผู้ผลิต
        "underMaintenance":
            underMaintenance.toString(), //  อยู่ระหว่างบำรุงรักษา
      };

      Survey.saveData(context, data); // ไปบันทึก
    } else {
      alertForm(context, "แจ้งเตือน", "กรอกข้อมูลไม่ครบ");
    }
  }

  @override
  Widget build(BuildContext context) {
    double _width = MediaQuery.of(context).size.width;
    double _height = MediaQuery.of(context).size.height;

    return Material(
      color: AppColors.bgColor,
      child: Stack(
        children: <Widget>[
          Header.header1(context),
          Header.mainMenu(context),
          Container(
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 950),
            ),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                GestureDetector(
                  child: Text(
                    "แบบสำรวจ",
                    style: AppStyle.headTextStyle(context),
                  ),
                  onTap: () {
                    setState(() {
                      getTransformType('7CC64CA9-1DDF-49DC-970D-B25F83558B15');
                    });
                  },
                )
              ],
            ),
          ),
          Container(
//            color: Colors.teal,
            width: _width,
            height: mediaQuery(context, 'h', 1100),
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 1100),
              left: mediaQuery(context, 'w', 60),
              right: mediaQuery(context, 'w', 60),
            ),
            child: SingleChildScrollView(
              child: Column(
                children: <Widget>[
                  Row(
                    children: <Widget>[
                      _buildRow(context),
                    ],
                  ),
                  _buildSizeBox(context),
                  _buildSizeBox(context),
                  Container(
                    padding: EdgeInsets.only(left: 10, right: 10, bottom: 30),
                    width: mediaQuery(context, "w", 1005),
//                    height: mediaQuery(context, "h", 510),
                    decoration: BoxDecoration(
                      borderRadius: new BorderRadius.all(
                        Radius.circular(
                          mediaQuery(context, 'h', 50),
                        ),
                      ),
                      color: Colors.white,
                    ),
                    child: Stack(
                      children: <Widget>[
                        Column(
                          children: <Widget>[
                            Padding(
                              padding: EdgeInsets.only(
                                top: mediaQuery(context, "h", 20),
                              ),
                              child: Row(
                                mainAxisAlignment:
                                    MainAxisAlignment.spaceEvenly,
                                children: <Widget>[
                                  Container(
                                    child: Column(
                                      children: <Widget>[
                                        Text("วันที่เริ่มต้น"),
                                        Text("$startDate"),
                                      ],
                                    ),
                                  ),
                                  Container(
                                    width: mediaQuery(context, 'w', 2),
                                    height: mediaQuery(context, 'h', 110),
                                    color: Color(0xFFC6C6C6),
                                  ),
                                  Container(
                                    child: Column(
                                      children: <Widget>[
                                        Text("วันที่สิ้นสุด"),
                                        Text("$endDate"),
                                      ],
                                    ),
                                  ),
                                ],
                              ),
                            ),
                            _buildLine(context),
                            Row(
                              children: <Widget>[Text("รายละเอียด")],
                            ),
                            Text(
                              "หม้อแปลงไฟฟ้าเป็นอุปกรณ์ไฟฟ้าที่ใช้ในการส่งผ่านพลังงานจากวงจรไฟฟ้าหนึ่งไปยังอีกวงจร โดยอาศัยหลักการของแม่เหล็กไฟฟ้า โดยปกติจะใช้เชื่อมโยงระหว่างระบบไฟฟ้าแรงสูง และไฟฟ้าแรงต่ำ หม้อแปลงไฟฟ้าถือเป็นอุปกรณ์ที่สำคัญและมีมูลค่าสูงที่สุดในระบบส่งจ่ายไฟฟ้า หากหม้อแปลงไม่สามารถใช้งานได้ อาจทำให้เกิดไฟฟ้าดับเป็นบริเวณกว้าง",
                              style: TextStyle(
                                fontSize: mediaQuery(context, "w", 30),
                              ),
                            ),
                          ],
                        ),
                      ],
                    ),
                  ),
                  _buildSizeBox(context),
                  _buildTextMenu(context, "ประเภทหม้อแปลง :"),
                  _buildSizeBox(context),
                  _buildDropDown(context, _dropdownTransformType),
                  _buildSizeBox(context),
                  _buildTextMenu(context, "พิกัดหม้อแปลง :"),
                  _buildSizeBox(context),
                  Container(
                    padding: EdgeInsets.only(
                        left: 10, right: 10, bottom: 30, top: 10),
                    width: mediaQuery(context, "w", 1005),
//                    height: mediaQuery(context, "h", 510),
                    decoration: BoxDecoration(
                      borderRadius: new BorderRadius.all(
                        Radius.circular(
                          mediaQuery(context, 'h', 50),
                        ),
                      ),
                      color: Colors.white,
                    ),
                    child: Column(
                      children: <Widget>[
                        _buildTextMenu(context, "กำลังไฟฟ้า :"),
                        _buildSizeBox(context),
                        Row(
                          children: <Widget>[
                            _buildRowNumber(context, watt, 'ระบุกำลังไฟฟ้า'),
                            Text(
                              "  กิโลวัตต์",
                              style: TextStyle(
                                  fontSize: mediaQuery(context, "w", 30)),
                            ),
                          ],
                        ),
                        _buildSizeBox(context),
                        _buildTextMenu(context, "ขนาดแรงดัน :"),
                        _buildSizeBox(context),
                        Row(
                          children: <Widget>[
                            Row(
                              children: <Widget>[
                                _buildRadio(context, "22 KV", 22),
                                _buildRadio(context, "33 KV", 33),
                                _buildRadio(context, "115 KV", 115),
                              ],
                            ),
                          ],
                        )
                      ],
                    ),
                  ),
                  _buildSizeBox(context),
                  _buildTextMenu(context, "ข้อมูลการบำรุงรักษา :"),
                  _buildSizeBox(context),
                  Container(
                    padding: EdgeInsets.only(
                        left: 10, right: 10, bottom: 30, top: 10),
                    width: mediaQuery(context, "w", 1005),
//                    height: mediaQuery(context, "h", 510),
                    decoration: BoxDecoration(
                      borderRadius: new BorderRadius.all(
                        Radius.circular(
                          mediaQuery(context, 'h', 50),
                        ),
                      ),
                      color: Colors.white,
                    ),
                    child: Column(
                      children: <Widget>[
                        _buildTextMenu(context, "รอบการบำรุงรักษา :"),
                        _buildSizeBox(context),
                        Row(
                          children: <Widget>[
                            _buildRowNumber(
                                context, wattMaintenance, "ระบุจำนวน"),
                            Text(
                              "  กิโลวัตต์",
                              style: TextStyle(
                                  fontSize: mediaQuery(context, "w", 30)),
                            ),
                          ],
                        ),
                        _buildSizeBox(context),
                        _buildTextMenu(context, "วันที่บำรุงรักษาล่าสุด :"),
                        _buildSizeBox(context),
                        Row(
                          children: <Widget>[
                            Row(
                              children: <Widget>[
                                _buildRowTextFieldIcon(
                                    context, latestMaintenanceDate),
                              ],
                            ),
                          ],
                        ),
                      ],
                    ),
                  ),
                  _buildSizeBox(context),
                  _buildTextMenu(context, "Serial no. :"),
                  _buildSizeBox(context),
                  _buildRowNumberSR(context, serialNumber, "Serial no."),
                  _buildSizeBox(context),
                  _buildTextMenu(context, "บริษัทผู้ผลิต :"),
                  _buildSizeBox(context),
                  _buildTextField(
                      context, manufacturingCompany, "ระบุบริษัทผู้ผลิต"),
                  _buildSizeBox(context),
                  Row(
                    children: <Widget>[
                      Checkbox(
                        value: monVal,
                        onChanged: (bool value) {
                          setState(() {
                            monVal = value;
                            underMaintenance = value;
                          });
                          print("underMaintenance = $underMaintenance");
                        },
                      ),
                      Text("อยู่ระหว่างบำรุงรักษา"),
                    ],
                  ),
                  Row(
                    children: <Widget>[
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                        children: <Widget>[
                          _buildButton(
                              context, "ยกเลิก", Colors.white, AppColors.color),
                          SizedBox(
                            width: 10,
                          ),
                          _buildButton(
                              context, "บันทึก", AppColors.color, Colors.white),
                        ],
                      ),
                    ],
                  ),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }

  _buildButton(context, text, bgColor, fontColor) {
    return ButtonTheme(
      minWidth: mediaQuery(context, "w", 477),
      height: mediaQuery(context, "h", 120),
      child: FlatButton(
        shape: new RoundedRectangleBorder(
            borderRadius: new BorderRadius.circular(
              mediaQuery(context, "w", 50),
            ),
            side: BorderSide(color: AppColors.color)),
        color: bgColor,
        textColor: Colors.red,
        padding: EdgeInsets.all(
          mediaQuery(context, "w", 10),
        ),
        onPressed: () {
          if (text == "บันทึก") {
            save();
          } else {
            Navigator.of(context).pop(false);
          }
          print(text);
        },
        child: Text(
          text,
          style: TextStyle(
            fontSize: 14.0,
            color: fontColor,
          ),
        ),
      ),
    );
  }

  _buildRadio(context, text, int value) {
//    double _width = MediaQuery.of(context).size.width;

    return SizedBox(
//      width: _width,
      height: 30,
      child: Row(
        children: <Widget>[
          new Radio(
            value: value,
            groupValue: _radioValue,
            onChanged: _handleRadioValueChange,
          ),
          Text(text)
        ],
      ),
    );
  }

  void _handleRadioValueChange(int value) {
    setState(() {
      _radioValue = value;
      voltageSize = _radioValue.toString() + " KV";
    });
    print(voltageSize);
  }

  _buildRowTextFieldIcon(context, controller) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.spaceEvenly,
      children: <Widget>[
        Container(
          height: mediaQuery(context, 'h', 105),
          width: mediaQuery(context, 'w', 790),
          child: GestureDetector(
            onTap: () async {
              DateTime newDate = await showDatePicker(
                context: context,
                initialDate: DateTime.now(),
                firstDate: DateTime(DateTime.now().year),
                lastDate: DateTime(DateTime.now().year, 12, 31),
//                      locale: Locale("th", "TH"),
                builder: (context, child) {
                  return Theme(
                    data: Theme.of(context).copyWith(
                      primaryColor: AppColors.color,
                      accentColor: AppColors.color_gold,
                      colorScheme: ColorScheme.light(
                        primary: AppColors.color,
                      ),
                      buttonTheme: ButtonThemeData(
                        textTheme: ButtonTextTheme.primary,
                      ),
                    ),
                    child: Container(
                      height: 450,
                      width: 700,
                      child: child,
                    ),
                  );
                },
              );
              if (newDate != null) {
                var dtArray = newDate.toString().split(" ");
                setState(
                  () {
                    var formatter = DateFormat.yMd();
                    var showDate =
                        formatter.formatInBuddhistCalendarThai(newDate);
                    controller.text = showDate;
//                  strcontroller =dtArray[0];
                  },
                );
              }
            },
            child: Container(
              height: mediaQuery(context, 'h', 105),
              width: mediaQuery(context, 'w', 490),
              padding: EdgeInsets.only(
                left: mediaQuery(context, 'h', 20),
                right: mediaQuery(context, 'h', 20),
              ),
              decoration: BoxDecoration(
                borderRadius: new BorderRadius.all(
                  Radius.circular(
                    mediaQuery(
                      context,
                      'h',
                      150,
                    ),
                  ),
                ),
                border: Border.all(
                  color: Colors.grey[500],
                ),
                color: Colors.white,
              ),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: <Widget>[
                  Text(controller.text),
                  Icon(
                    Icons.calendar_today,
                    color: Colors.grey,
                    size: mediaQuery(
                      context,
                      'h',
                      80,
                    ),
                  ),
                ],
              ),
            ),
          ),
        ),
      ],
    );
  }

  _buildTextField(context, TextEditingController controller, String hint) {
    return Container(
      height: mediaQuery(context, 'h', 110),
      width: mediaQuery(context, 'w', 1005),
      child: new TextField(
        controller: controller,
        enabled: true,
        decoration: new InputDecoration(
            border: new OutlineInputBorder(
              borderRadius: const BorderRadius.all(
                const Radius.circular(50.0),
              ),
            ),
            hintText: hint,
            filled: true,
            counterText: "",
            contentPadding: EdgeInsets.fromLTRB(10.0, 0.0, 20.0, 10.0),
            hintStyle: new TextStyle(color: Colors.grey[500], fontSize: 9),
            fillColor: Colors.white70),
      ),
    );
  }

  _buildRowNumberSR(context, TextEditingController controller, String hint) {
    return Container(
      height: mediaQuery(context, 'h', 110),
      width: mediaQuery(context, 'w', 1005),
      child: new TextField(
        keyboardType: TextInputType.number,
        controller: controller,
        enabled: true,
        decoration: new InputDecoration(
            border: new OutlineInputBorder(
              borderRadius: const BorderRadius.all(
                const Radius.circular(50.0),
              ),
            ),
            hintText: hint,
            filled: true,
            counterText: "",
            contentPadding: EdgeInsets.fromLTRB(10.0, 0.0, 20.0, 10.0),
            hintStyle: new TextStyle(color: Colors.grey[500], fontSize: 9),
            fillColor: Colors.white70),
      ),
    );
  }

  _buildRowNumber(context, TextEditingController controller, String hint) {
    return Container(
      height: mediaQuery(context, 'h', 110),
      width: mediaQuery(context, 'w', 790),
      child: new TextField(
        keyboardType: TextInputType.number,
        controller: controller,
        enabled: true,
        decoration: new InputDecoration(
            border: new OutlineInputBorder(
              borderRadius: const BorderRadius.all(
                const Radius.circular(50.0),
              ),
            ),
            hintText: hint,
            filled: true,
            counterText: "",
            contentPadding: EdgeInsets.fromLTRB(10.0, 0.0, 20.0, 10.0),
            hintStyle: new TextStyle(color: Colors.grey[500], fontSize: 9),
            fillColor: Colors.white70),
      ),
    );
  }

  _buildDropDown(context, List<KeyValueModel> _dropdownValues) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        Container(
          height: mediaQuery(context, 'h', 110),
          width: mediaQuery(context, 'w', 1005),
          padding: EdgeInsets.symmetric(horizontal: 10.0),
          decoration: BoxDecoration(
            color: Colors.white,
            borderRadius: BorderRadius.circular(53.0),
            border: Border.all(
                color: AppColors.color_border,
                style: BorderStyle.solid,
                width: 0.80),
          ),
          child: DropdownButtonHideUnderline(
            child: DropdownButton<KeyValueModel>(
              style: TextStyle(
                color: AppColors.Black,
                fontSize: mediaQuery(context, "w", 30),
              ),
              items: _dropdownValues
                  .map((value) => DropdownMenuItem(
                        child: Text(value.key),
                        value: value,
                      ))
                  .toList(),
              onChanged: (value) {
                setState(() {
                  print(value.key);
                  transformerType = value.value.toString();
                });
                print("value : " + transformerType);
              },
              isExpanded: true,
              value: _dropdownValues.first,
            ),
          ),
        ),
      ],
    );
  }

  _buildTextMenu(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        Text(
          text,
          style: TextStyle(
              fontSize: mediaQuery(context, 'h', 30), color: AppColors.Black),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildLine(context) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        Expanded(
          child: new Container(
            padding: EdgeInsets.only(
              left: mediaQuery(context, "w", 10),
              right: mediaQuery(context, "w", 10),
            ),
            child: Divider(
              color: AppColors.color_line,
            ),
          ),
        ),
      ],
    );
  }

  _buildSizeBox(context) {
    return SizedBox(
      height: mediaQuery(context, "h", 15),
    );
  }

  _buildRow(context) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        Row(
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            Container(
              width: mediaQuery(context, 'w', 1005),
              height: mediaQuery(context, 'h', 150),
              decoration: BoxDecoration(
                borderRadius: new BorderRadius.all(
                  Radius.circular(
                    mediaQuery(context, 'h', 140),
                  ),
                ),
                boxShadow: [
                  BoxShadow(
                    offset: Offset(2.0, 2.0),
                    blurRadius: 10.0,
                    color: Color(0xFF000000).withOpacity(0.10),
                  ),
                ],
                color: Colors.white,
              ),
              child: Row(
                children: <Widget>[
                  Container(
                    width: mediaQuery(context, 'w', 230),
                    height: mediaQuery(context, 'h', 150),
                    padding: EdgeInsets.all(
                      mediaQuery(context, 'h', 35),
                    ),
                    decoration: BoxDecoration(
                      borderRadius: new BorderRadius.all(
                        Radius.circular(
                          mediaQuery(context, 'h', 70),
                        ),
                      ),
                      boxShadow: [
                        appShadow(),
                      ],
                      color: AppColors.color,
                    ),
                    child: Text(
                      'S0001',
                      textAlign: TextAlign.center,
                      style: TextStyle(
                        fontSize: mediaQuery(context, 'h', 50),
                        color: Colors.white,
                        fontWeight: FontWeight.bold,
                      ),
                    ),
                  ),
                  Container(
//                    color: Colors.red,
                    width: mediaQuery(context, 'h', 800),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: <Widget>[
                        Text(
                          'แบบสำรวจหม้อแปลงไฟฟ้า',
                          textAlign: TextAlign.center,
                          style: TextStyle(
                            fontSize: mediaQuery(context, 'h', 50),
                            color: Color(0xFF383838),
                          ),
                        ),
                      ],
                    ),
                  ),
                ],
              ),
            ),
          ],
        ),
      ],
    );
  }
} //class

class KeyValueModel {
  var key;
  var value;

  KeyValueModel({this.key, this.value});
}

class TransformList {
  String ssc_id;
  String sqc_id;
  String ssc_name;
  String ssc_type;
  var ssc_sequence;

  TransformList({
    this.ssc_id,
    this.sqc_id,
    this.ssc_name,
    this.ssc_type,
    this.ssc_sequence,
  });
}
