import 'package:flutter/material.dart';
import 'package:font_awesome_flutter/font_awesome_flutter.dart';
import 'package:get/get.dart';
import 'package:mwf_app/service/alert.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/navigator.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/shadow.dart';
import 'package:mwf_app/service/strings.dart';
import 'package:mwf_app/model/Survey_model.dart';
import 'package:mwf_app/set5/save_survey_web_view.dart';
import 'package:mwf_app/set6/save_survey_list.dart';
import 'package:mwf_app/set6/survey_save.dart';
import 'package:need_resume/need_resume.dart';
import 'package:mwf_app/set5/save_survey.dart';

//Survey_model
class service_survey extends StatefulWidget {
  final sQId, sQCode, sQName;
  service_survey(this.sQId, this.sQCode, this.sQName);

  @override
  _service_surveyState createState() =>
      _service_surveyState(this.sQId, this.sQCode, this.sQName);
}

class _service_surveyState extends ResumableState<service_survey> {
//  List<dynamic> surveyList = Survey.surveyList; // รายการแบบสำรวจ
  bool isLoading = false;

  var sQId, sQCode, sQName;
  _service_surveyState(this.sQId, this.sQCode, this.sQName);
  @override
  void onReady() {
    // Implement your code inside here
    loadData();
    print('Screen is ready!  service_survey');
  }

  @override
  void onResume() {
    // Implement your code inside here
    loadData();
    print('Screen is resumed!');
  }

  @override
  void onPause() {
    // Implement your code inside here
    print('Screen is paused!');
  }

  loadData() async {
    print("service_survey : loadData");
    setState(() {
      isLoading = true;
    });
    try {
      final list = await Survey.getDataBySQID(
          this.sQId); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
      SurveyQuestionRecordReadList.dataList.clear();
      setState(() {
        list.forEach((v) {
          final surveyList = SurveyQuestionRecordReadList.fromJsonList(v);
          SurveyQuestionRecordReadList.dataList.add(surveyList);
        });
      });
      await new Future.delayed(const Duration(milliseconds: 2000));
      setState(() {
        isLoading = false;
      });
    } catch (e) {
      print(e);
    }
  }

  @override
  Widget build(BuildContext context) {
    if (isLoading == true) {
      AppLoader.show();
    }
    if (isLoading == false) {
      AppLoader.hide();
    }
    double _width = MediaQuery.of(context).size.width;
    double _height = MediaQuery.of(context).size.height;
    Header.routes = SaveSurveyList();
    return Material(
      color: AppColors.bgColor,
      child: WillPopScope(
        onWillPop: () async {
          Get.offAll(Header.routes);
          return false;
        },
        child: Stack(
          children: <Widget>[
            Header.headerListPage(context),
            Header.mainMenu(context),
            Container(
              width: _width,
              height: mediaQuery(context, 'h', 1100),
              margin: EdgeInsets.only(
                top: mediaQuery(context, 'h', 1050),
                left: mediaQuery(context, 'w', 40),
                right: mediaQuery(context, 'w', 40),
              ),
              child: Column(
                children: <Widget>[
                  _buildHeaderContent(
                      context, this.sQCode, this.sQName, this.sQId),
                ],
              ),
            ),
            Container(
              width: _width,
              height: mediaQuery(context, 'h', 920),
              margin: EdgeInsets.only(
                top: mediaQuery(context, 'h', 1300),
                left: mediaQuery(context, 'w', 60),
                right: mediaQuery(context, 'w', 60),
              ),
              child: SingleChildScrollView(
                child: Column(
                  children: <Widget>[
                    Column(
                      children: List.generate(
                          SurveyQuestionRecordReadList.dataList.length, (index) {
                        return _buildContent(
                            context,
                            (index + 1).toString(),
                            SurveyQuestionRecordReadList
                                .dataList[index].sRcqSequence
                                .toString(),
                            SurveyQuestionRecordReadList.dataList[index].createBy,
                            SurveyQuestionRecordReadList
                                .dataList[index].strCreateDate,
                            SurveyQuestionRecordReadList.dataList[index].sRcqId,
                            index);
                      }),
                    ),
                  ],
                ),
              ),
            )
          ],
        ),
      ),
    );
  }

  _buildHeaderContent(context, String code, String detail, String sQId) {
    return Container(
      margin: EdgeInsets.only(
        bottom: mediaQuery(context, 'h', 35),
      ),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.center,
        children: <Widget>[
          GestureDetector(
            onTap: () {
              // print("Code : " + code + ", SQ_ID : " + sQId);
            },
            child: Container(
              width: mediaQuery(context, 'w', 1008),
              height: mediaQuery(context, 'h', 150),
              decoration: BoxDecoration(
                borderRadius: new BorderRadius.all(
                  Radius.circular(
                    mediaQuery(context, 'h', 140),
                  ),
                ),
                boxShadow: [
                  BoxShadow(
                    offset: Offset(2.0, 2.0),
                    blurRadius: 10.0,
                    color: Color(0xFF000000).withOpacity(0.10),
                  ),
                ],
                color: Colors.white,
              ),
              child: Row(
                children: <Widget>[
                  Container(
                    width: mediaQuery(context, 'w', 310),
                    height: mediaQuery(context, 'h', 150),
                    padding: EdgeInsets.all(
                      mediaQuery(context, 'h', 35),
                    ),
                    decoration: BoxDecoration(
                      borderRadius: new BorderRadius.all(
                        Radius.circular(
                          mediaQuery(context, 'h', 70),
                        ),
                      ),
                      boxShadow: [
                        appShadow(),
                      ],
                      color: AppColors.color,
                    ),
                    child: Text(
                      code,
                      textAlign: TextAlign.center,
                      style: TextStyle(
                        fontSize: mediaQuery(context, 'h', 50),
                        color: Colors.white,
                        fontWeight: FontWeight.bold,
                      ),
                    ),
                  ),
                  Container(
                    //color: Colors.red,
                    padding: EdgeInsets.only(
                      left: mediaQuery(context, 'w', 25),
                    ),
                    width: mediaQuery(context, 'h', 640),
                    child: Text(
                      detail,
                      style: TextStyle(
                        fontSize: mediaQuery(context, 'h', 50),
                        color: Color(0xFF383838),
                      ),
                    ),
                  ),
                  Container(
                    //color: Colors.red,
                    width: mediaQuery(context, 'h', 100),
                    child: GestureDetector(
                      onTap: () async {
                        print('click Add');
                        print(sQId);
                        final result = await push(
                          context,
                          MaterialPageRoute(
                              builder: (context) =>
                                  SaveSurveyWebView(this.sQId, "")),
                        );
                        if (result != null) {
                          AppLoader.showSuccess("บันทึกสำเร็จ");
                        }
                      },
                      child: Row(
                        children: <Widget>[
                          Icon(
                            Icons.add_circle_outline,
                            size: mediaQuery(context, 'h', 95),
                            color: AppColors.color,
                          ),
                          SizedBox(
                            width: mediaQuery(context, 'w', 1),
                          ),
                          // Text(
                          //   "เพิ่ม",
                          //   style: TextStyle(
                          //     color: AppColors.color,
                          //     fontSize: mediaQuery(context, 'h', 40),
                          //   ),
                          // ),
                        ],
                      ),
                    ),
                  ),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }

  _buildContent(
      context, number, sequence, answerer, answerDate, sRcqId, index) {
    return Container(
      width: mediaQuery(context, 'w', 1005),
//      height: mediaQuery(context, 'h', 380),
      padding: EdgeInsets.all(
        mediaQuery(context, 'h', 50),
      ),
      margin: EdgeInsets.only(
        bottom: mediaQuery(context, 'h', 40),
      ),
      decoration: BoxDecoration(
        borderRadius: new BorderRadius.all(
          Radius.circular(
            mediaQuery(context, 'h', 20),
          ),
        ),
        boxShadow: [
          appShadow(),
        ],
        color: Colors.white,
      ),
      child: Row(
        children: <Widget>[
          GestureDetector(
            onTap: () {},
            child: Container(
              width: mediaQuery(context, 'w', 780),
              child: Wrap(
                spacing: 5.0,
                runSpacing: 5.0,
                direction: Axis.vertical,
                children: <Widget>[
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: <Widget>[
                      // Row(
                      //   crossAxisAlignment: CrossAxisAlignment.start,
                      //   children: <Widget>[
                      //     Text(
                      //       'ลำดับ : ',
                      //       style: TextStyle(
                      //         color: AppColors.color_text,
                      //         fontSize: mediaQuery(context, 'h', 42),
                      //       ),
                      //     ),
                      //     Text(
                      //       sequence,
                      //       style: TextStyle(
                      //         color: AppColors.color_text,
                      //         fontSize: mediaQuery(context, 'h', 40),
                      //       ),
                      //     ),
                      //   ],
                      // ),
                      Row(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: <Widget>[
                          Text(
                            'วันที่ข้อมูล : ',
                            style: TextStyle(
                              color: AppColors.color_text,
                              fontSize: mediaQuery(context, 'h', 42),
                            ),
                          ),
                          Text(
                            answerDate,
                            style: TextStyle(
                              color: AppColors.color_text,
                              fontSize: mediaQuery(context, 'h', 40),
                            ),
                          ),
                        ],
                      ),
                      Row(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: <Widget>[
                          Text(
                            'รหัสข้อมูล : ',
                            style: TextStyle(
                              color: AppColors.color_text,
                              fontSize: mediaQuery(context, 'h', 42),
                            ),
                          ),
                          Text(
                            number,
                            style: TextStyle(
                              color: AppColors.color_text,
                              fontSize: mediaQuery(context, 'h', 40),
                            ),
                          ),
                        ],
                      ),
                      Row(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: <Widget>[
                          Text(
                            'ผู้บันทึกข้อมูล : ',
                            style: TextStyle(
                              color: AppColors.color_text,
                              fontSize: mediaQuery(context, 'h', 42),
                            ),
                          ),
                          Text(
                            answerer,
                            style: TextStyle(
                              color: AppColors.color_text,
                              fontSize: mediaQuery(context, 'h', 40),
                            ),
                          ),
                        ],
                      ),
                    ],
                  ),
                ],
              ),
            ),
          ),
          Column(
            children: <Widget>[
              Container(
                height: mediaQuery(context, 'h', 20),
              ),
              GestureDetector(
                onTap: () {
                  print('onEdit');
                  push(
                    context,
                    MaterialPageRoute(
                        builder: (context) =>
                            SaveSurveyWebView(this.sQId, sRcqId)),
                  );
                },
                child: Container(
                  margin: EdgeInsets.only(bottom: 10),
                  alignment: Alignment.center,
                  padding: EdgeInsets.only(left: mediaQuery(context, 'w', 70)),
                  child: Center(
                    child: Icon(
                      FontAwesomeIcons.pencilAlt,
                      size: mediaQuery(context, 'h', 60),
                      color: AppColors.color_gold,
                    ),
                  ),
                ),
              ),
              GestureDetector(
                onTap: () {
                  print('service_survey : on del');
                  delData(sRcqId);
                },
                child: Container(
                  margin: EdgeInsets.only(top: 10),
                  alignment: Alignment.center,
                  padding: EdgeInsets.only(left: mediaQuery(context, 'w', 70)),
                  child: Center(
                    child: Icon(
                      FontAwesomeIcons.trashAlt,
                      size: mediaQuery(context, 'h', 60),
                      color: AppColors.color_gold,
                    ),
                  ),
                ),
              ),
            ],
          )
        ],
      ),
    );
  }

  delData(String sRcq_Id) async {
    bool conf = await alertConfirm(context, "แจ้งเตือน", "ยืนยันการลบ");
    if (conf == true) {
      var chk = await Survey.deleteData(context, sRcq_Id);
      if (chk == true) {
        print('loadData');
        loadData();
      }
    }
  }
}
