import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:grouped_buttons/grouped_buttons.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/style.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/model/ResearchAnswer_model.dart';

class AnswerQuestion extends StatefulWidget {
  final RQId, RQCode, RQName;
  AnswerQuestion(this.RQId, this.RQCode, this.RQName);
  @override
  _AnswerQuestionState createState() =>
      _AnswerQuestionState(this.RQId, this.RQCode, this.RQName);
}

class _AnswerQuestionState extends State<AnswerQuestion> {
  var RQId, RQCode, RQName;
  _AnswerQuestionState(this.RQId, this.RQCode, this.RQName);
  String userElectricTrain = ""; // ท่านเคยใช้รถไฟฟ้าหรือไม่
  String driveElectric = ""; // ท่านเคยขัยรถไฟฟ้าหรือไม่
  String typeOfElectricTrain = ""; // เคยใช้รถไฟฟ้าประภทไหน
  List<QuestionChoice> dataChoiceType3 = [];
  String userElectricTrainBTS = ""; // เคยใช้รถไฟฟ้าประภทไหนมากที่สุด
  String userElectricTrainMRT = ""; // เคยใช้รถไฟฟ้าประภทไหนมากที่สุด
  String userElectricTrainBRT = ""; // เคยใช้รถไฟฟ้าประภทไหนมากที่สุด

  String _rqId = "";

  TextEditingController reason =
      TextEditingController(); // เหตุผลที่ท่านขับรถไฟฟ้าในการเดินทาง
  QuestionChoice selectedQuestion = null;
  // state variable
  bool radioBTS = false;
  bool radioMRT = false;
  bool radioBRT = false;
  int _radioValue = 0;
  int _radioValueTypeOfElectricTrain1 = 0;
  int _radioValueTypeOfElectricTrain2 = 0;
  int _radioValueTypeOfElectricTrain3 = 0;
  bool bts = false;
  bool mrt = false;
  bool brt = false;
  int head = 1;
  var listQuestion;
//  Map selected = new Map();
  List rowHeaders = new List();
  List columnHeaders = new List();
  Map selectedtype1 = new Map();
  Map selectedtype2 = new Map();
  Map selectedtype3 = new Map();
  Map selectedtype4 = new Map();
  List<QuestionChoice> dataChoice = [];
  List<AnswerList> listAnswer = [];
  @override
  void initState() {
    super.initState();
    loadData();
//    saveHeaders();
  }

  saveHeaders() {
    //Saving All Headers
    columnHeaders.addAll(["น้อยที่สุด", "น้อย", "ปานกลาง", "มาก", "มากที่สุด"]);
    rowHeaders.addAll(["MTN", "Vodafone", "Tigo", "Expresso", "Glo"]);
  }

  loadData() async {
    columnHeaders.addAll(["น้อยที่สุด", "น้อย", "ปานกลาง", "มาก", "มากที่สุด"]);
    listQuestion = await ResearchAnswer.getData(RQId);

    print(listQuestion);
    debugPrint(listQuestion["QuestionDetail"].toString());
    // debugPrint(listQuestion['ResearchQuestionModel']['RQ_Id'.toString()]);

    setState(() {
      _rqId = listQuestion['ResearchQuestionModel']['RQ_Id'].toString();
    });

    listAnswer.clear();
    setState(() {
      final listQuestionType = listQuestion["QuestionDetail"];
      listQuestionType.forEach((v) {
        final QuestionList = ResearchAnswer.fromJson(v);
//        dataChoice = QuestionList.dataChoice;
        ResearchAnswer.data.add(QuestionList);
        /*  for(int i = 0;i<QuestionList.dataChoice.length;i++){
          listAnswer.add(AnswerList(QuestionList.dataChoice[i].RQC_Id,QuestionList.dataChoice[i].RQD_Id,AppUrl.CustomerID,""));
        }*/
        if (QuestionList.RQD_Type == "3") {
          rowHeaders.clear();
          for (int i = 0; i < QuestionList.dataChoice.length; i++) {
            rowHeaders.add(QuestionList.dataChoice[i].RQC_Name);
          }
        }
      });
    });
  }

  save() async {
//    if (await checkForm([
//      userElectricTrain,
//      typeOfElectricTrain,
//      userElectricTrainBTS,
//      userElectricTrainMRT,
//      userElectricTrainBRT,
//      reason.text,
//    ])) {
    List lists = [
      {
        "RQC_Id": "63cf59dd-42b0-46b5-aa4c-2d6b7a3fc8ae",
        "RQD_Id": "70d655c7-6659-4fc9-b6c2-a2cf24023b87",
        "customerId": "39201517-6938-4850-96af-b65ef84e4e5b",
        "RA_Answer1": "น้อย"
      }
    ];

    /* for(int i=0;i<listAnswer.length;i++){
        for(int a=0;a<selectedtype1.length;a++){
          if(selectedtype1[listAnswer[i].RQC_Id.toString()] !=""){
            if(selectedtype1[listAnswer[i].RQC_Id.toString()] !=null) {
              listAnswer[i].RA_Answer1 =
              selectedtype1[listAnswer[i].RQC_Id.toString()];
            }
          }
        }
        for(int a=0;a<selectedtype2.length;a++){
          if(selectedtype2[listAnswer[i].RQC_Id.toString()] !=""){
            if(selectedtype2[listAnswer[i].RQC_Id.toString()] !=null) {
              listAnswer[i].RA_Answer1 =
              selectedtype2[listAnswer[i].RQC_Id.toString()];
            }
          }
        }
        for(int a=0;a<selectedtype3.length;a++){
          if(selectedtype3[listAnswer[i].RQC_Id.toString()] !=""){
            if(selectedtype3[listAnswer[i].RQC_Id.toString()] !=null) {
              listAnswer[i].RA_Answer1 =
              selectedtype3[listAnswer[i].RQC_Id.toString()];
            }
          }
        }
        for(int a=0;a<selectedtype4.length;a++){
          if(selectedtype4[listAnswer[i].RQC_Id.toString()] !=""){
            if(selectedtype4[listAnswer[i].RQC_Id.toString()] !=null) {
              listAnswer[i].RA_Answer1 =
              selectedtype4[listAnswer[i].RQC_Id.toString()];
            }
          }
        }
      }*/

    listAnswer.clear();
    for (int t = 0; t < ResearchAnswer.data.length; t++) {
      for (int m = 0; m < ResearchAnswer.data[t].dataChoice.length; m++) {
        if (ResearchAnswer.data[t].dataChoice[m].RQC_Ans != "") {
          if (ResearchAnswer.data[t].dataChoice[m].RQC_Ans != null) {
            listAnswer.add(AnswerList(
              _rqId,
              ResearchAnswer.data[t].dataChoice[m].RQC_Id,
              ResearchAnswer.data[t].dataChoice[m].RQD_Id,
              AppUrl.CustomerID,
              ResearchAnswer.data[t].dataChoice[m].RQC_Ans,
              AppUrl.userName,
            ));
          }
        }
      }
    }
    /* for(int j=0;j<listAnswer.length;j++){
        if(listAnswer[j].RA_Answer1 == ""){
          listAnswer.removeAt(j);
        }
        if(listAnswer[j].RA_Answer1 == null){
          listAnswer.removeAt(j);
        }
      }*/

    bool isSs = await ResearchAnswer.saveData(context, listAnswer);
//    } else {
//      alertForm(context, "แจ้งเตือน", "กรอกข้อมูลไม่ครบ");
//    }
    if (isSs) {
      Navigator.pop(context);
    }
  }

//New
  @override
  Widget build(BuildContext context) {
    double _width = MediaQuery.of(context).size.width;
    double _height = MediaQuery.of(context).size.height;

    return Material(
      color: AppColors.bgColor,
      child: Stack(
        children: <Widget>[
          Header.header2(context),
          Header.mainMenu(context),
          Container(
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 350),
            ),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                Text(
                  "ตอบแบบสอบถาม",
                  style: AppStyle.headTextStyle(context),
                )
              ],
            ),
          ),
          Container(
//            color: Colors.red,
            width: _width,
            height: mediaQuery(context, 'h', 1760),
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 460),
              left: mediaQuery(context, 'w', 60),
              right: mediaQuery(context, 'w', 60),
            ),
            child: SingleChildScrollView(
              child: Column(
                children: <Widget>[
                  _buildTextMenu(
                      context,
                      (this.RQCode == null ? "" : this.RQCode) +
                          " : " +
                          this.RQName),
                  _buildSizeBox(context),
                  _buildSizeBox(context),
                  if (ResearchAnswer.data.length != 0)
                    Column(
                      children:
                          List.generate(ResearchAnswer.data.length, (index) {
                        return Column(
                          children: <Widget>[
                            buildRowQuestion(context, (index + 1).toString(),
                                ResearchAnswer.data[index].RQD_Question),
                            if (ResearchAnswer.data[index].RQD_Type ==
                                "1") //Redio
//                            for(int i=0;i<ResearchAnswer.data[index].dataChoice.length;i++)
//                            _buildRowRadioType1(context,ResearchAnswer.data[index].dataChoice),
//                              _buildRowRadioType1Old(context,ResearchAnswer.data[index].dataChoice[i].RQC_Name,i+1,ResearchAnswer.data[index].dataChoice[i].RQC_Id),
                              _buildRowGroupRadioType1(context,
                                  ResearchAnswer.data[index].dataChoice),
                            if (ResearchAnswer.data[index].RQD_Type ==
                                "2") //CheckBox
//                            for(int i=0;i<ResearchAnswer.data[index].dataChoice.length;i++)
//                              _buildCheckBoxType2(context,ResearchAnswer.data[index].dataChoice[i].RQC_Name) ,
                              _buildCheckBoxType2(context,
                                  ResearchAnswer.data[index].dataChoice),
                            if (ResearchAnswer.data[index].RQD_Type ==
                                "3") //Redio Rang
//                            for(int i=0;i<ResearchAnswer.data[index].dataChoice.length;i++)
                              _buildRowRadioRangType3(context, 0,
                                  ResearchAnswer.data[index].dataChoice),
                            if (ResearchAnswer.data[index].RQD_Type ==
                                "4") //Text Box
                              _buildTextArea(
                                  context,
                                  new TextEditingController(),
                                  ResearchAnswer.data[index].dataChoice),
                            _buildSizeBox(context),
                            _buildSizeBox(context),
                          ],
                          /*_buildRowByType(

                        context,
                        (index + 1).toString(),
                        ResearchQuestion.data[index].rQcode,
                        ResearchQuestion.data[index].rQName,
                        ResearchQuestion.data[index].startDate,
                        ResearchQuestion.data[index].endDate,
                        index,*/
                        );
                      }),
                    ),
                  /*  _buildTextMenu(context, "1. ท่านเคยใช้รถไฟฟ้าหรือไม่"),
                  _buildSizeBox(context),
                  Row(
                    children: <Widget>[
                      _buildRadio(context, "เคย", 1),
                    ],
                  ),
                  Row(
                    children: <Widget>[
                      _buildRadio(context, "ไม่เคย", 0),
                    ],
                  ),
                  _buildLine(context),
                  _buildSizeBox(context),*/

//                  _buildTextMenu(context, "2. ท่านเคยใช้รถไฟฟ้าประเภทไหน"),
//                  _buildSizeBox(context),
//                  Row(
//                    mainAxisAlignment: MainAxisAlignment.spaceAround,
//                    children: <Widget>[
//                      Row(
//                        children: <Widget>[
//                          Checkbox(
//                            value: radioBTS,
//                            onChanged: (bool value) {
//                              setState(() {
//                                radioBTS = value;
//                                if (value == true) {
//                                  typeOfElectricTrain = "BTS";
//                                } else {
//                                  typeOfElectricTrain = "";
//                                }
//                              });
//                              print(typeOfElectricTrain);
//                            },
//                          ),
//                          Text("BTS"),
//                        ],
//                      ),
//                      Row(
//                        children: <Widget>[
//                          Checkbox(
//                            value: radioMRT,
//                            onChanged: (bool value) {
//                              setState(() {
//                                radioMRT = value;
//                                if (value == true) {
//                                  typeOfElectricTrain = "MRT";
//                                } else {
//                                  typeOfElectricTrain = "";
//                                }
//                              });
//                              print(typeOfElectricTrain);
//                            },
//                          ),
//                          Text("MRT"),
//                        ],
//                      ),
//                      Row(
//                        children: <Widget>[
//                          Checkbox(
//                            value: radioBRT,
//                            onChanged: (bool value) {
//                              setState(() {
//                                radioBRT = value;
//                                if (value == true) {
//                                  typeOfElectricTrain = "BRT";
//                                } else {
//                                  typeOfElectricTrain = "";
//                                }
//                              });
//                              print(typeOfElectricTrain);
//                            },
//                          ),
//                          Text("BRT"),
//                        ],
//                      ),
//                    ],
//                  ),
//                  _buildLine(context),
//                  _buildSizeBox(context),
/*                  _buildTextMenu(
                      context, "3. ท่านเคยใช้รถไฟฟ้าประเภทไหนมากที่สุด"),
                  _buildSizeBox(context),
                  _buildSizeBox(context),
                  Column(
                    children: <Widget>[
                      Container(
                        width: mediaQuery(context, 'w', 1005),
                        height: mediaQuery(context, 'h', 180),
                        decoration: BoxDecoration(
                          borderRadius: new BorderRadius.all(
                            Radius.circular(
                              mediaQuery(context, 'h', 20),
                            ),
                          ),
                          color: AppColors.color,
                        ),
                        child: Row(
                          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                          children: <Widget>[
                            Container(
                              width: mediaQuery(context, 'w', 160),
                              alignment: Alignment.center,
                              child: Text(
                                "หัวเรื่อง",
                                style: TextStyle(
                                  fontSize: mediaQuery(context, 'h', 40),
                                  color: Colors.white,
                                ),
                              ),
                            ),
                            Container(
                              width: mediaQuery(context, 'w', 2),
                              height: mediaQuery(context, 'h', 80),
                              color: Colors.white,
                            ),
                            Container(
                              width: mediaQuery(context, 'w', 140),
                              alignment: Alignment.center,
                              child: Text(
                                "น้อยที่สุด",
                                style: TextStyle(
                                  fontSize: mediaQuery(context, 'h', 40),
                                  color: Colors.white,
                                ),
                              ),
                            ),
                            Container(
                              width: mediaQuery(context, 'w', 2),
                              height: mediaQuery(context, 'h', 80),
                              color: Colors.white,
                            ),
                            Container(
                              width: mediaQuery(context, 'w', 140),
                              alignment: Alignment.center,
                              child: Text(
                                'น้อย',
                                style: TextStyle(
                                  fontSize: mediaQuery(context, 'h', 40),
                                  color: Colors.white,
                                ),
                              ),
                            ),
                            Container(
                              width: mediaQuery(context, 'w', 2),
                              height: mediaQuery(context, 'h', 80),
                              color: Colors.white,
                            ),
                            Container(
                              width: mediaQuery(context, 'w', 140),
                              alignment: Alignment.center,
                              child: Text(
                                "ปานกลาง",
                                style: TextStyle(
                                  fontSize: mediaQuery(context, 'h', 40),
                                  color: Colors.white,
                                ),
                              ),
                            ),
                            Container(
                              width: mediaQuery(context, 'w', 2),
                              height: mediaQuery(context, 'h', 80),
                              color: Colors.white,
                            ),
                            Container(
                              width: mediaQuery(context, 'w', 140),
                              alignment: Alignment.center,
                              child: Text(
                                "มาก",
                                style: TextStyle(
                                  fontSize: mediaQuery(context, 'h', 40),
                                  color: Colors.white,
                                ),
                              ),
                            ),
                            Container(
                              width: mediaQuery(context, 'w', 2),
                              height: mediaQuery(context, 'h', 80),
                              color: Colors.white,
                            ),
                            Container(
                              width: mediaQuery(context, 'w', 140),
                              alignment: Alignment.center,
                              child: Text(
                                "มากที่สุด",
                                style: TextStyle(
                                  fontSize: mediaQuery(context, 'h', 40),
                                  color: Colors.white,
                                ),
                              ),
                            ),
                          ],
                        ),
                      ),
                      _buildRow1(context, 1, "BTS", 5, 6, 7, 8, 9),
                      _buildRow2(context, 1, "MRT", 10, 11, 12, 13, 14),
                      _buildRow3(context, 1, "MRT", 15, 16, 17, 18, 19),
                    ],
                  ),
                  _buildSizeBox(context),
                  _buildSizeBox(context),*/
                  /* _buildTextMenu(
                      context, "4. เหตุผลที่ท่านช้รถไฟฟ้าในการเดินทาง"),
                  _buildSizeBox(context),
                  _buildTextArea(context, reason),
                  _buildSizeBox(context),
                  _buildSizeBox(context),*/
                  Row(
                    children: <Widget>[
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                        children: <Widget>[
                          _buildButton(
                              context, "ยกเลิก", Colors.white, AppColors.color),
                          SizedBox(
                            width: 10,
                          ),
                          _buildButton(
                              context, "ส่ง", AppColors.color, Colors.white),
                        ],
                      ),
                    ],
                  ),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }

  List<Widget> createRows(dataChoice) {
    List<String> list = [];
    var mapCheck = [];
    List<QuestionChoice> dataChoiceList = dataChoice;

    for (int i = 0; i < dataChoiceList.length; i++) {
      if (!mapCheck.contains(dataChoiceList[i].RQC_Name.toString())) {
        mapCheck.add(dataChoiceList[i].RQC_Name.toString());
        list.add(dataChoiceList[i].RQC_Name);
      }
    }
    List<Widget> allRows = new List(); //For Saving all Created Rows

    for (int i = 0; i < dataChoiceList.length; i++) {
      List<Widget> singleRow = new List(); //For creating a single row
      for (int j = 0; j < columnHeaders.length; j++) {
        singleRow.add(
          Container(
              width: mediaQuery(context, 'w', 160),
              alignment: Alignment.center,
              child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                  children: <Widget>[
                    Container(
                      width: mediaQuery(context, 'w', 2),
                      height: mediaQuery(context, 'h', 110),
                      color: Color(0xFFC6C6C6),
                    ),
                    Container(
                        width: mediaQuery(context, 'w', 140),
                        alignment: Alignment.centerLeft,
                        padding: EdgeInsets.symmetric(
                          horizontal: mediaQuery(context, 'h', 27),
                        ),
                        child: Radio(
                          value:
                              columnHeaders[j], //Index of created Radio Button
                          groupValue: selectedtype3[dataChoiceList[i].RQC_Id] !=
                                  null //If groupValue is equal to value, the radioButton will be selected
                              ? selectedtype3[dataChoiceList[i].RQC_Id]
                              : "",
                          onChanged: (value) {
                            this.setState(() {
                              selectedtype3[dataChoiceList[i].RQC_Id] = value;
                              dataChoiceList[i].RQC_Ans =
                                  value; //Adding selected rowName with its Index in a Map tagged "selected"
                              print("${dataChoiceList[i].RQC_Id} ==> $value");
                            });
                          },
                        ))
                  ])),
        );
      }
      //Adding single Row to allRows widget
      allRows.add(new Container(
          width: mediaQuery(context, 'w', 1005),
          height: mediaQuery(context, 'h', 170),
          decoration: BoxDecoration(
            borderRadius: new BorderRadius.only(
              bottomLeft: Radius.circular(
                mediaQuery(context, 'h', 20),
              ),
              bottomRight: Radius.circular(
                mediaQuery(context, 'h', 20),
              ),
            ),
            color: Colors.white,
          ),
          child: new Row(
            mainAxisAlignment: MainAxisAlignment.spaceEvenly,
            children: <Widget>[
              new Container(
                width: mediaQuery(context, 'w', 160),
                alignment: Alignment.center,
                child: Text(dataChoiceList[i].RQC_Name,
                    style: TextStyle(color: Colors.grey[800])),
              ),
            ]..addAll(singleRow), //Add single row here
          )));
    }
    return allRows; //Return all single rows
  }

  buildRowQuestion(context, index, name_question) {
    return Column(
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        _buildTextMenu(context, index + ". " + name_question),
        _buildSizeBox(context),
        _buildSizeBox(context),
      ],
    );
  }

  _buildRowRadioRangType3(context, index, dataChoice) {
    // เลขคี่

    return Column(
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        Column(
          children: <Widget>[
            if (index == 0)
              Container(
                width: mediaQuery(context, 'w', 1005),
                height: mediaQuery(context, 'h', 180),
                decoration: BoxDecoration(
                  borderRadius: new BorderRadius.all(
                    Radius.circular(
                      mediaQuery(context, 'h', 20),
                    ),
                  ),
                  color: AppColors.color,
                ),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                  children: <Widget>[
                    Container(
                      width: mediaQuery(context, 'w', 160),
                      alignment: Alignment.center,
                      child: Text(
                        "หัวเรื่อง",
                        style: TextStyle(
                          fontSize: mediaQuery(context, 'h', 40),
                          color: Colors.white,
                        ),
                      ),
                    ),
                    Container(
                      width: mediaQuery(context, 'w', 2),
                      height: mediaQuery(context, 'h', 80),
                      color: Colors.white,
                    ),
                    Container(
                      width: mediaQuery(context, 'w', 140),
                      alignment: Alignment.center,
                      child: Text(
                        "น้อยที่สุด",
                        style: TextStyle(
                          fontSize: mediaQuery(context, 'h', 40),
                          color: Colors.white,
                        ),
                      ),
                    ),
                    Container(
                      width: mediaQuery(context, 'w', 2),
                      height: mediaQuery(context, 'h', 80),
                      color: Colors.white,
                    ),
                    Container(
                      width: mediaQuery(context, 'w', 140),
                      alignment: Alignment.center,
                      child: Text(
                        'น้อย',
                        style: TextStyle(
                          fontSize: mediaQuery(context, 'h', 40),
                          color: Colors.white,
                        ),
                      ),
                    ),
                    Container(
                      width: mediaQuery(context, 'w', 2),
                      height: mediaQuery(context, 'h', 80),
                      color: Colors.white,
                    ),
                    Container(
                      width: mediaQuery(context, 'w', 140),
                      alignment: Alignment.center,
                      child: Text(
                        "ปานกลาง",
                        style: TextStyle(
                          fontSize: mediaQuery(context, 'h', 40),
                          color: Colors.white,
                        ),
                      ),
                    ),
                    Container(
                      width: mediaQuery(context, 'w', 2),
                      height: mediaQuery(context, 'h', 80),
                      color: Colors.white,
                    ),
                    Container(
                      width: mediaQuery(context, 'w', 140),
                      alignment: Alignment.center,
                      child: Text(
                        "มาก",
                        style: TextStyle(
                          fontSize: mediaQuery(context, 'h', 40),
                          color: Colors.white,
                        ),
                      ),
                    ),
                    Container(
                      width: mediaQuery(context, 'w', 2),
                      height: mediaQuery(context, 'h', 80),
                      color: Colors.white,
                    ),
                    Container(
                      width: mediaQuery(context, 'w', 140),
                      alignment: Alignment.center,
                      child: Text(
                        "มากที่สุด",
                        style: TextStyle(
                          fontSize: mediaQuery(context, 'h', 40),
                          color: Colors.white,
                        ),
                      ),
                    ),
                  ],
                ),
              ),

//              _buildRow1(context, 1, name, v1, v2, v3, v4, v5),
//              _buildRow1(context, 1, "BTS", 5, 6, 7, 8, 9),
//              _buildRow2(context, 1, "MRT", 10, 11, 12, 13, 14),
//              _buildRow3(context, 1, "รถเมล์", 15, 16, 17, 18, 19),
          ]..addAll(createRows(dataChoice)),
        ),
        /* _buildSizeBox(context),
          _buildSizeBox(context),*/
      ],
    );
  }

  _buildRowGroupRadioType1(context, dataChoice) {
    String strRQD_ID = dataChoice[0].RQD_Id.toString();
    List<String> list = [];
    var mapCheck = [];
    String _verticalGroupValue = dataChoice[0].RQC_Name.toString();

    List<String> _status = ["Pending", "Released", "Blocked"];
    List<QuestionChoice> dataChoiceList = dataChoice;
    for (int i = 0; i < dataChoiceList.length; i++) {
      if (!mapCheck.contains(dataChoiceList[i].RQC_Name.toString())) {
        mapCheck.add(dataChoiceList[i].RQC_Name.toString());
        list.add(dataChoiceList[i].RQC_Name);
      }
    }
    return Column(
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
//    for (int i = 0; i < dataChoiceList.length; i++)
        Column(
          children: <Widget>[
            RadioButtonGroup(
              labels: list,
//            onSelected: (String selected) => print(selected),
              onSelected: (String selected) {
                setState(() {
                  for (int i = 0; i < dataChoiceList.length; i++) {
                    if (selected == dataChoiceList[i].RQC_Name) {
                      dataChoiceList[i].RQC_Ans = selected;
                    } else {
                      dataChoiceList[i].RQC_Ans = "";
                    }
                  }
                });
              },
            ),
          ],
        )
      ],
    );
  }

  _buildRowRadioType1(context, dataChoice) {
    return Column(
        mainAxisAlignment: MainAxisAlignment.center,
        children: <Widget>[
          Column(
            children: <Widget>[]..addAll(createRadio(dataChoice)),
          )
        ]);
  }

  List<Widget> createRadio(dataChoice) {
    List<String> list = [];
    var mapCheck = [];
    List<QuestionChoice> dataChoiceList = dataChoice;

//    for(int i=0;i<dataChoiceList.length;i++) {
//      if (!mapCheck.contains(dataChoiceList[i].RQC_Name.toString())) {
//        mapCheck.add(dataChoiceList[i].RQC_Name.toString());
//        list.add(dataChoiceList[i].RQC_Name);
//      }
//    }
    List<Widget> singleRow = new List();
    for (int i = 0; i < dataChoiceList.length; i++) {
      //For creating a single row
//      for (int j = 0; j < 1; j++) {
      singleRow.add(
        Container(
//                  width: _width,
          height: 30,
          child: Row(children: <Widget>[
            new Radio(
              value: dataChoiceList[i].RQC_Name,
              //Index of created Radio Button
              groupValue: selectedtype1[dataChoiceList[i].RQC_Id] !=
                      null //If groupValue is equal to value, the radioButton will be selected
                  ? selectedtype1[dataChoiceList[i].RQC_Id]
                  : "",
              onChanged: (value) {
                this.setState(() {
                  selectedtype1[dataChoiceList[i].RQC_Id] =
                      value; //Adding selected rowName with its Index in a Map tagged "selected"
                  print("${dataChoiceList[i].RQC_Id} ==> $value");
                  dataChoiceList[i].RQC_Ans = value;
                });
              },
            ),
            Text(dataChoiceList[i].RQC_Name),
          ]),
        ),
      );

//      }

    }
    return singleRow;
    /*   return SizedBox(
//      width: _width,
      height: 30,
      child: Row(
        children: <Widget>[
          new Radio(
              value: value,
              groupValue: selectedtype1[ResearchAnswer.data[indexList].dataChoice[indexChoice]],
              onChanged: (value) {
                this.setState(() {
                  selectedtype1[ResearchAnswer.data[indexList].dataChoice[indexChoice]] =
                      value; //Adding selected rowName with its Index in a Map tagged "selected"
                  print("${selectedtype1[ResearchAnswer.data[indexList]
                      .dataChoice[indexChoice]]} ==> $value");
                });
              }
          ),
          Text(text)
        ],

      ),
    );*/
  }

  _buildCheckBoxType2(context, dataChoice) {
    List<String> list = [];
    var mapCheck = [];
    var mapChecked = [];
    List<QuestionChoice> dataChoiceList = dataChoice;

    for (int i = 0; i < dataChoiceList.length; i++) {
      if (!mapCheck.contains(dataChoiceList[i].RQC_Name.toString())) {
        mapCheck.add(dataChoiceList[i].RQC_Name.toString());
        list.add(dataChoiceList[i].RQC_Name);
      }
    }
    return CheckboxGroup(
      labels: list,
      onSelected: (List<String> checked) {
        print(checked.toString());
        selectedtype2.clear();
        mapChecked.clear();
        for (int i = 0; i < dataChoiceList.length; i++) {
          for (int j = 0; j < checked.length; j++) {
            if (checked[j].toString() == dataChoiceList[i].RQC_Name) {
              if (!mapChecked.contains(dataChoiceList[i].RQC_Name.toString())) {
                mapChecked.add(dataChoiceList[i].RQC_Name.toString());
                selectedtype2[dataChoiceList[i].RQC_Id] = checked[j].toString();
                dataChoiceList[i].RQC_Ans = checked[j].toString();
              }
              print(
                  "${selectedtype2[dataChoiceList[i].RQC_Id]} ==> ${checked[j].toString()}");
            }
          }
        }
      },
    );
  }

  _buildCheckBoxType2Old(context, name) {
    return Row(
      children: <Widget>[
        new Checkbox(
            value: name,
            onChanged: (bool newValue) {
              setState(() {
                selectedQuestion = name;
              });
            }),
        Text(name),
      ],
    );
  }

  _buildRowType2(context) {
    // เลขคี่
    return Column(
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        _buildTextMenu(context, "2. ท่านเคยใช้รถไฟฟ้าประเภทไหน"),
        _buildSizeBox(context),
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceAround,
          children: <Widget>[
            Row(
              children: <Widget>[
                Checkbox(
                  value: radioBTS,
                  onChanged: (bool value) {
                    setState(() {
                      radioBTS = value;
                      if (value == true) {
                        typeOfElectricTrain = "BTS";
                      } else {
                        typeOfElectricTrain = "";
                      }
                    });
                    print(typeOfElectricTrain);
                  },
                ),
                Text("BTS"),
              ],
            ),
            Row(
              children: <Widget>[
                Checkbox(
                  value: radioMRT,
                  onChanged: (bool value) {
                    setState(() {
                      radioMRT = value;
                      if (value == true) {
                        typeOfElectricTrain = "MRT";
                      } else {
                        typeOfElectricTrain = "";
                      }
                    });
                    print(typeOfElectricTrain);
                  },
                ),
                Text("MRT"),
              ],
            ),
            Row(
              children: <Widget>[
                Checkbox(
                  value: radioBRT,
                  onChanged: (bool value) {
                    setState(() {
                      radioBRT = value;
                      if (value == true) {
                        typeOfElectricTrain = "BRT";
                      } else {
                        typeOfElectricTrain = "";
                      }
                    });
                    print(typeOfElectricTrain);
                  },
                ),
                Text("BRT"),
              ],
            ),
          ],
        ),
        _buildLine(context),
        _buildSizeBox(context),
      ],
    );
  }

  _buildRowRadioType1Old(context, name, index, id) {
    return Row(
      children: <Widget>[
        _buildRadio(context, name, index, id),
      ],
    );
  }

  //Old
/*  @override
  Widget build(BuildContext context) {
    double _width = MediaQuery.of(context).size.width;
    double _height = MediaQuery.of(context).size.height;

    return Material(
      color: AppColors.bgColor,
      child: Stack(
        children: <Widget>[
          Header.header2(context),
          Header.mainMenu(context),
          Container(
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 350),
            ),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                Text(
                  "ตอบแบบสอบถาม",
                  style: AppStyle.headTextStyle(context),
                )
              ],
            ),
          ),
          Container(
//            color: Colors.red,
            width: _width,
            height: mediaQuery(context, 'h', 1760),
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 460),
              left: mediaQuery(context, 'w', 60),
              right: mediaQuery(context, 'w', 60),
            ),
            child: SingleChildScrollView(
              child: Column(
                children: <Widget>[
                  _buildTextMenu(context, "Q001 : ความพึงพอใจในการใช้รถไฟฟ้า"),
                  _buildSizeBox(context),
                  _buildSizeBox(context),
                  _buildTextMenu(context, "1. ท่านเคยใช้รถไฟฟ้าหรือไม่"),
                  _buildSizeBox(context),
                  Row(
                    children: <Widget>[
                      _buildRadio(context, "เคย", 1),
                    ],
                  ),
                  Row(
                    children: <Widget>[
                      _buildRadio(context, "ไม่เคย", 0),
                    ],
                  ),
                  _buildLine(context),
                  _buildSizeBox(context),
                  _buildTextMenu(context, "2. ท่านเคยใช้รถไฟฟ้าประเภทไหน"),
                  _buildSizeBox(context),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceAround,
                    children: <Widget>[
                      Row(
                        children: <Widget>[
                          Checkbox(
                            value: radioBTS,
                            onChanged: (bool value) {
                              setState(() {
                                radioBTS = value;
                                if (value == true) {
                                  typeOfElectricTrain = "BTS";
                                } else {
                                  typeOfElectricTrain = "";
                                }
                              });
                              print(typeOfElectricTrain);
                            },
                          ),
                          Text("BTS"),
                        ],
                      ),
                      Row(
                        children: <Widget>[
                          Checkbox(
                            value: radioMRT,
                            onChanged: (bool value) {
                              setState(() {
                                radioMRT = value;
                                if (value == true) {
                                  typeOfElectricTrain = "MRT";
                                } else {
                                  typeOfElectricTrain = "";
                                }
                              });
                              print(typeOfElectricTrain);
                            },
                          ),
                          Text("MRT"),
                        ],
                      ),
                      Row(
                        children: <Widget>[
                          Checkbox(
                            value: radioBRT,
                            onChanged: (bool value) {
                              setState(() {
                                radioBRT = value;
                                if (value == true) {
                                  typeOfElectricTrain = "BRT";
                                } else {
                                  typeOfElectricTrain = "";
                                }
                              });
                              print(typeOfElectricTrain);
                            },
                          ),
                          Text("BRT"),
                        ],
                      ),
                    ],
                  ),
                  _buildLine(context),
                  _buildSizeBox(context),
                  _buildTextMenu(
                      context, "3. ท่านเคยใช้รถไฟฟ้าประเภทไหนมากที่สุด"),
                  _buildSizeBox(context),
                  _buildSizeBox(context),
                  Column(
                    children: <Widget>[
                      Container(
                        width: mediaQuery(context, 'w', 1005),
                        height: mediaQuery(context, 'h', 180),
                        decoration: BoxDecoration(
                          borderRadius: new BorderRadius.all(
                            Radius.circular(
                              mediaQuery(context, 'h', 20),
                            ),
                          ),
                          color: AppColors.color,
                        ),
                        child: Row(
                          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                          children: <Widget>[
                            Container(
                              width: mediaQuery(context, 'w', 160),
                              alignment: Alignment.center,
                              child: Text(
                                "หัวเรื่อง",
                                style: TextStyle(
                                  fontSize: mediaQuery(context, 'h', 40),
                                  color: Colors.white,
                                ),
                              ),
                            ),
                            Container(
                              width: mediaQuery(context, 'w', 2),
                              height: mediaQuery(context, 'h', 80),
                              color: Colors.white,
                            ),
                            Container(
                              width: mediaQuery(context, 'w', 140),
                              alignment: Alignment.center,
                              child: Text(
                                "น้อยที่สุด",
                                style: TextStyle(
                                  fontSize: mediaQuery(context, 'h', 40),
                                  color: Colors.white,
                                ),
                              ),
                            ),
                            Container(
                              width: mediaQuery(context, 'w', 2),
                              height: mediaQuery(context, 'h', 80),
                              color: Colors.white,
                            ),
                            Container(
                              width: mediaQuery(context, 'w', 140),
                              alignment: Alignment.center,
                              child: Text(
                                'น้อย',
                                style: TextStyle(
                                  fontSize: mediaQuery(context, 'h', 40),
                                  color: Colors.white,
                                ),
                              ),
                            ),
                            Container(
                              width: mediaQuery(context, 'w', 2),
                              height: mediaQuery(context, 'h', 80),
                              color: Colors.white,
                            ),
                            Container(
                              width: mediaQuery(context, 'w', 140),
                              alignment: Alignment.center,
                              child: Text(
                                "ปานกลาง",
                                style: TextStyle(
                                  fontSize: mediaQuery(context, 'h', 40),
                                  color: Colors.white,
                                ),
                              ),
                            ),
                            Container(
                              width: mediaQuery(context, 'w', 2),
                              height: mediaQuery(context, 'h', 80),
                              color: Colors.white,
                            ),
                            Container(
                              width: mediaQuery(context, 'w', 140),
                              alignment: Alignment.center,
                              child: Text(
                                "มาก",
                                style: TextStyle(
                                  fontSize: mediaQuery(context, 'h', 40),
                                  color: Colors.white,
                                ),
                              ),
                            ),
                            Container(
                              width: mediaQuery(context, 'w', 2),
                              height: mediaQuery(context, 'h', 80),
                              color: Colors.white,
                            ),
                            Container(
                              width: mediaQuery(context, 'w', 140),
                              alignment: Alignment.center,
                              child: Text(
                                "มากที่สุด",
                                style: TextStyle(
                                  fontSize: mediaQuery(context, 'h', 40),
                                  color: Colors.white,
                                ),
                              ),
                            ),
                          ],
                        ),
                      ),
                      _buildRow1(context, 1, "BTS", 5, 6, 7, 8, 9),
                      _buildRow2(context, 1, "MRT", 10, 11, 12, 13, 14),
                      _buildRow3(context, 1, "MRT", 15, 16, 17, 18, 19),
                    ],
                  ),
                  _buildSizeBox(context),
                  _buildSizeBox(context),
                  _buildTextMenu(
                      context, "4. เหตุผลที่ท่านช้รถไฟฟ้าในการเดินทาง"),
                  _buildSizeBox(context),
                  _buildTextArea(context, reason),
                  _buildSizeBox(context),
                  _buildSizeBox(context),
                  Row(
                    children: <Widget>[
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                        children: <Widget>[
                          _buildButton(
                              context, "ยกเลิก", Colors.white, AppColors.color),
                          SizedBox(
                            width: 10,
                          ),
                          _buildButton(
                              context, "บันทึก", AppColors.color, Colors.white),
                        ],
                      ),
                    ],
                  ),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }*/

  _buildButton(context, text, bgColor, fontColor) {
    return ButtonTheme(
      minWidth: mediaQuery(context, "w", 477),
      height: mediaQuery(context, "h", 120),
      child: FlatButton(
        shape: new RoundedRectangleBorder(
            borderRadius: new BorderRadius.circular(
              mediaQuery(context, "w", 50),
            ),
            side: BorderSide(color: AppColors.color)),
        color: bgColor,
        textColor: Colors.red,
        padding: EdgeInsets.all(
          mediaQuery(context, "w", 10),
        ),
        onPressed: () {
          if (text == "ส่ง") {
            save();
          } else {
            Navigator.of(context).pop(false);
          }
          print(text);
        },
        child: Text(
          text,
          style: TextStyle(
            fontSize: 14.0,
            color: fontColor,
          ),
        ),
      ),
    );
  }

  _buildTextArea(context, TextEditingController controller, dataChoice) {
    List<QuestionChoice> dataChoiceList = dataChoice;
    controller.text = dataChoiceList[0].RQC_Ans;
    return Container(
      color: Colors.white,
      child: TextField(
        controller: controller,
        onChanged: (text) {
          print("First text field: $text");
          if (dataChoiceList.length != 0) {
            selectedtype4[dataChoiceList[0].RQC_Id] = text;
            dataChoiceList[0].RQC_Ans = text;
          }
        },
        maxLines: 5,
        decoration: InputDecoration(
          fillColor: Colors.white70,
          border: new OutlineInputBorder(
            borderRadius: const BorderRadius.all(
              const Radius.circular(10.0),
            ),
          ),
          hintText: "",
          labelText: '',
        ),
      ),
    );
  }

  _buildRow1(context, number, name, int value1, int value2, int value3,
      int value4, int value5) {
    // เลขคี่
    return Container(
      width: mediaQuery(context, 'w', 1005),
      height: mediaQuery(context, 'h', 170),
      decoration: BoxDecoration(
        borderRadius: new BorderRadius.only(
          bottomLeft: Radius.circular(
            mediaQuery(context, 'h', 20),
          ),
          bottomRight: Radius.circular(
            mediaQuery(context, 'h', 20),
          ),
        ),
        color: Colors.white,
      ),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: <Widget>[
          Container(
            width: mediaQuery(context, 'w', 160),
            alignment: Alignment.center,
            child: Text(
              name,
              style: TextStyle(
                fontSize: mediaQuery(context, 'h', 40),
                color: Color(0xFF333333),
              ),
            ),
          ),
          Container(
            width: mediaQuery(context, 'w', 2),
            height: mediaQuery(context, 'h', 110),
            color: Color(0xFFC6C6C6),
          ),
          Container(
            width: mediaQuery(context, 'w', 140),
            alignment: Alignment.centerLeft,
            padding: EdgeInsets.symmetric(
              horizontal: mediaQuery(context, 'h', 27),
            ),
            child: new Radio(
              value: value1,
              groupValue: _radioValueTypeOfElectricTrain1,
              onChanged: _handleRadioValueChange1,
            ),
          ),
          Container(
            width: mediaQuery(context, 'w', 2),
            height: mediaQuery(context, 'h', 110),
            color: Color(0xFFC6C6C6),
          ),
          Container(
            width: mediaQuery(context, 'w', 140),
            alignment: Alignment.centerLeft,
            padding: EdgeInsets.symmetric(
              horizontal: mediaQuery(context, 'h', 27),
            ),
            child: new Radio(
              value: value2,
              groupValue: _radioValueTypeOfElectricTrain1,
              onChanged: _handleRadioValueChange1,
            ),
          ),
          Container(
            width: mediaQuery(context, 'w', 2),
            height: mediaQuery(context, 'h', 110),
            color: Color(0xFFC6C6C6),
          ),
          Container(
            width: mediaQuery(context, 'w', 140),
            alignment: Alignment.centerLeft,
            padding: EdgeInsets.symmetric(
              horizontal: mediaQuery(context, 'h', 27),
            ),
            child: new Radio(
              value: value3,
              groupValue: _radioValueTypeOfElectricTrain1,
              onChanged: _handleRadioValueChange1,
            ),
          ),
          Container(
            width: mediaQuery(context, 'w', 2),
            height: mediaQuery(context, 'h', 110),
            color: Color(0xFFC6C6C6),
          ),
          Container(
            width: mediaQuery(context, 'w', 140),
            alignment: Alignment.centerLeft,
            padding: EdgeInsets.symmetric(
              horizontal: mediaQuery(context, 'h', 27),
            ),
            child: new Radio(
              value: value4,
              groupValue: _radioValueTypeOfElectricTrain1,
              onChanged: _handleRadioValueChange1,
            ),
          ),
          Container(
            width: mediaQuery(context, 'w', 2),
            height: mediaQuery(context, 'h', 110),
            color: Color(0xFFC6C6C6),
          ),
          Container(
            width: mediaQuery(context, 'w', 140),
            alignment: Alignment.centerLeft,
            padding: EdgeInsets.symmetric(
              horizontal: mediaQuery(context, 'h', 27),
            ),
            child: new Radio(
              value: value5,
              groupValue: _radioValueTypeOfElectricTrain1,
              onChanged: _handleRadioValueChange1,
            ),
          ),
        ],
      ),
    );
  }

  _buildRow2(context, number, name, int value1, int value2, int value3,
      int value4, int value5) {
    return Container(
      width: mediaQuery(context, 'w', 1005),
      height: mediaQuery(context, 'h', 170),
      decoration: BoxDecoration(
        borderRadius: new BorderRadius.only(
          bottomLeft: Radius.circular(
            mediaQuery(context, 'h', 20),
          ),
          bottomRight: Radius.circular(
            mediaQuery(context, 'h', 20),
          ),
        ),
        color: Colors.white,
      ),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: <Widget>[
          Container(
            width: mediaQuery(context, 'w', 160),
            alignment: Alignment.center,
            child: Text(
              name,
              style: TextStyle(
                fontSize: mediaQuery(context, 'h', 40),
                color: Color(0xFF333333),
              ),
            ),
          ),
          Container(
            width: mediaQuery(context, 'w', 2),
            height: mediaQuery(context, 'h', 110),
            color: Color(0xFFC6C6C6),
          ),
          Container(
            width: mediaQuery(context, 'w', 140),
            alignment: Alignment.centerLeft,
            padding: EdgeInsets.symmetric(
              horizontal: mediaQuery(context, 'h', 27),
            ),
            child: new Radio(
              value: value1,
              groupValue: _radioValueTypeOfElectricTrain2,
              onChanged: _handleRadioValueChange2,
            ),
          ),
          Container(
            width: mediaQuery(context, 'w', 2),
            height: mediaQuery(context, 'h', 110),
            color: Color(0xFFC6C6C6),
          ),
          Container(
            width: mediaQuery(context, 'w', 140),
            alignment: Alignment.centerLeft,
            padding: EdgeInsets.symmetric(
              horizontal: mediaQuery(context, 'h', 27),
            ),
            child: new Radio(
              value: value2,
              groupValue: _radioValueTypeOfElectricTrain2,
              onChanged: _handleRadioValueChange2,
            ),
          ),
          Container(
            width: mediaQuery(context, 'w', 2),
            height: mediaQuery(context, 'h', 110),
            color: Color(0xFFC6C6C6),
          ),
          Container(
            width: mediaQuery(context, 'w', 140),
            alignment: Alignment.centerLeft,
            padding: EdgeInsets.symmetric(
              horizontal: mediaQuery(context, 'h', 27),
            ),
            child: new Radio(
              value: value3,
              groupValue: _radioValueTypeOfElectricTrain2,
              onChanged: _handleRadioValueChange2,
            ),
          ),
          Container(
            width: mediaQuery(context, 'w', 2),
            height: mediaQuery(context, 'h', 110),
            color: Color(0xFFC6C6C6),
          ),
          Container(
            width: mediaQuery(context, 'w', 140),
            alignment: Alignment.centerLeft,
            padding: EdgeInsets.symmetric(
              horizontal: mediaQuery(context, 'h', 27),
            ),
            child: new Radio(
              value: value4,
              groupValue: _radioValueTypeOfElectricTrain2,
              onChanged: _handleRadioValueChange2,
            ),
          ),
          Container(
            width: mediaQuery(context, 'w', 2),
            height: mediaQuery(context, 'h', 110),
            color: Color(0xFFC6C6C6),
          ),
          Container(
            width: mediaQuery(context, 'w', 140),
            alignment: Alignment.centerLeft,
            padding: EdgeInsets.symmetric(
              horizontal: mediaQuery(context, 'h', 27),
            ),
            child: new Radio(
              value: value5,
              groupValue: _radioValueTypeOfElectricTrain2,
              onChanged: _handleRadioValueChange2,
            ),
          ),
        ],
      ),
    );
  }

  _buildRow3(context, number, name, int value1, int value2, int value3,
      int value4, int value5) {
    return Container(
      width: mediaQuery(context, 'w', 1005),
      height: mediaQuery(context, 'h', 170),
      decoration: BoxDecoration(
        borderRadius: new BorderRadius.only(
          bottomLeft: Radius.circular(
            mediaQuery(context, 'h', 20),
          ),
          bottomRight: Radius.circular(
            mediaQuery(context, 'h', 20),
          ),
        ),
        color: Colors.white,
      ),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: <Widget>[
          Container(
            width: mediaQuery(context, 'w', 160),
            alignment: Alignment.center,
            child: Text(
              name,
              style: TextStyle(
                fontSize: mediaQuery(context, 'h', 40),
                color: Color(0xFF333333),
              ),
            ),
          ),
          Container(
            width: mediaQuery(context, 'w', 2),
            height: mediaQuery(context, 'h', 110),
            color: Color(0xFFC6C6C6),
          ),
          Container(
            width: mediaQuery(context, 'w', 140),
            alignment: Alignment.centerLeft,
            padding: EdgeInsets.symmetric(
              horizontal: mediaQuery(context, 'h', 27),
            ),
            child: new Radio(
              value: value1,
              groupValue: _radioValueTypeOfElectricTrain3,
              onChanged: _handleRadioValueChange3,
            ),
          ),
          Container(
            width: mediaQuery(context, 'w', 2),
            height: mediaQuery(context, 'h', 110),
            color: Color(0xFFC6C6C6),
          ),
          Container(
            width: mediaQuery(context, 'w', 140),
            alignment: Alignment.centerLeft,
            padding: EdgeInsets.symmetric(
              horizontal: mediaQuery(context, 'h', 27),
            ),
            child: new Radio(
              value: value2,
              groupValue: _radioValueTypeOfElectricTrain3,
              onChanged: _handleRadioValueChange3,
            ),
          ),
          Container(
            width: mediaQuery(context, 'w', 2),
            height: mediaQuery(context, 'h', 110),
            color: Color(0xFFC6C6C6),
          ),
          Container(
            width: mediaQuery(context, 'w', 140),
            alignment: Alignment.centerLeft,
            padding: EdgeInsets.symmetric(
              horizontal: mediaQuery(context, 'h', 27),
            ),
            child: new Radio(
              value: value3,
              groupValue: _radioValueTypeOfElectricTrain3,
              onChanged: _handleRadioValueChange3,
            ),
          ),
          Container(
            width: mediaQuery(context, 'w', 2),
            height: mediaQuery(context, 'h', 110),
            color: Color(0xFFC6C6C6),
          ),
          Container(
            width: mediaQuery(context, 'w', 140),
            alignment: Alignment.centerLeft,
            padding: EdgeInsets.symmetric(
              horizontal: mediaQuery(context, 'h', 27),
            ),
            child: new Radio(
              value: value4,
              groupValue: _radioValueTypeOfElectricTrain3,
              onChanged: _handleRadioValueChange3,
            ),
          ),
          Container(
            width: mediaQuery(context, 'w', 2),
            height: mediaQuery(context, 'h', 110),
            color: Color(0xFFC6C6C6),
          ),
          Container(
            width: mediaQuery(context, 'w', 140),
            alignment: Alignment.centerLeft,
            padding: EdgeInsets.symmetric(
              horizontal: mediaQuery(context, 'h', 27),
            ),
            child: new Radio(
              value: value5,
              groupValue: _radioValueTypeOfElectricTrain3,
              onChanged: _handleRadioValueChange3,
            ),
          ),
        ],
      ),
    );
  }

  _buildLine(context) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        Expanded(
          child: new Container(
            child: Divider(
              color: AppColors.color_line,
            ),
          ),
        ),
      ],
    );
  }

  _buildSizeBox(context) {
    return SizedBox(
      height: mediaQuery(context, "h", 15),
    );
  }

  _buildTextMenu(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
/*        Text(
          text,
          style: TextStyle(
              fontSize: mediaQuery(context, 'h', 46), color: AppColors.Black),
          textAlign: TextAlign.center,
        ),*/
        Flexible(
          child: Text(
            text,
            style: TextStyle(
                fontSize: mediaQuery(context, 'h', 46), color: AppColors.Black),
            textAlign: TextAlign.left,
          ),
        ),
      ],
    );
  }

  _buildRadio(context, text, int value, id) {
    return SizedBox(
//      width: _width,
      height: 30,
      child: Row(
        children: <Widget>[
          new Radio(
            value: text, //Index of created Radio Button
            groupValue: selectedtype1[id] !=
                    null //If groupValue is equal to value, the radioButton will be selected
                ? selectedtype1[id]
                : "",
            onChanged: (value) {
              this.setState(() {
                selectedtype1[id] =
                    value; //Adding selected rowName with its Index in a Map tagged "selected"
                print("${id} ==> $value");
              });
            },
          ),
          Text(text)
        ],
      ),
    );
  }

  void _radioValueChangeUserElectricTrain(int value) {
    setState(() {
      _radioValue = value;
      if (value == 0) {
        userElectricTrain = "ไม่เคย";
      } else {
        userElectricTrain = "เคย";
      }
    });
    print(userElectricTrain);
//   userElectricTrain
  }

  void _handleRadioValueChange1(int value) {
    setState(() {
      _radioValueTypeOfElectricTrain1 = value;
      if (_radioValueTypeOfElectricTrain1 == 5) {
        userElectricTrainBTS = "น้อยที่สุด";
      }
      if (_radioValueTypeOfElectricTrain1 == 6) {
        userElectricTrainBTS = "น้อย";
      }
      if (_radioValueTypeOfElectricTrain1 == 7) {
        userElectricTrainBTS = "ปานกลาง";
      }
      if (_radioValueTypeOfElectricTrain1 == 8) {
        userElectricTrainBTS = "มาก";
      }
      if (_radioValueTypeOfElectricTrain1 == 9) {
        userElectricTrainBTS = "มากที่สุด";
      }
    });
    print("BTS $userElectricTrainBTS");
  }

  void _handleRadioValueChange2(int value) {
    setState(() {
      _radioValueTypeOfElectricTrain2 = value;

      if (_radioValueTypeOfElectricTrain2 == 10) {
        userElectricTrainMRT = "น้อยที่สุด";
      }
      if (_radioValueTypeOfElectricTrain2 == 11) {
        userElectricTrainMRT = "น้อย";
      }
      if (_radioValueTypeOfElectricTrain2 == 12) {
        userElectricTrainMRT = "ปานกลาง";
      }
      if (_radioValueTypeOfElectricTrain2 == 13) {
        userElectricTrainMRT = "มาก";
      }
      if (_radioValueTypeOfElectricTrain2 == 14) {
        userElectricTrainMRT = "มากที่สุด";
      }
    });
    print("MRT $userElectricTrainMRT");
  }

  void _handleRadioValueChange3(int value) {
    setState(() {
      _radioValueTypeOfElectricTrain3 = value;
      if (_radioValueTypeOfElectricTrain3 == 15) {
        userElectricTrainBRT = "น้อยที่สุด";
      }
      if (_radioValueTypeOfElectricTrain3 == 16) {
        userElectricTrainBRT = "น้อย";
      }
      if (_radioValueTypeOfElectricTrain3 == 17) {
        userElectricTrainBRT = "ปานกลาง";
      }
      if (_radioValueTypeOfElectricTrain3 == 18) {
        userElectricTrainBRT = "มาก";
      }
      if (_radioValueTypeOfElectricTrain3 == 19) {
        userElectricTrainBRT = "มากที่สุด";
      }
    });

    print("BRT $userElectricTrainBRT");
  }
} //class

class AnswerListSend {
  List<AnswerList> listanswer;

  AnswerListSend({this.listanswer});

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    this.listanswer.map((v) => v.toJson()).toList();
    return data;
  }
}
