import 'package:flutter/material.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/shadow.dart';
import 'package:mwf_app/service/strings.dart';
import 'package:mwf_app/model/Install_electric_meter.dart';

class ServicePointOfMeterUser extends StatefulWidget {
  @override
  _ServicePointOfMeterUserState createState() =>
      _ServicePointOfMeterUserState();
}

class _ServicePointOfMeterUserState extends State<ServicePointOfMeterUser> {
  bool isLoading = false;
  @override
  void initState() {
    super.initState();
    print('meter_installation_point');

    loadData(); // ดึงข้อมูล
  }

  loadData() async {
    setState(() {
      isLoading = true;
    });

    try {
      final list = await InstallElectricMeter
          .getData(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api

      setState(() {
        list.forEach((v) {
          final meterList = InstallElectricMeter.fromJson(v);
          InstallElectricMeter.data.add(meterList); // loop เก็บข้อมูล
        });
      });
      await Future.delayed(const Duration(milliseconds: 2000));
      setState(() {
        isLoading = false;
      });
    } catch (e) {
      setState(() {
        isLoading = false;
        print(e);
      });
    }
  }

  @override
  Widget build(BuildContext context) {
    if (isLoading == true) {
      AppLoader.show();
    }
    if (isLoading == false) {
      AppLoader.hide();
    }
    double _width = MediaQuery.of(context).size.width;
    return Material(
      color: AppColors.bgColor,
      child: Stack(
        children: <Widget>[
          Header.header1(context),
          Header.mainMenu(context),
          Container(
            //            icon เมนู
            width: _width,
            //color: Colors.black26,
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 950),
              left: mediaQuery(context, 'w', 60),
              right: mediaQuery(context, 'w', 60),
              bottom: mediaQuery(context, 'h', 30),
            ),
            child: Column(
              children: <Widget>[
                Container(
                  alignment: Alignment.center,
                  margin: EdgeInsets.only(
                    bottom: mediaQuery(context, 'h', 60),
                  ),
                  child: Text(
                    AppStrings.service_pointOfMeter_user == null
                        ? ""
                        : AppStrings.service_pointOfMeter_user,
                    style: TextStyle(
                      color: Color(0xFFB58E38),
                      fontSize: mediaQuery(context, 'h', 70),
                    ),
                  ),
                ),
              ],
            ),
          ),
          Container(
            width: _width,
            height: mediaQuery(context, 'h', 1150),
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 1100),
              left: mediaQuery(context, 'w', 60),
              right: mediaQuery(context, 'w', 60),
            ),
            child: SingleChildScrollView(
              child: Column(
                children:
                    List.generate(InstallElectricMeter.data.length, (index) {
                  return _buildContent(
                    context,
                    index,
                    '',
                    InstallElectricMeter.data[index].installationNumber,
                    InstallElectricMeter.data[index].ctValue,
                    InstallElectricMeter.data[index].vtValue,
                    InstallElectricMeter.data[index].installationAddress,
                    InstallElectricMeter.data[index].peaNo,
                  );
                }),
              ),
            ),
          )
        ],
      ),
    );
  }
}

_buildContent(
    context, number, numVol, numberinstall, ct, vt, address, peaNumber) {
  return Container(
    width: mediaQuery(context, 'w', 1005),
//      height: mediaQuery(context, 'h', 380),
    padding: EdgeInsets.all(
      mediaQuery(context, 'h', 50),
    ),
    margin: EdgeInsets.only(
      bottom: mediaQuery(context, 'h', 40),
    ),
    decoration: BoxDecoration(
      borderRadius: BorderRadius.all(
        Radius.circular(
          mediaQuery(context, 'h', 20),
        ),
      ),
      boxShadow: [
        appShadow(),
      ],
      color: Colors.white,
    ),
    child: Row(
      children: <Widget>[
        GestureDetector(
          child: Container(
            width: mediaQuery(context, 'w', 800),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Text(
                      'ลำดับ : ',
                      style: TextStyle(
                        color: AppColors.color_text,
                        fontSize: mediaQuery(context, 'h', 42),
                      ),
                    ),
                    Text(
                      number == null ? "" : (number + 1).toString(),
                      style: TextStyle(
                        color: AppColors.color_text,
                        fontSize: mediaQuery(context, 'h', 40),
                      ),
                    ),
                  ],
                ),
                Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Text(
                      'หมายเลขเครื่องวัด : ',
                      style: TextStyle(
                        color: AppColors.color_text,
                        fontSize: mediaQuery(context, 'h', 42),
                      ),
                    ),
                    Text(
                      peaNumber == null ? "" : peaNumber,
                      style: TextStyle(
                        color: AppColors.color_text,
                        fontSize: mediaQuery(context, 'h', 40),
                      ),
                    ),
                  ],
                ),
                Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Text(
                      'เลขที่ติดตั้ง : ',
                      style: TextStyle(
                        color: AppColors.color_text,
                        fontSize: mediaQuery(context, 'h', 42),
                      ),
                    ),
                    Text(
                      numberinstall == null ? "" : numberinstall,
                      style: TextStyle(
                        color: AppColors.color_text,
                        fontSize: mediaQuery(context, 'h', 40),
                      ),
                    ),
                  ],
                ),
                Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Text(
                      'CT : ',
                      style: TextStyle(
                        color: AppColors.color_text,
                        fontSize: mediaQuery(context, 'h', 42),
                      ),
                    ),
                    Text(
                      ct ?? "",
                      style: TextStyle(
                        color: AppColors.color_text,
                        fontSize: mediaQuery(context, 'h', 40),
                      ),
                    ),
                  ],
                ),
                Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Text(
                      'VT : ',
                      style: TextStyle(
                        color: AppColors.color_text,
                        fontSize: mediaQuery(context, 'h', 42),
                      ),
                    ),
                    Text(
                      vt ?? "",
                      style: TextStyle(
                        color: AppColors.color_text,
                        fontSize: mediaQuery(context, 'h', 40),
                      ),
                    ),
                  ],
                ),
                Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Text(
                      'ที่อยู่สถานที่ใช้ไฟฟ้า : ',
                      style: TextStyle(
                        color: AppColors.color_text,
                        fontSize: mediaQuery(context, 'h', 42),
                      ),
                    ),
                    Flexible(
                      child: Text(
                        address == null ? "" : address,
                        style: TextStyle(
                          color: AppColors.color_text,
                          fontSize: mediaQuery(context, 'h', 40),
                        ),
                      ),
                    ),
                  ],
                ),
              ],
            ),
          ),
        ),
      ],
    ),
  );
}
