import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/assets.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/model/ProfileInfo_model.dart';
import 'package:mwf_app/set9/personal_info_edit.dart';
import 'package:mwf_app/service/shadow.dart';

class PersonalInfo extends StatefulWidget {
  @override
  _PersonalInfoState createState() => _PersonalInfoState();
}

class _PersonalInfoState extends State<PersonalInfo> {
  final Map<String, dynamic> data = new Map<String, dynamic>();

  ProfileInfo _profileInfo = new ProfileInfo();
  bool isLoading = false;

  @override
  void initState() {
    super.initState();
    _loadData();
  }

  _loadData() async {
    setState(() {
      isLoading = true;
    });
    final response = await AppApi.apiGetRequest(AppUrl.Profile_GetSaleInfo +
        "?saleInfoId=" +
        AppUrl.EmpID +
        "&authenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    setState(() {
      _profileInfo = ProfileInfo.fromJson(response);
    });
    await new Future.delayed(const Duration(milliseconds: 1000));
    setState(() {
      isLoading = false;
    });

    debugPrint(_profileInfo.toJson().toString());
    return response;
  }

  @override
  Widget build(BuildContext context) {
    if (isLoading == true) {
      AppLoader.show();
    }
    if (isLoading == false) {
      AppLoader.hide();
    }
    double _width = MediaQuery.of(context).size.width;

    return Material(
      color: AppColors.bgColor,
      child: Stack(
        children: <Widget>[
          Header.mainMenu(context),
          Padding(
            padding: EdgeInsets.only(
              top: mediaQuery(context, "h", 500),
            ),
            child: Column(
              children: <Widget>[
                Stack(
                  children: <Widget>[
                    Image.asset(
                      AppAssets.bg_service_layer2,
                      width: _width,
                      height: mediaQuery(context, "h", 1400),
                    ),
                    Column(
                      children: <Widget>[
                        Container(
                          margin: EdgeInsets.only(
                            top: mediaQuery(context, "h", 300),
                          ),
                          child: Row(
                            children: <Widget>[
                              Spacer(),
                              Spacer(),
                              Spacer(),
                              Spacer(),
                              Spacer(),
                              Spacer(),
                              Spacer(),
                              Text(
                                "ข้อมูลส่วนตัว",
                                style: TextStyle(
                                  color: AppColors.color,
                                  fontSize: mediaQuery(context, "h", 75),
                                ),
                              ),
                              Spacer(),
                              RaisedButton(
                                child: Row(
                                  children: <Widget>[
                                    Icon(
                                      Icons.edit,
                                      color: Colors.white,
                                      size: mediaQuery(context, "w", 50),
                                    ),
                                    Text(
                                      'แก้ไข',
                                      style: TextStyle(
                                        color: Colors.white,
                                        fontSize: mediaQuery(context, "w", 40),
                                      ),
                                    ),
                                  ],
                                ),
                                color: AppColors.color,
                                shape: RoundedRectangleBorder(
                                    borderRadius: BorderRadius.all(
                                        Radius.circular(16.0))),
                                onPressed: () async {
                                  print("แก้ไข");
                                  final result = await Navigator.push(
                                    context,
                                    MaterialPageRoute(
                                        builder: (context) =>
                                            PersonalInfoEdit(_profileInfo)),
                                  );
                                  if (result) {
                                    _loadData();
                                  }
                                },
                              ),
                              Spacer(),
                            ],
                          ),
                        ),
                        Padding(
                          padding: EdgeInsets.only(
                            top: mediaQuery(context, "h", 50),
                            left: mediaQuery(context, "w", 80),
                          ),
                          child: Column(
                            children: <Widget>[
                              _buildContent(
                                  context,
                                  "ชื่อ - นามสกุล",
                                  _profileInfo?.employeeFullName ??
                                      'กำลังโหลด...'),
                              SizedBox(
                                height: mediaQuery(context, "h", 15),
                              ),
                              _buildContent(
                                  context,
                                  "ตำแหน่ง",
                                  _profileInfo?.employeePosition ??
                                      'กำลังโหลด...'),
                              SizedBox(
                                height: mediaQuery(context, "h", 15),
                              ),
                              _buildContent(
                                  context,
                                  "สังกัด",
                                  _profileInfo?.employeeDepartment ??
                                      'กำลังโหลด...'),
                              SizedBox(
                                height: mediaQuery(context, "h", 15),
                              ),
                              _buildContent(
                                  context,
                                  "เบอร์โทรศัพท์",
                                  _profileInfo?.employeePhone ??
                                      'กำลังโหลด...'),
                              SizedBox(
                                height: mediaQuery(context, "h", 15),
                              ),
                              _buildContent(
                                  context,
                                  "อีเมล",
                                  _profileInfo?.employeeEmail ??
                                      'กำลังโหลด...'),
                              SizedBox(
                                height: mediaQuery(context, "h", 15),
                              ),
                              _buildContent(
                                  context,
                                  "ช่องทางติดต่ออื่นๆ",
                                  _profileInfo?.employeeContactEtc ??
                                      'กำลังโหลด...'),
                              SizedBox(
                                height: mediaQuery(context, "h", 15),
                              ),
                            ],
                          ),
                        )
                      ],
                    ),
                  ],
                ),
              ],
            ),
          ),
          Row(
            children: <Widget>[
              Image.asset(
                AppAssets.bg_home_layer1,
                fit: BoxFit.cover,
                width: _width,
                height: mediaQuery(context, "h", 796.7),
              )
            ],
          ),
          Padding(
            padding: EdgeInsets.only(
              top: mediaQuery(context, "h", 200),
              left: mediaQuery(context, "h", 33.1),
            ),
            child: Row(
              verticalDirection: VerticalDirection.down,
              children: <Widget>[
                GestureDetector(
                  onTap: () {
                    print("object3");
                    Navigator.pop(context);
                  },
                  child: Icon(
                    Icons.arrow_back_ios,
                    color: Colors.white,
                    size: mediaQuery(context, "h", 80),
                  ),
                ),
              ],
            ),
          ),
          Row(
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Container(
                margin: EdgeInsets.only(
                  top: mediaQuery(context, "h", 180),
                ),
                child: Stack(
                  children: <Widget>[
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceAround,
                      children: <Widget>[
                        Container(
                          width: mediaQuery(context, 'h', 420),
                          height: mediaQuery(context, 'h', 420),
                          margin: EdgeInsets.only(
                            top: mediaQuery(context, 'h', 70),
                          ),
                          decoration: new BoxDecoration(
                            shape: BoxShape.circle,
                            border: Border.all(
                              color: Colors.white,
                              width: 6,
                            ),
                            boxShadow: [
                              appShadow(),
                            ],
                            image: new DecorationImage(
                              fit: BoxFit.fill,
                              image: AssetImage(AppAssets.imageProfile),
                            ),
                          ),
                        ),
                      ],
                    ),
                  ],
                ),
              )
            ],
          ),
        ],
      ),
    );
  }

  _buildContent(context, String label, String value) {
    return Row(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: <Widget>[
        Container(
          width: mediaQuery(context, "w", 290),
          child: Text(
            '$label',
            style: TextStyle(
              fontSize: mediaQuery(context, "h", 42),
            ),
          ),
        ),
        Flexible(
          child: Text(
            ': $value',
            style: TextStyle(
              color: Color(0xFF8B939A),
              fontSize: mediaQuery(context, "h", 42),
            ),
          ),
        ),
      ],
    );
  }
} //class
