import 'dart:async';
import 'package:get/get.dart';
import 'package:flutter/material.dart';

import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/set8/list_request_additional.dart';
import 'package:webview_flutter/webview_flutter.dart';

class WebviewAdditional extends StatefulWidget {
  final String pid;
  WebviewAdditional({Key key, @required this.pid}) : super(key: key);
  @override
  _WebviewAdditionalState createState() =>
      _WebviewAdditionalState(pid: this.pid);
}

class _WebviewAdditionalState extends State<WebviewAdditional> {
  _WebviewAdditionalState({this.pid});
  String urlMain = AppUrl.CRMWorkforce_webview + 'Package/packageview?id=';
  bool isLoading = false;
  String pid;

  Completer<WebViewController> _webviewController =
    Completer<WebViewController>();

  @override
  void initState() {
    super.initState();
    Header.routes = ListRequestAdditional();
    print("------------Web View-----------");
    isLoading = true;
    wait();
  }

  @override
  void dispose() {
    _webviewController = null;
    super.dispose();
  }
  
  JavascriptChannel _saveFinnishJavascriptChannel(BuildContext context) {
    return JavascriptChannel(
        name: 'saveFinnish',
        onMessageReceived: (message) {
          Navigator.pop(context);
        });
  }

  wait() async {
    await Future.delayed(const Duration(milliseconds: 2000));
    setState(() {
      isLoading = false;
    });
  }

  _bulidWebView3() {
    setState(() {
      urlMain = urlMain + pid + "&authenKey=" + AppUrl.AuthenKey;
      print(urlMain);
    });
    return Container(
      width: MediaQuery.of(context).size.width,
      height: MediaQuery.of(context).size.height - 177,
      margin: EdgeInsets.only(
        top: mediaQuery(context, 'h', 345),
      ),
      child: WebView(
        initialUrl: urlMain,
        javascriptMode: JavascriptMode.unrestricted,
        javascriptChannels: <JavascriptChannel>[
          _saveFinnishJavascriptChannel(context),
        ].toSet(),
        onWebViewCreated: (WebViewController webViewController) {
          _webviewController.complete(webViewController);
        },
        onPageStarted: (url) {},
      ),
    );
  }

  @override
  Widget build(BuildContext context) {
    if (isLoading == true) {
      AppLoader.show();
    }
    if (isLoading == false) {
      AppLoader.hide();
    }

    return Material(
      color: AppColors.bgColor,
      child: WillPopScope(
        onWillPop: () async {
          Get.offAll(Header.routes);
          return false;
        },
        child: Stack(
          children: <Widget>[
            Header.mainMenu(context),
            _bulidWebView3(),
            Header.header2ListPage(context),
          ],
        ),
      ),
    );
  }
}
// class _WebviewAdditionalState extends State<WebviewAdditional> {
//   bool isLoading = true;
//   String pid;
//   //  final flutterWebViewPlugin = FlutterWebviewPlugin();
//   _WebviewAdditionalState({this.pid});
//   // String url = 'http://202.6.26.23/CRMWorkforce.Web/Package/Packageview/';
//   String url = AppUrl.CRMWorkforce_webview + 'Package/packageview?id=';
//   String _url = '';
//   double webHeight;
//   // WebViewController _webViewController;
//   num _stackToView = 1;
//   final _key = GlobalKey();

//   // final Completer<WebViewController> _controller =
//   //     Completer<WebViewController>();

//   @override
//   void initState() {
//     super.initState();
//     Header.routes = ListRequestAdditional();
//     // if (Platform.isAndroid) WebView.platform = SurfaceAndroidWebView();
//     print("------------Web View-----------");
//     setState(() {
//       // _url = url + pid + "&authenKey=" + AppUrl.AuthenKey;
//       // _url = "https://flutter.dev/";
//       _url = "https://www.google.co.th/";
//       print(_url);
//     });
//     wait();
//   }

//   wait() async {
//     await new Future.delayed(const Duration(seconds: 1));
//     setState(() {
//       isLoading = false;
//     });
//   }

//   @override
//   void dispose() {
//     // _webViewController = null;
//     super.dispose();
//   }

//   final Set<JavascriptChannel> jsChannels = [
//   JavascriptChannel(
//       name: 'Print',
//       onMessageReceived: (JavascriptMessage message) {
//         print(message.message);
//       }),
// ].toSet();

//   @override
//   Widget build(BuildContext context) {
//     if (isLoading == true) {
//       AppLoader.show();
//     }
//     if (isLoading == false) {
//       AppLoader.hide();
//     }
//     double _width = MediaQuery.of(context).size.width;
//     double _height = MediaQuery.of(context).size.height;
//     return Material(
//       color: AppColors.bgColor,
//       child: WillPopScope(
//         onWillPop: () async {
//           Get.offAll(Header.routes);
//           return false;
//         },
//         child: Stack(
//           children: <Widget>[
            
//             Header.mainMenu(context),
//             Container(
//               width: _width,
//               height: mediaQuery(context, 'h', 1855),
//               margin: EdgeInsets.only(
//                 top: mediaQuery(context, 'h', 355),
//                 left: mediaQuery(context, 'w', 60),
//                 //right: mediaQuery(context, 'w', 60),
//               ),
//               child: SingleChildScrollView(
//                 child: _webview(context, _url),
//               ),
//             ),
            
//             Header.header2ListPage(context),
//           ],
//         ),
//       ),
//     );
//   }

 


//   Widget _webview(BuildContext context, String url) {
//     double _width = MediaQuery.of(context).size.width;
//     double _height =
//         MediaQuery.of(context).size.height - mediaQuery(context, 'h', 200);

//     return Container(
//       margin: EdgeInsets.only(
//         top: mediaQuery(context, 'h', 355),
//         left: mediaQuery(context, 'w', 40),
//         //right: mediaQuery(context, 'w', 40),
//       ),
//       width: _width,
//       height: 595,
//       // height: webHeight == null ? _height : webHeight - 500,
//       child: WebviewScaffold(
//         url: url,
//         javascriptChannels: jsChannels,
//         mediaPlaybackRequiresUserGesture: false,
//         // appBar: AppBar(
//         //   title: const Text('Widget WebView'),
//         // ),
//         withZoom: false,
//         withLocalStorage: true,
//         hidden: true,
//         initialChild: Container(
//           child: const Center(
//             child: Text(''),
//           ),
//         ),              
//       ),
//     );


    // return Container(
    //   width: _width,
    //   height: webHeight == null ? _height : webHeight,
    //   child: Column(
    //     children: [
    //       Expanded(
    //         child: WebView(
    //           key: _key,
    //           javascriptMode: JavascriptMode.unrestricted,
    //           initialUrl: url,
    //           onWebViewCreated: (WebViewController webViewController) {
    //             _controller.complete(webViewController);
    //             //_webViewController = webViewController;
    //           },
    //           onPageStarted: (String url) {
    //             print('Page started loading: $_url');
    //           },
    //           onPageFinished: (String url) async {
    //             double height;
    //             if (_webViewController != null) {
    //               height = double.tryParse(
    //                 await _webViewController.evaluateJavascript(
    //                     "document.documentElement.scrollHeight;"),
    //               );
    //               setState(() {
    //                 webHeight = height;
    //               });
    //               print("Height :: " + webHeight.toString());
    //             }
    //           },
    //           gestureNavigationEnabled: true,
    //         ),
    //       ),
    //     ],
    //   ),
    // );
//   }
// }
