//ElectricShutdown_model.dart //ElectricShutdownPlan_model.dart
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/convert.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/shadow.dart';
import 'package:mwf_app/service/strings.dart';
import 'package:mwf_app/model/electric_shutdown_plan.dart';
import 'package:mwf_app/model/electric_shutdown.dart';

class HistoryPowerFailed extends StatefulWidget {
  @override
  _HistoryPowerFailedState createState() => _HistoryPowerFailedState();
}

class _HistoryPowerFailedState extends State<HistoryPowerFailed> {
  bool isLoading = false;
  @override
  void initState() {
    super.initState();
    loadData(); // ดึงข้อมูล
  }

  loadData() async {
    setState(() {
      isLoading = true;
    });
    try {
      final list =
          await ElectricProblem.getData(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
      list.length > 0
          ? setState(() {
              list.forEach((v) {
                final powerFailList = ElectricProblem.fromJson(v);
                ElectricProblem.data.add(powerFailList); // loop เก็บข้อมูล
                ElectricProblem.data.sort((a, b) => AppConvert.dateTimeThaiToEng(b.startDate)
                  .compareTo(AppConvert.dateTimeThaiToEng(a.startDate)));
              });
            })
          : null;
    } catch (e) {
      print(e);
    }

    try {
      final list2 = await ElectricShutdownPlan
          .getData(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
      list2.length > 0
          ? setState(() {
              list2.forEach((v) {
                final planList = ElectricShutdownPlan.fromJson(v);
                ElectricShutdownPlan.data.add(planList); // loop เก็บข้อมูล
                ElectricShutdownPlan.data
                    .sort((a, b) => AppConvert.dateTimeThaiToEng(b.startDate).compareTo(AppConvert.dateTimeThaiToEng(a.startDate)));
              });
            })
          : null;
    } catch (e) {
      print(e);
    }
    await new Future.delayed(const Duration(milliseconds: 1000));
    setState(() {
      isLoading = false;
    });
  }

  String tabStatus = 'tab1';

  @override
  Widget build(BuildContext context) {
    if (isLoading == true) {
      AppLoader.show();
    }
    if (isLoading == false) {
      AppLoader.hide();
    }
    double _width = MediaQuery.of(context).size.width;

    return Material(
      color: AppColors.bgColor,
      child: Stack(
        children: <Widget>[
          Header.header1(context),
          Header.mainMenu(context),
          Container(
            width: _width,
            height: mediaQuery(context, 'h', 1200),
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 1000),
              left: mediaQuery(context, 'w', 60),
              right: mediaQuery(context, 'w', 60),
            ),
            child: SingleChildScrollView(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: <Widget>[
                  Container(
                    alignment: Alignment.center,
                    child: Text(
                      AppStrings.HistoryPowerFailedAndPlanFix,
                      style: TextStyle(
                        color: Color(0xFFB58E38),
                        fontSize: mediaQuery(context, 'h', 50),
                      ),
                    ),
                  ),
                  SizedBox(
                    height: mediaQuery(context, 'h', 66),
                  ),
                  Row(
                    children: <Widget>[
                      tabStatus == 'tab1'
                          ? GestureDetector(
                              onTap: () {
                                setState(() {
                                  tabStatus = 'tab1';
                                });
                              },
                              child: Container(
                                width: mediaQuery(context, 'w', 502),
                                height: mediaQuery(context, 'h', 140),
                                margin: EdgeInsets.only(
                                  bottom: mediaQuery(context, 'h', 40),
                                ),
                                decoration: BoxDecoration(
                                  borderRadius: new BorderRadius.only(
                                    topLeft: Radius.circular(
                                      mediaQuery(context, 'h', 20),
                                    ),
                                  ),
                                  color: Color(0xFF804199),
                                ),
                                child: Center(
                                  child: Text(
                                    AppStrings.HistoryPowerFailed,
                                    style: TextStyle(color: Colors.white),
                                  ),
                                ),
                              ),
                            )
                          : GestureDetector(
                              onTap: () {
                                setState(() {
                                  tabStatus = 'tab1';
                                });
                              },
                              child: Container(
                                width: mediaQuery(context, 'w', 502),
                                height: mediaQuery(context, 'h', 140),
                                margin: EdgeInsets.only(
                                  bottom: mediaQuery(context, 'h', 40),
                                ),
                                decoration: BoxDecoration(
                                  borderRadius: new BorderRadius.only(
                                    topLeft: Radius.circular(
                                      mediaQuery(context, 'h', 20),
                                    ),
                                  ),
                                  color: Colors.white,
                                ),
                                child: Center(
                                  child: Text(
                                    AppStrings.HistoryPowerFailed,
                                    style: TextStyle(color: Color(0xFF804199)),
                                  ),
                                ),
                              ),
                            ),
                      tabStatus == 'tab2'
                          ? GestureDetector(
                              onTap: () {
                                setState(() {
                                  tabStatus = 'tab2';
                                });
                              },
                              child: Container(
                                width: mediaQuery(context, 'w', 502),
                                height: mediaQuery(context, 'h', 140),
                                margin: EdgeInsets.only(
                                  bottom: mediaQuery(context, 'h', 40),
                                ),
                                decoration: BoxDecoration(
                                  borderRadius: new BorderRadius.only(
                                    topRight: Radius.circular(
                                      mediaQuery(context, 'h', 20),
                                    ),
                                  ),
                                  color: Color(0xFF804199),
                                ),
                                child: Center(
                                  child: Text(
                                    AppStrings.HistoryPlanFix,
                                    style: TextStyle(
                                      color: Colors.white,
                                    ),
                                  ),
                                ),
                              ),
                            )
                          : GestureDetector(
                              onTap: () {
                                setState(() {
                                  tabStatus = 'tab2';
                                });
                              },
                              child: Container(
                                width: mediaQuery(context, 'w', 502),
                                height: mediaQuery(context, 'h', 140),
                                margin: EdgeInsets.only(
                                  bottom: mediaQuery(context, 'h', 40),
                                ),
                                decoration: BoxDecoration(
                                  borderRadius: new BorderRadius.only(
                                    topRight: Radius.circular(
                                      mediaQuery(context, 'h', 20),
                                    ),
                                  ),
                                  color: Colors.white,
                                ),
                                child: Center(
                                  child: Text(
                                    AppStrings.HistoryPlanFix,
                                    style: TextStyle(
                                      color: Color(0xFF804199),
                                    ),
                                  ),
                                ),
                              ),
                            )
                    ],
                  ),
                  tabStatus == 'tab1'
                      ? Column(
                          children: List.generate(
                            ElectricProblem.data.length,
                            (index) {
                              return _buildContentTab1(
                                context,
                                (index + 1).toString(),
                                ElectricProblem.data[index].startDate,
                                ElectricProblem.data[index].endDate,
                                ElectricProblem.data[index].detail,
                                ElectricProblem.data[index].customerPhone,
                              );
                            },
                          ),
                        )
                      : Column(
                          children: List.generate(
                            ElectricShutdownPlan.data.length,
                            (index) {
                              return _buildContentTab2(
                                context,
                                (index + 1).toString(),
                                ElectricShutdownPlan.data[index].startDate,
                                ElectricShutdownPlan.data[index].endDate,
                                ElectricShutdownPlan
                                    .data[index].electricShutdownDetail,
                              );
                            },
                          ),
                        )
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }

  _buildContentTab1(context, number, fromDate, toDate, detail, phone) {
    return Container(
      width: mediaQuery(context, 'w', 1005),
//      height: mediaQuery(context, 'h', 380),
      padding: EdgeInsets.all(
        mediaQuery(context, 'h', 50),
      ),
      margin: EdgeInsets.only(
        bottom: mediaQuery(context, 'h', 40),
      ),
      decoration: BoxDecoration(
        borderRadius: new BorderRadius.all(
          Radius.circular(
            mediaQuery(context, 'h', 20),
          ),
        ),
        boxShadow: [
          appShadow(),
        ],
        color: Colors.white,
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: <Widget>[
          Row(
            children: <Widget>[
              Text(
                'ลำดับ : ',
                style: TextStyle(
                  color: AppColors.color_text,
                  fontSize: mediaQuery(context, 'h', 50),
                  fontWeight: FontWeight.bold,
                ),
              ),
              Text(
                number,
                style: TextStyle(
                  color: AppColors.color_text,
                  fontSize: mediaQuery(context, 'h', 50),
                  fontWeight: FontWeight.bold,
                ),
              ),
            ],
          ),
          Row(
            children: <Widget>[
              Text(
                'จากวันที่ : ',
                style: TextStyle(
                  color: AppColors.color_text,
                  fontSize: mediaQuery(context, 'h', 40),
                ),
              ),
              Text(
                fromDate != null ? fromDate + " น." : '',
                style: TextStyle(
                  color: AppColors.color_text,
                  fontSize: mediaQuery(context, 'h', 40),
                ),
              ),
            ],
          ),
          Row(
            children: <Widget>[
              Text(
                'ถึงวันที : ',
                style: TextStyle(
                  color: AppColors.color_text,
                  fontSize: mediaQuery(context, 'h', 40),
                ),
              ),
              Text(
                toDate == null ? toDate + " น." : '-',
                style: TextStyle(
                  color: AppColors.color_text,
                  fontSize: mediaQuery(context, 'h', 40),
                ),
              ),
            ],
          ),
          Row(
            children: <Widget>[
              Text(
                'รายละเอียด : ',
                style: TextStyle(
                  color: AppColors.color_text,
                  fontSize: mediaQuery(context, 'h', 40),
                ),
              ),
              Flexible(
                child: Text(
                  detail != null ? detail : '',
                  style: TextStyle(
                    color: AppColors.color_text,
                    fontSize: mediaQuery(context, 'h', 40),
                  ),
                ),
              ),
            ],
          ),
          Row(
            children: <Widget>[
              Text(
                'ผู้แจ้ง : ',
                style: TextStyle(
                  color: AppColors.color_text,
                  fontSize: mediaQuery(context, 'h', 40),
                ),
              ),
              /*Text(
                person != null ? person : '',
                style: TextStyle(
                  color: AppColors.color_text,
                  fontSize: mediaQuery(context, 'h', 40),
                ),
              ),*/
              Text(
                phone != null ? phone : '',
                style: TextStyle(
                  color: AppColors.color_text,
                  fontSize: mediaQuery(context, 'h', 40),
                ),
              ),
            ],
          ),
          /* Row(
            children: <Widget>[
              Text(
                'หมายเลขโทรศัพท์ : ',
                style: TextStyle(
                  color: AppColors.color_text,
                  fontSize: mediaQuery(context, 'h', 40),
                ),
              ),
              Text(
                phone != null ? phone : '',
                style: TextStyle(
                  color: AppColors.color_text,
                  fontSize: mediaQuery(context, 'h', 40),
                ),
              ),
            ],
          ),*/
        ],
      ),
    );
  }

  _buildContentTab2(context, number, fromDate, toDate, detail) {
    return Container(
      width: mediaQuery(context, 'w', 1005),
      padding: EdgeInsets.all(
        mediaQuery(context, 'h', 50),
      ),
      margin: EdgeInsets.only(
        bottom: mediaQuery(context, 'h', 40),
      ),
      decoration: BoxDecoration(
        borderRadius: new BorderRadius.all(
          Radius.circular(
            mediaQuery(context, 'h', 20),
          ),
        ),
        boxShadow: [
          appShadow(),
        ],
        color: Colors.white,
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: <Widget>[
          Row(
            children: <Widget>[
              Text(
                'ลำดับ : ',
                style: TextStyle(
                  color: AppColors.color_text,
                  fontSize: mediaQuery(context, 'h', 50),
                  fontWeight: FontWeight.bold,
                ),
              ),
              Text(
                number,
                style: TextStyle(
                  color: AppColors.color_text,
                  fontSize: mediaQuery(context, 'h', 50),
                  fontWeight: FontWeight.bold,
                ),
              ),
            ],
          ),
          Row(
            children: <Widget>[
              Text(
                'จากวันที่ : ',
                style: TextStyle(
                  color: AppColors.color_text,
                  fontSize: mediaQuery(context, 'h', 40),
                ),
              ),
              Text(
                fromDate != null ? fromDate : '',
                style: TextStyle(
                  color: AppColors.color_text,
                  fontSize: mediaQuery(context, 'h', 40),
                ),
              ),
            ],
          ),
          Row(
            children: <Widget>[
              Text(
                'ถึงวันที : ',
                style: TextStyle(
                  color: AppColors.color_text,
                  fontSize: mediaQuery(context, 'h', 40),
                ),
              ),
              Text(
                toDate != null ? toDate : '',
                style: TextStyle(
                  color: AppColors.color_text,
                  fontSize: mediaQuery(context, 'h', 40),
                ),
              ),
            ],
          ),
          Row(
            children: <Widget>[
              Text(
                'รายละเอียด : ',
                style: TextStyle(
                  color: AppColors.color_text,
                  fontSize: mediaQuery(context, 'h', 40),
                ),
              ),
              Text(
                detail != null ? detail : '',
                style: TextStyle(
                  color: AppColors.color_text,
                  fontSize: mediaQuery(context, 'h', 40),
                ),
              ),
            ],
          ),
        ],
      ),
    );
  }

  _buildRow1(
    context,
    number,
    fromDate,
    toDate,
    daTail,
    nameInform,
    telInform,
  ) {
    if (number % 2 != 0) {
      // เลขคี่
      return Container(
        width: mediaQuery(context, 'w', 1005),
        height: mediaQuery(context, 'h', 140),
        decoration: BoxDecoration(
          borderRadius: new BorderRadius.only(
            bottomLeft: Radius.circular(
              mediaQuery(context, 'h', 20),
            ),
            bottomRight: Radius.circular(
              mediaQuery(context, 'h', 20),
            ),
          ),
          color: Colors.white,
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
          children: <Widget>[
            Container(
              width: mediaQuery(context, 'w', 134),
              alignment: Alignment.center,
              child: Text(
                number.toString(),
                style: TextStyle(
                  fontSize: mediaQuery(context, 'h', 30),
                  color: Color(0xFF333333),
                ),
              ),
            ),
            Container(
                width: mediaQuery(context, 'w', 2),
                height: mediaQuery(context, 'h', 80),
                color: Color(0xFFC6C6C6)),
            Container(
              width: mediaQuery(context, 'w', 192),
              alignment: Alignment.center,
              child: Text(
                fromDate,
                textAlign: TextAlign.center,
                style: TextStyle(
                  fontSize: mediaQuery(context, 'h', 30),
                  color: Color(0xFF333333),
                ),
              ),
            ),
            Container(
                width: mediaQuery(context, 'w', 2),
                height: mediaQuery(context, 'h', 80),
                color: Color(0xFFC6C6C6)),
            Container(
              width: mediaQuery(context, 'w', 192),
              alignment: Alignment.center,
              child: Text(
                toDate,
                textAlign: TextAlign.center,
                style: TextStyle(
                  fontSize: mediaQuery(context, 'h', 30),
                  color: Color(0xFF333333),
                ),
              ),
            ),
            Container(
                width: mediaQuery(context, 'w', 2),
                height: mediaQuery(context, 'h', 80),
                color: Color(0xFFC6C6C6)),
            Container(
              width: mediaQuery(context, 'w', 250),
              alignment: Alignment.center,
              child: Text(
                daTail,
                style: TextStyle(
                  fontSize: mediaQuery(context, 'h', 30),
                  color: Color(0xFF333333),
                ),
              ),
            ),
            Container(
              width: mediaQuery(context, 'w', 2),
              height: mediaQuery(context, 'h', 80),
              color: Color(0xFFC6C6C6),
            ),
            Container(
              width: mediaQuery(context, 'w', 228),
              alignment: Alignment.center,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  Text(
                    nameInform,
                    style: TextStyle(
                      fontSize: mediaQuery(context, 'h', 30),
                      color: Color(0xFF333333),
                      fontWeight: FontWeight.bold,
                    ),
                  ),
                  Text(
                    telInform,
                    style: TextStyle(
                      fontSize: mediaQuery(context, 'h', 30),
                      color: Color(0xFF81358D),
                      fontWeight: FontWeight.bold,
                    ),
                  ),
                ],
              ),
            ),
          ],
        ),
      );
    } else {
      return Container(
        width: mediaQuery(context, 'w', 1005),
        height: mediaQuery(context, 'h', 140),
        decoration: BoxDecoration(
          borderRadius: new BorderRadius.all(
            Radius.circular(
              mediaQuery(context, 'h', 20),
            ),
          ),
          color: Color(0xFFE6EDF0),
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
          children: <Widget>[
            Container(
              width: mediaQuery(context, 'w', 134),
              alignment: Alignment.center,
              child: Text(
                number.toString(),
                style: TextStyle(
                  fontSize: mediaQuery(context, 'h', 30),
                  color: Color(0xFF333333),
                ),
              ),
            ),
            Container(
                width: mediaQuery(context, 'w', 2),
                height: mediaQuery(context, 'h', 80),
                color: Color(0xFFC6C6C6)),
            Container(
              width: mediaQuery(context, 'w', 192),
              alignment: Alignment.center,
              child: Text(
                fromDate,
                textAlign: TextAlign.center,
                style: TextStyle(
                  fontSize: mediaQuery(context, 'h', 30),
                  color: Color(0xFF333333),
                ),
              ),
            ),
            Container(
                width: mediaQuery(context, 'w', 2),
                height: mediaQuery(context, 'h', 80),
                color: Color(0xFFC6C6C6)),
            Container(
              width: mediaQuery(context, 'w', 192),
              alignment: Alignment.center,
              child: Text(
                toDate,
                textAlign: TextAlign.center,
                style: TextStyle(
                  fontSize: mediaQuery(context, 'h', 30),
                  color: Color(0xFF333333),
                ),
              ),
            ),
            Container(
                width: mediaQuery(context, 'w', 2),
                height: mediaQuery(context, 'h', 80),
                color: Color(0xFFC6C6C6)),
            Container(
              width: mediaQuery(context, 'w', 250),
              alignment: Alignment.center,
              child: Text(
                daTail,
                style: TextStyle(
                  fontSize: mediaQuery(context, 'h', 30),
                  color: Color(0xFF333333),
                ),
              ),
            ),
            Container(
              width: mediaQuery(context, 'w', 2),
              height: mediaQuery(context, 'h', 80),
              color: Color(0xFFC6C6C6),
            ),
            Container(
              width: mediaQuery(context, 'w', 228),
              alignment: Alignment.center,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  Text(
                    nameInform,
                    style: TextStyle(
                      fontSize: mediaQuery(context, 'h', 30),
                      color: Color(0xFF333333),
                      fontWeight: FontWeight.bold,
                    ),
                  ),
                  Text(
                    telInform,
                    style: TextStyle(
                      fontSize: mediaQuery(context, 'h', 30),
                      color: Color(0xFF81358D),
                      fontWeight: FontWeight.bold,
                    ),
                  ),
                ],
              ),
            ),
          ],
        ),
      );
    }
  }

  _buildRow2(
    context,
    number,
    fromDate,
    toDate,
    daTail,
  ) {
    if (number % 2 != 0) {
      // เลขคี่
      return Container(
        width: mediaQuery(context, 'w', 1005),
        height: mediaQuery(context, 'h', 140),
        decoration: BoxDecoration(
          borderRadius: new BorderRadius.only(
            bottomLeft: Radius.circular(
              mediaQuery(context, 'h', 20),
            ),
            bottomRight: Radius.circular(
              mediaQuery(context, 'h', 20),
            ),
          ),
          color: Colors.white,
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
          children: <Widget>[
            Container(
              width: mediaQuery(context, 'w', 134),
              alignment: Alignment.center,
              child: Text(
                number.toString(),
                style: TextStyle(
                  fontSize: mediaQuery(context, 'h', 30),
                  color: Color(0xFF333333),
                ),
              ),
            ),
            Container(
                width: mediaQuery(context, 'w', 2),
                height: mediaQuery(context, 'h', 80),
                color: Color(0xFFC6C6C6)),
            Container(
              width: mediaQuery(context, 'w', 192),
              alignment: Alignment.center,
              child: Text(
                fromDate,
                textAlign: TextAlign.center,
                style: TextStyle(
                  fontSize: mediaQuery(context, 'h', 30),
                  color: Color(0xFF333333),
                ),
              ),
            ),
            Container(
                width: mediaQuery(context, 'w', 2),
                height: mediaQuery(context, 'h', 80),
                color: Color(0xFFC6C6C6)),
            Container(
              width: mediaQuery(context, 'w', 192),
              alignment: Alignment.center,
              child: Text(
                toDate,
                textAlign: TextAlign.center,
                style: TextStyle(
                  fontSize: mediaQuery(context, 'h', 30),
                  color: Color(0xFF333333),
                ),
              ),
            ),
            Container(
                width: mediaQuery(context, 'w', 2),
                height: mediaQuery(context, 'h', 80),
                color: Color(0xFFC6C6C6)),
            Container(
              width: mediaQuery(context, 'w', 480),
              alignment: Alignment.center,
              child: Text(
                daTail,
                style: TextStyle(
                  fontSize: mediaQuery(context, 'h', 30),
                  color: Color(0xFF333333),
                ),
              ),
            ),
          ],
        ),
      );
    } else {
      return Container(
        width: mediaQuery(context, 'w', 1005),
        height: mediaQuery(context, 'h', 140),
        decoration: BoxDecoration(
          borderRadius: new BorderRadius.all(
            Radius.circular(
              mediaQuery(context, 'h', 20),
            ),
          ),
          color: Color(0xFFE6EDF0),
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
          children: <Widget>[
            Container(
              width: mediaQuery(context, 'w', 134),
              alignment: Alignment.center,
              child: Text(
                number.toString(),
                style: TextStyle(
                  fontSize: mediaQuery(context, 'h', 30),
                  color: Color(0xFF333333),
                ),
              ),
            ),
            Container(
                width: mediaQuery(context, 'w', 2),
                height: mediaQuery(context, 'h', 80),
                color: Color(0xFFC6C6C6)),
            Container(
              width: mediaQuery(context, 'w', 192),
              alignment: Alignment.center,
              child: Text(
                fromDate,
                textAlign: TextAlign.center,
                style: TextStyle(
                  fontSize: mediaQuery(context, 'h', 30),
                  color: Color(0xFF333333),
                ),
              ),
            ),
            Container(
                width: mediaQuery(context, 'w', 2),
                height: mediaQuery(context, 'h', 80),
                color: Color(0xFFC6C6C6)),
            Container(
              width: mediaQuery(context, 'w', 192),
              alignment: Alignment.center,
              child: Text(
                toDate,
                textAlign: TextAlign.center,
                style: TextStyle(
                  fontSize: mediaQuery(context, 'h', 30),
                  color: Color(0xFF333333),
                ),
              ),
            ),
            Container(
                width: mediaQuery(context, 'w', 2),
                height: mediaQuery(context, 'h', 80),
                color: Color(0xFFC6C6C6)),
            Container(
              width: mediaQuery(context, 'w', 480),
              alignment: Alignment.center,
              child: Text(
                daTail,
                style: TextStyle(
                  fontSize: mediaQuery(context, 'h', 30),
                  color: Color(0xFF333333),
                ),
              ),
            ),
          ],
        ),
      );
    }
  }
} //class
