import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_rounded_date_picker/rounded_picker.dart';
import 'package:get/get.dart';
import 'package:intl/date_symbol_data_local.dart';
import 'package:intl/intl.dart';
import 'package:mwf_app/service/alert.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/shadow.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/model/customer_care.dart';
import 'package:buddhist_datetime_dateformat/buddhist_datetime_dateformat.dart';
import 'package:mwf_app/set3/customer_staff_list.dart';

//CustomerCare_model.dart
class CustomerCareStaff extends StatefulWidget {
  @override
  _CustomerCareStaffState createState() => _CustomerCareStaffState();
}

class _CustomerCareStaffState extends State<CustomerCareStaff> {
  bool isLoading = false;
  TextEditingController firstName = TextEditingController(); // ชื่อ
  TextEditingController lastName = TextEditingController(); // นามสกุล
  TextEditingController email = TextEditingController(); // mail

  TextEditingController employeeCode =
      TextEditingController(); //รหัสพนักงาน dropdown

  TextEditingController startDate = TextEditingController(); // วันที่เริ่ม
  TextEditingController endDate = TextEditingController(); // วันที่สิ้นสุด
  String employeeId = ""; // ID พนักงาน
  String strStartDate = "";
  String strEndDate = "";
  String selectID = ''; //เลือกคนไหน
  bool isEmailValid = true;
  RegExp regExp = new RegExp(
      r'^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,2}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|([a-zA-Z]))');

  @override
  void initState() {
    super.initState();
    Header.routes = Customerstaff_list();
    //CustomerCare.getSearchData('505392');
    Intl.defaultLocale = 'th';
    initializeDateFormatting();
    print("Care");
    CustomerCareInfo.dataList = [];
  }

  List dataListSearch = [];

  Map<String, dynamic> listS;
  searchData(String emId, String fname, String lname, String depart) async {
    print("id : " +
        emId +
        " Firstname: " +
        fname +
        " Lastname : " +
        lname +
        " Email : " +
        depart);
    if (emId.isNotEmpty ||
        fname.isNotEmpty ||
        lname.isNotEmpty ||
        depart.isNotEmpty) {
      final listSearch = await CustomerCareInfo.getSearchData(
          emId, fname, lname, depart); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
      //var check = checkForm([emId.toString(),fname.toString(),lname.toString(),depart.toString()]);
      print("search");
      setState(() {
        listSearch.forEach((v) {
          final lists = CustomerCareInfo.fromJson(v);
          CustomerCareInfo.dataList.add(lists);
          dataListSearch.clear();
        });
      });
    } else {
      alertForm(
          context, 'แจ้งเตือน', 'กรุณาระบุข้อมูลการค้นหาอย่างน้อย 1 ข้อมูล');
    }
  }

  @override
  Widget build(BuildContext context) {
    if (isLoading == true) {
      AppLoader.show();
    }
    if (isLoading == false) {
      AppLoader.hide();
    }
    double _width = MediaQuery.of(context).size.width;
    double _height = MediaQuery.of(context).size.height;

    return Material(
      color: AppColors.bgColor,
      child:  WillPopScope(
        onWillPop: () async {
          Get.offAll(Header.routes);
          return false;
        },
        child: Stack(
          children: <Widget>[
            Header.headerListPage(context),
            Header.mainMenu(context),
            Container(
              width: _width,
              height: mediaQuery(context, 'h', 1300),
              margin: EdgeInsets.only(
                top: mediaQuery(context, 'h', 900),
                left: mediaQuery(context, 'w', 60),
                right: mediaQuery(context, 'w', 60),
              ),
              child: SingleChildScrollView(
                child: Column(
                  children: <Widget>[
                    Container(
                      margin: EdgeInsets.only(
                        top: mediaQuery(context, 'h', 30),
                        bottom: mediaQuery(context, 'h', 50),
                      ),
                      child: Text(
                        'พนักงานดูแลลูกค้า',
                        textAlign: TextAlign.center,
                        style: TextStyle(
                          color: Color(0xFFB58E38),
                          fontSize: mediaQuery(context, 'h', 50),
                        ),
                      ),
                    ),
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          'ชื่อ* :',
                          textAlign: TextAlign.center,
                          style: TextStyle(
                            fontSize: mediaQuery(context, 'h', 34),
                            color: Color(0xFF383838),
                          ),
                        ),
                        SizedBox(
                          height: mediaQuery(context, 'h', 20),
                        ),
                        SizedBox(
                          height: mediaQuery(context, 'h', 130),
                          child: TextField(
                            controller: firstName,
                            decoration: new InputDecoration(
                                contentPadding: new EdgeInsets.fromLTRB(
                                  mediaQuery(context, 'w', 40), 
                                  mediaQuery(context, 'h', 20),
                                  mediaQuery(context, 'w', 40), 
                                  mediaQuery(context, 'w', 40), 
                                ),
                                border: new OutlineInputBorder(
                                  borderRadius: const BorderRadius.all(
                                    const Radius.circular(50.0),
                                  ),
                                ),
                                filled: true,
                                hintStyle: new TextStyle(color: Colors.grey[800]),
                                fillColor: Colors.white70),
                          ),
                        ),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 40),
                    ),
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          'นามสกุล* :',
                          textAlign: TextAlign.center,
                          style: TextStyle(
                            fontSize: mediaQuery(context, 'h', 34),
                            color: Color(0xFF383838),
                          ),
                        ),
                        SizedBox(
                          height: mediaQuery(context, 'h', 20),
                        ),
                        SizedBox(
                          height: mediaQuery(context, 'h', 130),
                          child: TextField(
//                          enabled: false,
                            controller: lastName,
                            decoration: new InputDecoration(
                              contentPadding: new EdgeInsets.fromLTRB(
                                mediaQuery(context, 'w', 40), 
                                mediaQuery(context, 'h', 20),
                                mediaQuery(context, 'w', 40), 
                                mediaQuery(context, 'w', 40), 
                              ),
                              border: new OutlineInputBorder(
                                borderRadius: const BorderRadius.all(
                                  const Radius.circular(50.0),
                                ),
                              ),
                              filled: true,
                              hintStyle: new TextStyle(color: Colors.grey[800]),
                              fillColor: Colors.white70),
                          ),
                        ),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 40),
                    ),
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          'รหัสพนักงาน* :',
                          textAlign: TextAlign.center,
                          style: TextStyle(
                            fontSize: mediaQuery(context, 'h', 34),
                            color: Color(0xFF383838),
                          ),
                        ),
                        SizedBox(
                          height: mediaQuery(context, 'h', 20),
                        ),
                        SizedBox(
                          height: mediaQuery(context, 'h', 130),
                          child: TextField(
//                          enabled: false,
                            keyboardType: TextInputType.number,
                            controller: employeeCode,
                            decoration: new InputDecoration(
                              contentPadding: new EdgeInsets.fromLTRB(
                                mediaQuery(context, 'w', 40), 
                                mediaQuery(context, 'h', 20),
                                mediaQuery(context, 'w', 40), 
                                mediaQuery(context, 'w', 40), 
                              ),
                              border: new OutlineInputBorder(
                                borderRadius: const BorderRadius.all(
                                  const Radius.circular(50.0),
                                ),
                              ),
                              filled: true,
                              hintStyle: new TextStyle(color: Colors.grey[800]),
                              fillColor: Colors.white70),
                          ),
                        ),
//                      _buildDropDownRow(context),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 40),
                    ),
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          'สังกัดพนักงาน :',
                          textAlign: TextAlign.center,
                          style: TextStyle(
                            fontSize: mediaQuery(context, 'h', 34),
                            color: Color(0xFF383838),
                          ),
                        ),
                        SizedBox(
                          height: mediaQuery(context, 'h', 20),
                        ),
                        _buildRowEmail(context, email),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 40),
                    ),
                    GestureDetector(
                      onTap: () {
                        print("ค้นหา");
                        searchData(employeeCode.text, firstName.text,
                            lastName.text, email.text);
                      },
                      child: Container(
                        width: mediaQuery(context, 'w', 1005),
                        height: mediaQuery(context, 'h', 150),
                        decoration: BoxDecoration(
                          borderRadius: new BorderRadius.all(
                            Radius.circular(
                              mediaQuery(context, 'h', 100),
                            ),
                          ),
                          boxShadow: [
                            appShadow(),
                          ],
                          color: AppColors.color_gold,
                        ),
                        child: Center(
                          child: Text(
                            'ค้นหา',
                            textAlign: TextAlign.center,
                            style: TextStyle(
                              fontSize: mediaQuery(context, 'h', 50),
                              color: Colors.white,
                            ),
                          ),
                        ),
                      ),
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 40),
                    ),
                    Container(
                      width: _width,
                      height: mediaQuery(context, 'h',
                          CustomerCareInfo.dataList.isNotEmpty ? 800 : 0),
                      margin: EdgeInsets.only(
                        top: mediaQuery(context, 'h', 40),
                        left: mediaQuery(context, 'w', 10),
                        right: mediaQuery(context, 'w', 10),
                      ),
                      child: SingleChildScrollView(
                        child: Column(
                          children: <Widget>[
                            Column(
                              children: List.generate(
                                  CustomerCareInfo.dataList.length, (index) {
                                return _buildContent(
                                  context,
                                  (index + 1).toString(),
                                  CustomerCareInfo.dataList[index].employeeNumber,
                                  CustomerCareInfo
                                      .dataList[index].employeeFullName,
                                  CustomerCareInfo.dataList[index].telephoneNo,
                                  CustomerCareInfo.dataList[index].saleInfoId,
                                );
                              }),
                            ),
                          ],
                        ),
                      ),
                    ),
                    Row(
                      children: <Widget>[
                        Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: <Widget>[
                            Text(
                              'วันที่เริ่มต้น : ',
                              style: TextStyle(
                                color: AppColors.color_text,
                                fontSize: mediaQuery(context, 'h', 36),
                              ),
                            ),
                            SizedBox(
                              height: mediaQuery(context, 'h', 15),
                            ),
                            Container(
                              height: mediaQuery(context, 'h', 130),
                              width: mediaQuery(context, 'w', 480),
                              child: GestureDetector(
                                onTap: () async {
                                  DateTime newDate = await showRoundedDatePicker(
                                    context: context,
                                    initialDate: strStartDate != ""
                                        ? DateTime.parse(strStartDate)
                                        : DateTime.now(),
                                    firstDate: DateTime(DateTime.now().year - 10),
                                    lastDate: DateTime(DateTime.now().year + 10),
                                    locale: Locale('th', 'TH'),
                                    era: EraMode.BUDDHIST_YEAR,
                                    theme: ThemeData(
                                        primarySwatch: Colors.deepPurple),
                                    height: 280,
                                    textActionButton: "ลบวันที่",
                                      onTapActionButton: (){
                                        setState(() {
                                          startDate.clear();
                                          strStartDate = "";
                                        });
                                    },
                                  );
                                  if (newDate != null) {
                                    var dtArray = newDate.toString().split(" ");
                                    setState(() {
                                      var formatter = DateFormat.yMd();
                                      var showDate = formatter
                                          .formatInBuddhistCalendarThai(newDate);
                                      startDate.text = showDate;
                                      strStartDate = dtArray[0];
                                    });
                                  }
                                },
                                child: Container(
                                  height: mediaQuery(context, 'h', 105),
                                  width: mediaQuery(context, 'w', 490),
                                  padding: EdgeInsets.only(
                                    left: mediaQuery(context, 'h', 20),
                                    right: mediaQuery(context, 'h', 20),
                                  ),
                                  decoration: BoxDecoration(
                                    borderRadius: new BorderRadius.all(
                                      Radius.circular(
                                        mediaQuery(
                                          context,
                                          'h',
                                          150,
                                        ),
                                      ),
                                    ),
                                    border: Border.all(
                                      color: Colors.grey[500],
                                    ),
                                    color: Colors.white,
                                  ),
                                  child: Row(
                                    mainAxisAlignment:
                                        MainAxisAlignment.spaceBetween,
                                    children: <Widget>[
                                      Text(startDate.text),
                                      Icon(
                                        Icons.calendar_today,
                                        color: Colors.grey,
                                        size: mediaQuery(
                                          context,
                                          'h',
                                          80,
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ),
                        SizedBox(
                          width: mediaQuery(context, 'w', 30),
                        ),
                        Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: <Widget>[
                            Text(
                              'วันที่สิ้นสุด : ',
                              style: TextStyle(
                                color: AppColors.color_text,
                                fontSize: mediaQuery(context, 'h', 36),
                              ),
                            ),
                            SizedBox(
                              height: mediaQuery(context, 'h', 15),
                            ),
                            Container(
                              height: mediaQuery(context, 'h', 130),
                              width: mediaQuery(context, 'w', 480),
                              child: GestureDetector(
                                onTap: () async {
                                  DateTime newDate = await showRoundedDatePicker(
                                    context: context,
                                    initialDate: strEndDate != ""
                                        ? DateTime.parse(strEndDate)
                                        : DateTime.now(),
                                    firstDate: DateTime(DateTime.now().year - 10),
                                    lastDate: DateTime(DateTime.now().year + 10),
                                    locale: Locale('th', 'TH'),
                                    era: EraMode.BUDDHIST_YEAR,
                                    theme: ThemeData(
                                        primarySwatch: Colors.deepPurple),
                                    height: 280,
                                    textActionButton: "ลบวันที่",
                                      onTapActionButton: (){
                                        setState(() {
                                          endDate.clear();
                                          strEndDate = "";
                                        });
                                    },
                                  );
                                  if (newDate != null) {
                                    var dtArray = newDate.toString().split(" ");
                                    setState(() {
                                      var formatter = DateFormat.yMd();
                                      var showDate = formatter
                                          .formatInBuddhistCalendarThai(newDate);
                                      endDate.text = showDate;
                                      strEndDate = dtArray[0];
                                    });
                                  }
                                },
                                child: Container(
                                  height: mediaQuery(context, 'h', 105),
                                  width: mediaQuery(context, 'w', 490),
                                  padding: EdgeInsets.only(
                                    left: mediaQuery(context, 'h', 20),
                                    right: mediaQuery(context, 'h', 20),
                                  ),
                                  decoration: BoxDecoration(
                                    borderRadius: new BorderRadius.all(
                                      Radius.circular(
                                        mediaQuery(
                                          context,
                                          'h',
                                          150,
                                        ),
                                      ),
                                    ),
                                    border: Border.all(
                                      color: Colors.grey[500],
                                    ),
                                    color: Colors.white,
                                  ),
                                  child: Row(
                                    mainAxisAlignment:
                                        MainAxisAlignment.spaceBetween,
                                    children: <Widget>[
                                      Text(endDate.text),
                                      Icon(
                                        Icons.calendar_today,
                                        color: Colors.grey,
                                        size: mediaQuery(
                                          context,
                                          'h',
                                          80,
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ),
                        // SizedBox(
                        //   width: mediaQuery(context, 'w', 30),
                        // ),
                        // Column(
                        //   children: [
                        //     Text(''),
                        //     SizedBox(
                        //       height: mediaQuery(context, 'h', 105),
                        //       width: mediaQuery(context, 'w', 90),
                        //       child: FloatingActionButton(
                        //         onPressed: () {
                        //           setState(() {
                        //             endDate.clear();
                        //             strEndDate = "";
                        //           });
                        //         },
                        //         child: Text('ลบ'),
                        //         shape: RoundedRectangleBorder(),
                        //       ),
                        //     ),
                        //   ],
                        // )
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 50),
                    ),
                    Row(
                      children: <Widget>[
                        GestureDetector(
                          onTap: () {
                            Navigator.of(context).pop(false);
                          },
                          child: Container(
                            width: mediaQuery(context, 'w', 485),
                            height: mediaQuery(context, 'h', 150),
                            decoration: BoxDecoration(
                              borderRadius: new BorderRadius.all(
                                Radius.circular(
                                  mediaQuery(context, 'h', 100),
                                ),
                              ),
                              border: Border.all(
                                color: AppColors
                                    .color, //                   <--- border color
                                width: 1,
                              ),
                              boxShadow: [
                                appShadow(),
                              ],
                              color: Color(0xFFf2f5f7),
                            ),
                            child: Center(
                              child: Text(
                                'ยกเลิก',
                                textAlign: TextAlign.center,
                                style: TextStyle(
                                  fontSize: mediaQuery(context, 'h', 50),
                                  color: AppColors.color,
                                ),
                              ),
                            ),
                          ),
                        ),
                        SizedBox(
                          width: mediaQuery(context, 'w', 30),
                        ),
                        GestureDetector(
                          onTap: () {
                            save(context);
                          },
                          child: Container(
                            width: mediaQuery(context, 'w', 485),
                            height: mediaQuery(context, 'h', 150),
                            decoration: BoxDecoration(
                              borderRadius: new BorderRadius.all(
                                Radius.circular(
                                  mediaQuery(context, 'h', 100),
                                ),
                              ),
                              boxShadow: [
                                appShadow(),
                              ],
                              color: AppColors.color,
                            ),
                            child: Center(
                              child: Text(
                                'บันทึก',
                                textAlign: TextAlign.center,
                                style: TextStyle(
                                  fontSize: mediaQuery(context, 'h', 50),
                                  color: Colors.white,
                                ),
                              ),
                            ),
                          ),
                        ),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 30),
                    ),
                  ],
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }

  save(context) async {
    bool chk = await checkForm([
      startDate.text,
    ]);

    if (chk == false) {
      alertForm(context, "แจ้งเตือน", "กรอกข้อมูลไม่ครบ");
    } else {
      bool acceptCondition = false;
      setState(() {
        isLoading = true;
      });

      var startDate = DateTime.parse(strStartDate);
      if(strEndDate.isNotEmpty){
        var endDate = DateTime.parse(strEndDate);
        if ((startDate == endDate || startDate.isBefore(endDate))) {
          acceptCondition = true;
        } else {
          alertForm(context, "แจ้งเตือน",
              "กรุณาตรวจสอบ วันหรือเวลา เริ่มต้น และสิ้นสุดอีกครั้ง");
        }
      }else{
        acceptCondition = true;
      }

      Map<String, dynamic> data = {
        "saleInfoId": selectID,
        "customerId": AppUrl.CustomerID,
        "startDate": strStartDate,
        "endDate": strEndDate.isNotEmpty ? strEndDate : null,
        "authenKey": AppUrl.AuthenKey
      };

      if (acceptCondition) {
        print(data);
        await CustomerCare.createData(context, data);
      }
      setState(() {
        isLoading = false;
      });
    }
  }

  _buildRowEmail(context, TextEditingController controller) {
    _isZero() {
      if (controller.text.length >= 0 && isEmailValid == false) {
        return mediaQuery(context, 'h', 215);
      } else {
        return mediaQuery(context, 'h', 130);
      }
    }

    return Container(
      height: _isZero(),
      width: mediaQuery(context, 'w', 1005),
      child: new TextField(
        // keyboardType: TextInputType.emailAddress,
        controller: controller,
        enabled: true,
        // onChanged: (value){
        //   if(regExp.hasMatch(value)){
        //     isEmailValid = true;
        //   }
        //   else{
        //     isEmailValid = false;
        //   }
        //   setState(() {

        //   });
        // },
        decoration: new InputDecoration(
            //errorText: isEmailValid ? null : "กรุณาตรวจสอบ Email อีกครั้ง",
            border: new OutlineInputBorder(
              borderRadius: const BorderRadius.all(
                const Radius.circular(50.0),
              ),
            ),
            filled: true,
            counterText: "",
            contentPadding: new EdgeInsets.fromLTRB(
              mediaQuery(context, 'w', 40), 
              mediaQuery(context, 'h', 20),
              mediaQuery(context, 'w', 40), 
              mediaQuery(context, 'w', 40), 
            ),
            hintStyle: new TextStyle(color: Colors.grey[800]),
            fillColor: Colors.white70),
      ),
    );
  }

  _buildContent(
    context,
    number,
    id,
    name,
    phone,
    SaleInfoId,
  ) {
    //===============================================================================================
    //                                      Radio Button
    //===============================================================================================
    String _radioValue_ID;
    _buildRadio(String customerRelationshipActivityId) {
      //CustomerRelation.data[index].customerRelationshipActivityId
      return SizedBox(
        child: Row(
          children: <Widget>[
            new Radio(
              value: customerRelationshipActivityId,
              groupValue: SaleInfoId,
              onChanged: (value) {
                setState(() {
                  selectID = SaleInfoId;
                  employeeId = id;
                  print("Value :: " + selectID);
                  print("Employee ID :: " + employeeId);
                });
              },
            ),
          ],
        ),
      );
    }

    //===============================================================================================
    //
    return Container(
      width: mediaQuery(context, 'w', 1005),
//      height: mediaQuery(context, 'h', 380),
      padding: EdgeInsets.all(
        mediaQuery(context, 'h', 30),
      ),
      margin: EdgeInsets.only(
        bottom: mediaQuery(context, 'h', 30),
      ),
      decoration: BoxDecoration(
        borderRadius: new BorderRadius.all(
          Radius.circular(
            mediaQuery(context, 'h', 30),
          ),
        ),
        boxShadow: [
          appShadow(),
        ],
        color: selectID == SaleInfoId ? Colors.grey[350] : Colors.white,
      ),
      child: Row(
        children: <Widget>[
          Container(
            width: mediaQuery(context, 'w', 750),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Text(
                      'ลำดับ : ',
                      style: TextStyle(
                        color: AppColors.color_text,
                        fontSize: mediaQuery(context, 'h', 42),
                      ),
                    ),
                    Text(
                      number,
                      style: TextStyle(
                        color: AppColors.color_text,
                        fontSize: mediaQuery(context, 'h', 40),
                      ),
                    ),
                  ],
                ),
                Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Text(
                      'ชื่อ - สกุล : ',
                      style: TextStyle(
                        color: AppColors.color_text,
                        fontSize: mediaQuery(context, 'h', 42),
                      ),
                    ),
                    Text(
                      name == null ? "" : name,
                      style: TextStyle(
                        color: AppColors.color_text,
                        fontSize: mediaQuery(context, 'h', 40),
                      ),
                    ),
                  ],
                ),
                Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Text(
                      'รหัสพนักงาน : ',
                      style: TextStyle(
                        color: AppColors.color_text,
                        fontSize: mediaQuery(context, 'h', 42),
                      ),
                    ),
                    Flexible(
                      child: Text(
                        id == null ? "" : id,
                        style: TextStyle(
                          color: AppColors.color_text,
                          fontSize: mediaQuery(context, 'h', 40),
                        ),
                      ),
                    ),
                  ],
                ),
                Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Text(
                      'โทรศัพท์ : ',
                      style: TextStyle(
                        color: AppColors.color_text,
                        fontSize: mediaQuery(context, 'h', 42),
                      ),
                    ),
                    Text(
                      phone == null ? "" : phone,
                      style: TextStyle(
                        color: AppColors.color_text,
                        fontSize: mediaQuery(context, 'h', 40),
                      ),
                    ),
                  ],
                ),
              ],
            ),
          ),
          _buildRadio(selectID),
        ],
      ),
    );
  }
} //class
