import 'package:get/get.dart';
import 'package:flutter/material.dart';
import 'package:flutter/cupertino.dart';
import 'package:cloud_firestore/cloud_firestore.dart';
import 'package:flutter_local_notifications/flutter_local_notifications.dart';

import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/service/pref.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/assets.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/strings.dart';
import 'package:mwf_app/service/fontsize.dart';
import 'package:mwf_app/service/navigator.dart';
import 'package:mwf_app/service/notification_count.dart';

import 'package:mwf_app/model/Permission_model.dart';

import 'package:mwf_app/set1/customer_property.dart';
import 'package:mwf_app/set1/electric_statistics.dart';
import 'package:mwf_app/set2/list_customer.dart';
import 'package:mwf_app/set2/visiting_plan_list.dart';
import 'package:mwf_app/set2/activity_relationship.dart';
import 'package:mwf_app/set3/history_payment.dart';
import 'package:mwf_app/set3/history_powerfailed.dart';
import 'package:mwf_app/set3/customer_staff_list.dart';
import 'package:mwf_app/set3/map_navigation_show.dart';
import 'package:mwf_app/set3/offer_additional_list.dart';
import 'package:mwf_app/set5/service_timeline.dart';
import 'package:mwf_app/set5/service_point_of_meter_user.dart';
import 'package:mwf_app/set5/customer_representative_list.dart';
import 'package:mwf_app/set6/save_survey_list.dart';
import 'package:mwf_app/set6/service_report_user.dart';
import 'package:mwf_app/set6/service_question_user.dart';
import 'package:mwf_app/set7/contact_user.dart';

class ServeCustomer extends StatefulWidget {
  @override
  _ServeCustomerState createState() => _ServeCustomerState();
}

class _ServeCustomerState extends State<ServeCustomer> {
  FlutterLocalNotificationsPlugin flutterLocalNotificationsPlugin =
      FlutterLocalNotificationsPlugin();
  String groupid = '';
  String actionview = '';
  String actionadd = '';
  String actionupdate = '';
  String actiondelete = '';
  String actionall = '';
  bool isLoading = true;

  String menuTypeUser = '';
  String menuVisitUser = '';
  String menuActivityUser = '';
  String menuServicesUser = '';
  String menuMapUser = '';
  String menuHistoryPayUser = '';
  String menuHistoryElectUser = '';
  String menuStatisticsUser = '';
  String menuCareUser = '';
  String menuListUser = '';
  String menuPointOfMeterUser = '';
  String menuReportUser = '';
  String menuQuestionUser = '';
  String menuSurveyUser = '';
  String menuContactUser = '';

  @override
  void initState() {
    NotificationCount.getCount();
    setPermissionMenu();
    super.initState();
    Header.routes = ListCustomer();
    Permission.listPermission = [];
    wait();
  }

  wait() async {
    await new Future.delayed(const Duration(milliseconds: 1000));
    setState(() {
      isLoading = false;
    });
  }

  @override
  Widget build(BuildContext context) {
    if (isLoading == true) {
      AppLoader.show();
    }
    if (isLoading == false) {
      AppLoader.hide();
    }

    double _width = MediaQuery.of(context).size.width;
    double _height = MediaQuery.of(context).size.height;

    return Material(
      color: AppColors.bgColor,
      child: WillPopScope(
        onWillPop: () async {
          Get.offAll(Header.routes);
          return false;
        },
        child: Stack(
          children: <Widget>[
            Header.headerListPage(context),
            Header.mainMenu(context),
            Container(
              width: _width,
              height: mediaQuery(context, 'h', 1250),
              margin: EdgeInsets.only(
                top: mediaQuery(context, 'h', 950),
                left: mediaQuery(context, 'w', 60),
                right: mediaQuery(context, 'w', 60),
              ),
              child: SingleChildScrollView(
                child: Column(
                  children: <Widget>[
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: <Widget>[
                        menuTypeUser == "1" || menuTypeUser == ""
                            ? _buildHomeMenu(
                                // คุณลักษณะลูกค้า
                                context,
                                _width,
                                _height,
                                AppAssets.service_type_user,
                                AppStrings.service_type_user,
                                AppStrings.menu_type_user,
                                CustomerProperty(),
                              )
                            : _buildHomeMenuDisable(
                                // คุณลักษณะลูกค้าz
                                context,
                                _width,
                                _height,
                                AppAssets.service_type_user,
                                AppStrings.service_type_user,
                                AppStrings.menu_type_user,
                              ),
                        menuVisitUser == "1" || menuVisitUser == ""
                            ? _buildHomeMenuVisitPlan(
                                //เยี่ยมเยือนลูกค้า
                                context,
                                _width,
                                _height,
                                AppAssets.service_visit_user,
                                AppStrings.service_visit_user,
                                AppStrings.menu_visit_user,
                                VisitingPlanList(),
                              )
                            : _buildHomeMenuDisable(
                                //เยี่ยมเยือนลูกค้า
                                context,
                                _width,
                                _height,
                                AppAssets.service_visit_user,
                                AppStrings.service_visit_user,
                                AppStrings.menu_visit_user,
                              ),
                        menuActivityUser == "1" || menuActivityUser == ""
                            ? _buildHomeMenuActivity(
                                // กิจกรรมสร้างความสัมพันธ์
                                context,
                                _width,
                                _height,
                                AppAssets.service_activity_user,
                                AppStrings.service_activity_user,
                                AppStrings.menu_activity_user,
                                ActivityRelationship(),
                              )
                            : _buildHomeMenuDisable(
                                // กิจกรรมสร้างความสัมพันธ์
                                context,
                                _width,
                                _height,
                                AppAssets.service_activity_user,
                                AppStrings.service_activity_user,
                                AppStrings.menu_activity_user,
                              ),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 60),
                    ),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: <Widget>[
                        menuServicesUser == "1" || menuServicesUser == ""
                            ? _buildHomeMenuPackageOption(
                                // เสนอบริการเสริม
                                context,
                                _width,
                                _height,
                                AppAssets.service_services_user,
                                AppStrings.service_services_user,
                                AppStrings.menu_services_user,
                                OfferAdditionalList(),
                              )
                            : _buildHomeMenuDisable(
                                // เสนอบริการเสริม
                                context,
                                _width,
                                _height,
                                AppAssets.service_services_user,
                                AppStrings.service_services_user,
                                AppStrings.menu_services_user,
                              ),
                        menuMapUser == "1" || menuMapUser == ""
                            ? _buildHomeMenu(
                                // แผนที่ และการนำทาง
                                context,
                                _width,
                                _height,
                                AppAssets.service_map_user,
                                AppStrings.service_map_user,
                                AppStrings.menu_map_user,
                                MapNavigationShow(false, 2.22, 1.11),
                              )
                            : _buildHomeMenuDisable(
                                // แผนที่ และการนำทาง
                                context,
                                _width,
                                _height,
                                AppAssets.service_map_user,
                                AppStrings.service_map_user,
                                AppStrings.menu_map_user,
                              ),
                        menuHistoryPayUser == "1" || menuHistoryPayUser == ""
                            ? _buildHomeMenu(
                                // ประวัติการชำระค่าไฟฟ้า
                                context,
                                _width,
                                _height,
                                AppAssets.service_historyPay_user,
                                AppStrings.service_historyPay_user,
                                AppStrings.menu_historyPay_user,
                                HistoryPayment(),
                              )
                            : _buildHomeMenuDisable(
                                // ประวัติการชำระค่าไฟฟ้า
                                context,
                                _width,
                                _height,
                                AppAssets.service_historyPay_user,
                                AppStrings.service_historyPay_user,
                                AppStrings.menu_historyPay_user,
                              ),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 60),
                    ),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: <Widget>[
                        menuHistoryElectUser == "1" ||
                                menuHistoryElectUser == ""
                            ? _buildHomeMenuPowerFail(
                                // ไฟฟ้าขัดข้องและแผนดับไฟฟ้า
                                context,
                                _width,
                                _height,
                                AppAssets.service_historyElect_user,
                                AppStrings.service_historyElect_user,
                                AppStrings.menu_historyElect_user,
                                HistoryPowerFailed(),
                              )
                            : _buildHomeMenuDisable(
                                // ไฟฟ้าขัดข้องและแผนดับไฟฟ้า
                                context,
                                _width,
                                _height,
                                AppAssets.service_historyElect_user,
                                AppStrings.service_historyElect_user,
                                AppStrings.menu_historyElect_user,
                              ),
                        menuStatisticsUser == "1" || menuStatisticsUser == ""
                            ? _buildHomeMenu(
                                // สถิติการใช้ไฟฟ้า
                                context,
                                _width,
                                _height,
                                AppAssets.service_statistics_user,
                                AppStrings.service_statistics_user,
                                AppStrings.menu_statistics_user,
                                ElectricStatistics(),
                              )
                            : _buildHomeMenuDisable(
                                // สถิติการใช้ไฟฟ้า
                                context,
                                _width,
                                _height,
                                AppAssets.service_statistics_user,
                                AppStrings.service_statistics_user,
                                AppStrings.menu_statistics_user,
                              ),
                        menuCareUser == "1" || menuCareUser == ""
                            ? _buildHomeMenu(
                                // พนักงานดูแลลูกค้า
                                context,
                                _width,
                                _height,
                                AppAssets.service_care_user,
                                AppStrings.service_care_user,
                                AppStrings.menu_care_user,
                                Customerstaff_list(),
                              )
                            : _buildHomeMenuDisable(
                                // พนักงานดูแลลูกค้า
                                context,
                                _width,
                                _height,
                                AppAssets.service_care_user,
                                AppStrings.service_care_user,
                                AppStrings.menu_care_user,
                              ),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 60),
                    ),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: <Widget>[
                        menuListUser == "1" || menuListUser == ""
                            ? _buildHomeMenu(
                                // ข้อมูลผู้ติดต่อรายชื่อผู้แทนลูกค้า
                                context,
                                _width,
                                _height,
                                AppAssets.service_list_user,
                                AppStrings.service_list_user,
                                AppStrings.menu_list_user,
                                CustomerRepresentativeList(),
                              )
                            : _buildHomeMenuDisable(
                                // ข้อมูลผู้ติดต่อรายชื่อผู้แทนลูกค้า
                                context,
                                _width,
                                _height,
                                AppAssets.service_list_user,
                                AppStrings.service_list_user,
                                AppStrings.menu_list_user,
                              ),
                        menuPointOfMeterUser == "1" ||
                                menuPointOfMeterUser == ""
                            ? _buildHomeMenu(
                                // จุดติดตั้งมิเตอร์ไฟฟ้า
                                context,
                                _width,
                                _height,
                                AppAssets.service_pointOfMeter_user,
                                AppStrings.service_pointOfMeter_user,
                                AppStrings.menu_pointOfMeter_user,
                                ServicePointOfMeterUser(),
                              )
                            : _buildHomeMenuDisable(
                                // จุดติดตั้งมิเตอร์ไฟฟ้า
                                context,
                                _width,
                                _height,
                                AppAssets.service_pointOfMeter_user,
                                AppStrings.service_pointOfMeter_user,
                                AppStrings.menu_pointOfMeter_user,
                              ),
                        menuReportUser == "1" || menuReportUser == ""
                            ? _buildHomeMenu(
                                // เสียงลูกค้า
                                context,
                                _width,
                                _height,
                                AppAssets.service_report_user,
                                AppStrings.service_report_user,
                                AppStrings.menu_report_user,
                                ServiceReportUser(),
                              )
                            : _buildHomeMenuDisable(
                                // เสียงลูกค้า
                                context,
                                _width,
                                _height,
                                AppAssets.service_report_user,
                                AppStrings.service_report_user,
                                AppStrings.menu_report_user,
                              ),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 60),
                    ),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: <Widget>[
                        menuQuestionUser == "1" || menuQuestionUser == ""
                            ? _buildHomeMenu(
                                // บันทึกแบบสอบถาม
                                context,
                                _width,
                                _height,
                                AppAssets.service_question_user,
                                AppStrings.service_question_user,
                                AppStrings.menu_question_user,
                                ServiceQuestionUser(),
                              )
                            : _buildHomeMenuDisable(
                                // บันทึกแบบสอบถาม
                                context,
                                _width,
                                _height,
                                AppAssets.service_question_user,
                                AppStrings.service_question_user,
                                AppStrings.menu_question_user,
                              ),
                        menuSurveyUser == "1" || menuSurveyUser == ""
                            ? _buildHomeMenu(
                                // บันทีกแบบสำรวจ
                                context,
                                _width,
                                _height,
                                AppAssets.service_survey_user,
                                AppStrings.service_survey_user,
                                AppStrings.menu_survey_user,
                                SaveSurveyList(),
                              )
                            : _buildHomeMenuDisable(
                                // บันทีกแบบสำรวจ
                                context,
                                _width,
                                _height,
                                AppAssets.service_survey_user,
                                AppStrings.service_survey_user,
                                AppStrings.menu_survey_user,
                              ),
                        menuContactUser == "1" || menuContactUser == ""
                            ? _buildHomeMenu(
                                // ประวัติการติดต่อสื่อสาร
                                context,
                                _width,
                                _height,
                                AppAssets.service_contact_user,
                                AppStrings.service_contact_user,
                                AppStrings.menu_contact_user,
                                ContactUser())
                            : _buildHomeMenuDisable(
                                // ประวัติการติดต่อสื่อสาร
                                context,
                                _width,
                                _height,
                                AppAssets.service_contact_user,
                                AppStrings.service_contact_user,
                                AppStrings.menu_contact_user,
                              ),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 60),
                    ),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: <Widget>[
                        _buildHomeMenu(
                            context,
                            _width,
                            _height,
                            AppAssets.service_Timeline,
                            AppStrings.service_Timeline,
                            '',
                            service_Timeline(
                                "", AppStrings.serviceCompanyName)),
                      ],
                    ),
                  ],
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }

  check(name) {
    print("==== List ====");
    String splName = name.replaceAll("\n", "");
    print("Name : " + splName);
    print("----- Length :: " + Permission.listPermission.length.toString());
    for (var i = 0; i < Permission.listPermission.length; i++) {
      if (Permission.listPermission[i].menuname == splName) {
        setState(() {
          groupid = Permission.listPermission[i].authenGroupId;
          actionview = Permission.listPermission[i].actionView.toString();
          actionadd = Permission.listPermission[i].actionAdd.toString();
          actionupdate = Permission.listPermission[i].actionUpdate.toString();
          actiondelete = Permission.listPermission[i].actionDelete.toString();
          actionall = Permission.listPermission[i].actionAll.toString();
        });
      }
    }
  }

  setPermissionMenu() async {
    menuTypeUser = await getPref("String", "menuTypeUser") ?? "1";
    menuVisitUser = await getPref("String", "menuVisitUser") ?? "1";
    menuActivityUser =  await getPref("String", "menuActivityUser") ?? "1";
    menuServicesUser = await getPref("String", "menuServicesUser") ?? "1";
    menuMapUser = await getPref("String", "menuMapUser") ?? "1";
    menuHistoryPayUser = await getPref("String", "menuHistoryPayUser") ?? "1";
    menuHistoryElectUser = await getPref("String", "menuHistoryElectUser") ?? "1";
    menuStatisticsUser = await getPref("String", "menuStatisticsUser") ?? "1";
    menuCareUser = await getPref("String", "menuCareUser") ?? "1";
    menuListUser = await getPref("String", "menuListUser") ?? "1";
    menuPointOfMeterUser = await getPref("String", "menuPointOfMeterUser") ?? "1";
    menuReportUser = await getPref("String", "menuReportUser") ?? "1";
    menuQuestionUser = await getPref("String", "menuQuestionUser") ?? "1";
    menuSurveyUser = await getPref("String", "menuSurveyUser") ?? "1";
    menuContactUser = await getPref("String", "menuContactUser") ?? "1";
  } // End function

  _buildHomeMenu(context, _width, _height, image, name, menuName, route) {
    return Material(
      type: MaterialType.transparency,
      elevation: 6.0,
      color: Colors.transparent,
      child: Ink(
        decoration: BoxDecoration(
          borderRadius: new BorderRadius.all(
            Radius.circular(
              mediaQuery(context, 'h', 40),
            ),
          ),
          color: Colors.white,
        ),
        child: InkWell(
          borderRadius: new BorderRadius.all(
            Radius.circular(
              mediaQuery(context, 'h', 40),
            ),
          ),
          splashColor: Colors.white70,
          onTap: () {
            check(menuName);
            Nav.push(context, route);
          },
          child: Container(
            width: mediaQuery(context, 'w', 300),
            height: mediaQuery(context, 'h', 365),
            alignment: Alignment.center,
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                Image.asset(
                  image,
                  width: mediaQuery(context, 'w', 124),
                  height: mediaQuery(context, 'h', 120),
                ),
                Text(
                  name == null ? "" : name,
                  textAlign: TextAlign.center,
                  style: TextStyle(
                    fontSize: mediaQuery(context, 'h', AppFontSize.menuHome),
                  ),
                ),
              ],
            ),
          ), // other widget
        ),
      ),
    );
  }

  _buildHomeMenuDisable(context, _width, _height, image, name, menuName) {
    return Material(
      type: MaterialType.transparency,
      elevation: 6.0,
      color: Colors.transparent,
      child: Ink(
        decoration: BoxDecoration(
          borderRadius: new BorderRadius.all(
            Radius.circular(
              mediaQuery(context, 'h', 40),
            ),
          ),
          color: Colors.white70,
          // color: Colors.white,
        ),
        child: InkWell(
          borderRadius: new BorderRadius.all(
            Radius.circular(
              mediaQuery(context, 'h', 40),
            ),
          ),
          splashColor: Colors.white70,
          child: Container(
            width: mediaQuery(context, 'w', 300),
            height: mediaQuery(context, 'h', 365),
            alignment: Alignment.center,
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                Image.asset(
                  image,
                  width: mediaQuery(context, 'w', 124),
                  height: mediaQuery(context, 'h', 120),
                ),
                Text(
                  name == null ? "" : name,
                  textAlign: TextAlign.center,
                  style: TextStyle(
                    color: Colors.grey,
                    fontSize: mediaQuery(context, 'h', AppFontSize.menuHome),
                  ),
                ),
              ],
            ),
          ), // other widget
        ),
      ),
    );
  }

  _buildHomeMenuVisitPlan(
      context, _width, _height, image, name, menuName, route) {
    return Material(
      type: MaterialType.transparency,
      elevation: 6.0,
      color: Colors.transparent,
      child: Ink(
        decoration: BoxDecoration(
          borderRadius: new BorderRadius.all(
            Radius.circular(
              mediaQuery(context, 'h', 40),
            ),
          ),
          color: Colors.white,
          // color: Colors.white,
        ),
        child: InkWell(
          borderRadius: new BorderRadius.all(
            Radius.circular(
              mediaQuery(context, 'h', 40),
            ),
          ),
          splashColor: Colors.white70,
          onTap: () {
            check(menuName);
            setState(() {
              setPref('int', "visitplan", 0);
              NotificationCount.visitplanCount = 0;
            });
            Nav.push(context, route);
          },
          child: Stack(
            children: [
              NotificationCount.visitplanCount != 0
                  ? Row(
                      children: [
                        SizedBox(
                          width: mediaQuery(context, 'w', 200),
                          height: 1,
                        ),
                        Container(
                          width: mediaQuery(context, 'w', 89),
                          decoration: BoxDecoration(
                              color: Colors.red,
                              borderRadius: BorderRadius.circular(10.0)),
                          alignment: Alignment.center,
                          child: Text(
                            NotificationCount.visitplanCount.toString(),
                            style: TextStyle(
                                fontSize: mediaQuery(context, 'h', 50),
                                letterSpacing: 0.8,
                                color: Colors.white,
                                fontWeight: FontWeight.w500),
                          ),
                        ),
                      ],
                    )
                  : Container(),
              Positioned(
                child: Container(
                  width: mediaQuery(context, 'w', 300),
                  height: mediaQuery(context, 'h', 365),
                  alignment: Alignment.center,
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: <Widget>[
                      Image.asset(
                        image,
                        width: mediaQuery(context, 'w', 124),
                        height: mediaQuery(context, 'h', 120),
                      ),
                      Text(
                        name == null ? "" : name,
                        textAlign: TextAlign.center,
                        style: TextStyle(
                          fontSize:
                              mediaQuery(context, 'h', AppFontSize.menuHome),
                        ),
                      ),
                    ],
                  ),
                ),
              ),
            ],
          ), // other widget
        ),
      ),
    );
  }

  _buildHomeMenuActivity(
      context, _width, _height, image, name, menuName, route) {
    return Material(
      type: MaterialType.transparency,
      elevation: 6.0,
      color: Colors.transparent,
      child: Ink(
        decoration: BoxDecoration(
          borderRadius: new BorderRadius.all(
            Radius.circular(
              mediaQuery(context, 'h', 40),
            ),
          ),
          color: Colors.white,
          // color: Colors.white,
        ),
        child: InkWell(
          borderRadius: new BorderRadius.all(
            Radius.circular(
              mediaQuery(context, 'h', 40),
            ),
          ),
          splashColor: Colors.white70,
          onTap: () {
            check(menuName);
            setState(() {
              setPref('int', "activity", 0);
              NotificationCount.activityCount = 0;
            });
            Nav.push(context, route);
          },
          child: Stack(
            children: [
              NotificationCount.activityCount != 0
                  ? Row(
                      children: [
                        SizedBox(
                          width: mediaQuery(context, 'w', 200),
                          height: 1,
                        ),
                        Container(
                          width: mediaQuery(context, 'w', 89),
                          decoration: BoxDecoration(
                              color: Colors.red,
                              borderRadius: BorderRadius.circular(10.0)),
                          alignment: Alignment.center,
                          child: Text(
                            NotificationCount.activityCount.toString(),
                            style: TextStyle(
                                fontSize: mediaQuery(context, 'h', 50),
                                letterSpacing: 0.8,
                                color: Colors.white,
                                fontWeight: FontWeight.w500),
                          ),
                        ),
                      ],
                    )
                  : Container(),
              Positioned(
                child: Container(
                  width: mediaQuery(context, 'w', 300),
                  height: mediaQuery(context, 'h', 365),
                  alignment: Alignment.center,
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: <Widget>[
                      Image.asset(
                        image,
                        width: mediaQuery(context, 'w', 124),
                        height: mediaQuery(context, 'h', 120),
                      ),
                      Text(
                        name == null ? "" : name,
                        textAlign: TextAlign.center,
                        style: TextStyle(
                          fontSize:
                              mediaQuery(context, 'h', AppFontSize.menuHome),
                        ),
                      ),
                    ],
                  ),
                ),
              ),
            ],
          ), // other widget
        ),
      ),
    );
  }

  _buildHomeMenuPackageOption(
      context, _width, _height, image, name, menuName, route) {
    return Material(
      type: MaterialType.transparency,
      elevation: 6.0,
      color: Colors.transparent,
      child: Ink(
        decoration: BoxDecoration(
          borderRadius: new BorderRadius.all(
            Radius.circular(
              mediaQuery(context, 'h', 40),
            ),
          ),
          color: Colors.white,
          // color: Colors.white,
        ),
        child: InkWell(
          borderRadius: new BorderRadius.all(
            Radius.circular(
              mediaQuery(context, 'h', 40),
            ),
          ),
          splashColor: Colors.white70,
          onTap: () {
            check(menuName);
            setState(() {
              setPref('int', "packageoption", 0);
              NotificationCount.packageOptionCount = 0;
            });
            Nav.push(context, route);
          },
          child: Stack(
            children: [
              NotificationCount.packageOptionCount != 0
                  ? Row(
                      children: [
                        SizedBox(
                          width: mediaQuery(context, 'w', 200),
                          height: 1,
                        ),
                        Container(
                          width: mediaQuery(context, 'w', 89),
                          decoration: BoxDecoration(
                              color: Colors.red,
                              borderRadius: BorderRadius.circular(10.0)),
                          alignment: Alignment.center,
                          child: Text(
                            NotificationCount.packageOptionCount.toString(),
                            style: TextStyle(
                                fontSize: mediaQuery(context, 'h', 50),
                                letterSpacing: 0.8,
                                color: Colors.white,
                                fontWeight: FontWeight.w500),
                          ),
                        ),
                      ],
                    )
                  : Container(),
              Positioned(
                child: Container(
                  width: mediaQuery(context, 'w', 300),
                  height: mediaQuery(context, 'h', 365),
                  alignment: Alignment.center,
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: <Widget>[
                      Image.asset(
                        image,
                        width: mediaQuery(context, 'w', 124),
                        height: mediaQuery(context, 'h', 120),
                      ),
                      Text(
                        name == null ? "" : name,
                        textAlign: TextAlign.center,
                        style: TextStyle(
                          fontSize:
                              mediaQuery(context, 'h', AppFontSize.menuHome),
                        ),
                      ),
                    ],
                  ),
                ),
              ),
            ],
          ), // other widget
        ),
      ),
    );
  }

  _buildHomeMenuPowerFail(
      context, _width, _height, image, name, menuName, route) {
    return Material(
      type: MaterialType.transparency,
      elevation: 6.0,
      color: Colors.transparent,
      child: Ink(
        decoration: BoxDecoration(
          borderRadius: new BorderRadius.all(
            Radius.circular(
              mediaQuery(context, 'h', 40),
            ),
          ),
          color: Colors.white,
          // color: Colors.white,
        ),
        child: InkWell(
          borderRadius: new BorderRadius.all(
            Radius.circular(
              mediaQuery(context, 'h', 40),
            ),
          ),
          splashColor: Colors.white70,
          onTap: () {
            check(menuName);
            setState(() {
              setPref('int', "electricproblem", 0);
              NotificationCount.electricProblemCount = 0;
              //NotificationCount.resetNoti('electricproblem');
            });
            Nav.push(context, route);
          },
          child: Stack(
            children: [
              // NotificationCount.electricProblemCount != 0
              //     ? Row(
              //         children: [
              //           SizedBox(
              //             width: mediaQuery(context, 'w', 200),
              //             height: 1,
              //           ),
              //           Container(
              //             width: mediaQuery(context, 'w', 89),
              //             decoration: BoxDecoration(
              //                 color: Colors.red,
              //                 borderRadius: BorderRadius.circular(10.0)),
              //             alignment: Alignment.center,
              //             child: Text(
              //               NotificationCount.electricProblemCount.toString(),
              //               style: TextStyle(
              //                   fontSize: mediaQuery(context, 'h', 50),
              //                   letterSpacing: 0.8,
              //                   color: Colors.white,
              //                   fontWeight: FontWeight.w500),
              //             ),
              //           ),
              //         ],
              //       )
              //     : Container(),
              StreamBuilder(
                stream: FirebaseFirestore
                  .instance.collection(AppStrings.collection)
                  .doc(AppStrings.electricproblem).snapshots(),
                builder: (BuildContext context,  snapshot) {
                  if(!snapshot.hasData){
                    return Container();
                  }else{
                    var number = snapshot.data["running_number"];
                    int calc = NotificationCount.calcNoti(AppStrings.electricproblem, number);
                    if(number != 0){
                      if(number > 99){
                        number = "99+";
                      }
                      return _notifyAlert(calc);
                    }else{
                      return Container();
                    }
                  }
                },
              ),
              Positioned(
                child: Container(
                  width: mediaQuery(context, 'w', 300),
                  height: mediaQuery(context, 'h', 365),
                  alignment: Alignment.center,
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: <Widget>[
                      Image.asset(
                        image,
                        width: mediaQuery(context, 'w', 124),
                        height: mediaQuery(context, 'h', 120),
                      ),
                      Text(
                        name == null ? "" : name,
                        textAlign: TextAlign.center,
                        style: TextStyle(
                          fontSize:
                              mediaQuery(context, 'h', AppFontSize.menuHome),
                        ),
                      ),
                    ],
                  ),
                ),
              ),
            ],
          ), // other widget
        ),
      ),
    );
  }

  Widget _notifyAlert(int number){
    return number != 0 ? 
    Row(
      children: [
        SizedBox(
          width: mediaQuery(context, 'w', 200),
          height: 1,
        ),
        Container(
          width: mediaQuery(context, 'w', 100),
          decoration: BoxDecoration(
            color: Colors.red,
            borderRadius: BorderRadius.circular(10.0),
          ),
          alignment: Alignment.center,
          child: Text(
              "$number",
              style: TextStyle(
                fontSize: mediaQuery(context, 'h', 45),
                letterSpacing: 0.8,
                color: Colors.white,
                fontWeight: FontWeight.w500,
              ),
            )
        ),
      ],
    ) : Container();
  }
} //class
