import 'dart:async';
import 'package:get/get.dart';
import 'package:flutter/material.dart';
import 'package:flutter/cupertino.dart';
import 'package:google_maps_flutter/google_maps_flutter.dart';

import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/assets.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/strings.dart';
import 'package:mwf_app/service/fontsize.dart';
import 'package:mwf_app/service/navigator.dart';

import 'package:mwf_app/model/customer_Info.dart';
import 'package:mwf_app/set1/customer_property.dart';
import 'package:mwf_app/set3/map_navigation_show.dart';

class CustomerPropertyEdit extends StatefulWidget {
  @override
  _CustomerPropertyEditState createState() => _CustomerPropertyEditState();
}

class _CustomerPropertyEditState extends State<CustomerPropertyEdit> {
  TextEditingController customerGroup = TextEditingController(); //กลุ่มลูกค้า
  TextEditingController highValue = TextEditingController(); // highValue
  TextEditingController averageValue = TextEditingController(); //มูลค่าเฉลี่ยน
  TextEditingController keyStatus =
      TextEditingController(); // สถานะ key account
  TextEditingController businessPartner =
      TextEditingController(); // Business Partner
  TextEditingController transformSize = TextEditingController(); // ขนาดหม้อแปลง
  TextEditingController website = TextEditingController(); // เว็บไซต์
  TextEditingController latitude = TextEditingController(); //ละจิตูด
  TextEditingController longitude = TextEditingController(); // ลองจิตูด
  TextEditingController inIndustry = TextEditingController(); // เชตอุตสาหกรรม
  String SelectedGroup = "";
  String hintSelectedGroup = "";
  String SelectedStatus = "";
  String hintSelectedStatus = "";
  String SelectedHighValue = "";
  String hintSelectedHighValue = "";
  //  ตัวแปรกลุ่มลักษณะหลัก
  bool monVal = false; //ระดับแรงดัน 69/115/2
  bool monVal2 = false; // ค่าไฟฟ้าเฉลี่ยนต่อเดือน
  bool monVal3 = false; // กลุ่มเสียงสูญเสียรายได้
  bool monValOwn = false; // กลุ่มเสียงสูญเสียรายได้จากการผลิตไฟฟ้าใช้เอง
  bool monVal4 = false; // ลูกค้าธุรกิจเสริม
  bool monVal5 = false; // มีศักยภาพสอดคล้อง
  bool monVal6 = false; // มีเครือข่ายทั่วประเทศ
//  ตัวแปรกลุ่มลักษณะรอง
  bool monVal8 = false; //กลุ่มตอบสนอง
  bool monVal9 = false; //ลูกค้าที่มีมูลค่าความเสีบหายสูงจากไฟฟ้าขัดข้อง
  bool monVal10 = false; //ลูกค้าสำคัญรายเดิม

  var customerInfo1; //คุณลักษณะกลุ่มหลัก
  var customerInfo2; //คุณลักษณะกลุ่มรอง

  String industrialArea = ''; //เขตอุตสาหกรรม
  String ruralArea = ''; // เขตเมืองชนบท

  int radioRuralArea = 0;
  int radioIndustrialArea = 0;
  bool bIsCountryside = false;
  bool bIndustrialArea = false;

  bool isLoading = false;

  List<String> mainGroup =
      []; // ใช้เก็บข้อมูล ุณลักษณะกลุ่มหลัก สำหรับบันทึก api
  List<String> minorGroup =
      []; // ใช้เก็บข้อมูล ุณลักษณะกลุ่มรอง สำหรับบันทึก api
  List<Marker> myMarker = []; //maker map

  static List<CustomGroupList> dataGroup = []; // ตัวแปรที่จะเรียกใช้งาน
  static List<StatusAccountList> dataStatus = []; // ตัวแปรที่จะเรียกใช้งาน
  static List<HighValuetList> dataHighValue = [];

  List<KeyValueModel> _dropdownGroup = [
    KeyValueModel(key: "เลือก", value: ""),
  ];
  List<KeyValueModel> _dropdownStatus = [
    KeyValueModel(key: "เลือก", value: ""),
  ];
  List<KeyValueModel> _dropdownHighValue = [
    KeyValueModel(key: "เลือก", value: ""),
  ];

  @override
  void deactivate() {
    super.deactivate();
    print('Screen is Deactivate edit!');
  }

  static getDataGroup() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.CustomerEdit_ClassificationList +
            "?AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api

    dataGroup.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getStatusAccount() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.KamTypeList + "?AuthenKey=" + AppUrl.AuthenKey); // เรียกใช้ api

    dataStatus.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getHighValue() async {
    final response = await AppApi.apiGetRequest(AppUrl.HighValueList +
        "?AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api

    dataHighValue.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  loadDataGroupType() async {
    final listGroupType =
        await getDataGroup(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
    for (var i = 0; i < listGroupType.length; i++) {
      setState(() {
        _dropdownGroup.add(
          KeyValueModel(
            key: listGroupType[i]['CustomerClassificationName'].toString(),
            // key คือค่าที่แสดง
            value: listGroupType[i]['CustomerClassificationId']
                .toString(), // value ค่าที่บันทึก
          ),
        );
      });
    }

    final listStatusAccount =
        await getStatusAccount(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
    for (var i = 0; i < listStatusAccount.length; i++) {
      setState(() {
        _dropdownStatus.add(
          KeyValueModel(
            key: listStatusAccount[i]['KamTypeName'].toString(),
            // key คือค่าที่แสดง
            value: listStatusAccount[i]['KamTypeId']
                .toString(), // value ค่าที่บันทึก
          ),
        );
      });
    }

    final listHighValue =
        await getHighValue(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
    for (var i = 0; i < listHighValue.length; i++) {
      setState(() {
        _dropdownHighValue.add(
          KeyValueModel(
            key: listHighValue[i]['HighValue'].toString(),
            // key คือค่าที่แสดง
            value: listHighValue[i]['HighValueId']
                .toString(), // value ค่าที่บันทึก
          ),
        );
      });
    }
    return "xx";
  }

  void initState() {
    super.initState();
    Header.routes = CustomerProperty();
    loadDataGroupType();
    loadData().then((res) {
      setState(() {
        customerGroup.text =
            CustomerInfo.data[0].customerClassification; //กลุ่มลูกค้า
        hintSelectedGroup = customerGroup.text.toString();
        SelectedGroup =
            CustomerInfo.data[0].customerClassificationID.toString();
        highValue.text = CustomerInfo.data[0].highValueSize; // highValue
        hintSelectedHighValue = highValue.text.toString();
        SelectedHighValue = CustomerInfo.data[0].highValueSizeID.toString();
        averageValue.text =
            CustomerInfo.data[0].highValueAmount; //มูลค่าเฉลี่ยน
        keyStatus.text = CustomerInfo.data[0].kamType; // สถานะ key account
        hintSelectedStatus = keyStatus.text.toString();
        SelectedStatus = CustomerInfo.data[0].kamTypeID.toString();
        businessPartner.text =
            CustomerInfo.data[0].businessPartner; // Business Partner
        transformSize.text =
            CustomerInfo.data[0].sizeoftransformer; // ขนาดหม้อแปลง
        website.text = CustomerInfo.data[0].website; // เว็บไซต์
        latitude.text = CustomerInfo.data[0].latitude; //ละจิตูด
        longitude.text = CustomerInfo.data[0].longitude; // ลองจิตูด

        double _latitude = double.parse(CustomerInfo.data[0].latitude);
        double _longitude = double.parse(CustomerInfo.data[0].longitude);
        myMarker.add(Marker(
          markerId: MarkerId(LatLng(_latitude, _longitude).toString()),
          position: LatLng(_latitude, _longitude),
        ));
        if (CustomerInfo.data[0].isIndustrialArea) {
          radioIndustrialArea = 1;
          bIndustrialArea = true;
        } else if (CustomerInfo.data[0].isCountryside) {
          radioIndustrialArea = 2;
        } else if (!CustomerInfo.data[0].isIndustrialArea &&
            !CustomerInfo.data[0].isCountryside) {
          radioIndustrialArea = 3;
        }
      });

      print(mainGroup);

      if (CustomerInfo.data[0].haveVoltageKv) {
        setState(() {
          monVal = true; //ระดับแรงดัน 69/115/2
        });
      }

      if (CustomerInfo.data[0].haveHighElectricityBill) {
        setState(() {
          monVal2 = true; // ค่าไฟฟ้าเฉลี่ยนต่อเดือน
        });
      }

      if (CustomerInfo.data[0].haveRiskLoseToSpp) {
        setState(() {
          monVal3 = true; // กลุ่มเสียงสูญเสียรายได้
        });
      }

      if (CustomerInfo.data[0].haveRiskLoseToOwnElectric) {
        setState(() {
          monValOwn = true; // กลุ่มเสียงสูญเสียรายได้
        });
      }

      if (CustomerInfo.data[0].havePotentialMoreBusiness) {
        setState(() {
          monVal4 = true; // ลูกค้าธุรกิจเสริม
        });
      }

      if (CustomerInfo.data[0].havePotentialStrategicEconomy) {
        setState(() {
          monVal5 = true; // มีศักยภาพสอดคล้อง
        });
      }

      if (CustomerInfo.data[0].haveConnection) {
        setState(() {
          monVal6 = true; // มีเครือข่ายทั่วประเทศ
        });
      }

      minorGroup
          .add(CustomerInfo.data[0].customerInfo2.toString()); // เพิ่มค่าเข้าไป

      if (CustomerInfo.data[0].haveGoodImageToOrganization) {
        setState(() {
          monVal8 = true; //กลุ่มตอบสนอง
        });
      }

      if (CustomerInfo.data[0].haveLoseMoneyFromElectricProblem) {
        setState(() {
          monVal9 = true; //ลูกค้าที่มีมูลค่าความเสีบหายสูงจากไฟฟ้าขัดข้อง
        });
      }

      if (CustomerInfo.data[0].isOldKam) {
        setState(() {
          monVal10 = true; //ลูกค้าสำคัญรายเดิม
        });
      }

      if (CustomerInfo.data[0].isCountryside) {
        radioRuralArea = 2;
      } else if (!CustomerInfo.data[0].isCountryside) {
        radioRuralArea = 1;
        bIsCountryside = true;
      } else {
        radioRuralArea = 3;
      }
    });
  }

  loadData() async {
    setState(() {
      isLoading = true;
    });
    final list = await CustomerInfo.getData(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
    setState(() {
      final customerInfoList = CustomerInfo.fromJson(list);
      CustomerInfo.data.add(customerInfoList); // loop เก็บข้อมูล
    });
    await new Future.delayed(const Duration(milliseconds: 1000));
    setState(() {
      isLoading = false;
    });
    return true;
  }

  @override
  Widget build(BuildContext context) {
    if (isLoading == true) {
      AppLoader.show();
    }
    if (isLoading == false) {
      AppLoader.hide();
    }
    double _width = MediaQuery.of(context).size.width;
    double _height = MediaQuery.of(context).size.height;
    return Material(
      color: AppColors.bgColor,
      child: WillPopScope(
        onWillPop: () async {
          Get.offAll(Header.routes);
          return false;
        },
        child: Stack(
          children: <Widget>[
            Header.headerListPage(context),
            Header.mainMenu(context),
            Container(
              margin: EdgeInsets.only(
                top: mediaQuery(context, 'h', 950),
              ),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  Text(
                    AppStrings.CustomerProp_CustomerProperty,
                    style: TextStyle(
                        fontSize:
                            mediaQuery(context, 'h', AppFontSize.headText),
                        color: AppColors.color_gold),
                    textAlign: TextAlign.center,
                  ),
                ],
              ),
            ),
            Container(
              //  icon เมนู
              width: _width,
              height: mediaQuery(context, 'h', 1150),
              margin: EdgeInsets.only(
                top: mediaQuery(context, 'h', 1080),
                left: mediaQuery(context, 'w', 30),
                right: mediaQuery(context, 'w', 30),
              ),
              child: SingleChildScrollView(
                child: Column(
                  children: <Widget>[
//                  โค๊ดเนื้อหาตรงนี้นะจ๊
                    _buildTextMenu(context, AppStrings.CustomerProp_groupCus),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      children: <Widget>[
//                      _buildTextField(context, customerGroup),
                        _buildDropDownGroup(context),
                      ],
                    ),

                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),

                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    _buildTextMenu(context, AppStrings.CustomerProp_HighValue),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      children: <Widget>[
//                      _buildTextField(context, highValue),
                        _buildDropDownHighValue(context),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    _buildTextMenu(
                        context, AppStrings.CustomerProp_AverageValue),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      children: <Widget>[
                        _buildRowNumber(context, averageValue),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    _buildTextMenu(
                        context, AppStrings.CustomerProp_KeyAccountStatus),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      children: <Widget>[
//                      _buildTextField(context, keyStatus),
                        _buildDropDownStatus(context),
                      ],
                    ),

                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    _buildTextMenu(
                        context, AppStrings.CustomerProp_BusinessPartner),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      children: <Widget>[
                        _buildTextField(context, businessPartner),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    // _buildTextMenu(
                    //     context, AppStrings.CustomerProp_TransformerSize),
                    // SizedBox(
                    //   height: mediaQuery(context, "h", 15),
                    // ),
                    // Row(
                    //   children: <Widget>[
                    //     _buildRowNumber(context, transformSize),
                    //   ],
                    // ),
                    // SizedBox(
                    //   height: mediaQuery(context, "h", 15),
                    // ),
                    _buildTextMenu(context, AppStrings.CustomerProp_Website),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      children: <Widget>[
                        _buildTextField(context, website),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    _buildTextMenu(context, AppStrings.CustomerProp_Location),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Container(
                      width: mediaQuery(context, "w", 1080),
                      alignment: Alignment.centerLeft,
                      child: Row(
                        children: [
                          SizedBox(
                            width: mediaQuery(context, "w", 500),
                            child: Column(
                              mainAxisAlignment: MainAxisAlignment.start,
                              children: [
                                Row(
                                  children: <Widget>[
                                    Text(
                                      AppStrings.CustomerProp_Latitude + " :",
                                      style: TextStyle(
                                          fontSize:
                                              mediaQuery(context, 'h', 40),
                                          color: AppColors.Black),
                                      textAlign: TextAlign.center,
                                    ),
                                  ],
                                ),
                                SizedBox(
                                  height: mediaQuery(context, "h", 15),
                                ),
                                Row(
                                  children: <Widget>[
                                    Container(
                                      height: mediaQuery(context, 'h', 105),
                                      width: mediaQuery(context, 'w', 490),
                                      child: Stack(
                                        children: <Widget>[
                                          TextField(
                                            enabled: true,
                                            keyboardType:
                                                TextInputType.numberWithOptions(
                                                    decimal: false),
                                            controller: latitude,
                                            decoration: new InputDecoration(
                                                border: new OutlineInputBorder(
                                                  borderRadius:
                                                      const BorderRadius.all(
                                                    const Radius.circular(50.0),
                                                  ),
                                                ),
                                                filled: true,
                                                counterText: "",
                                                contentPadding:
                                                    EdgeInsets.fromLTRB(
                                                        10.0, 0.0, 20.0, 10.0),
                                                hintStyle: new TextStyle(
                                                    color: Colors.grey[800]),
                                                fillColor: Colors.white70),
                                          ),
                                        ],
                                      ),
                                    ),
                                  ],
                                ),
                                Row(children: [
                                  Text(
                                    AppStrings.CustomerProp_Longitude + " :",
                                    style: TextStyle(
                                        fontSize: mediaQuery(context, 'h', 40),
                                        color: AppColors.Black),
                                    textAlign: TextAlign.center,
                                  ),
                                ]),
                                SizedBox(
                                  height: mediaQuery(context, "h", 15),
                                ),
                                Row(
                                  children: [
                                    Container(
                                      height: mediaQuery(context, 'h', 105),
                                      width: mediaQuery(context, 'w', 490),
                                      child: Stack(
                                        children: <Widget>[
                                          TextField(
                                            enabled: true,
                                            keyboardType:
                                                TextInputType.numberWithOptions(
                                                    decimal: true),
                                            controller: longitude,
                                            decoration: new InputDecoration(
                                                border: new OutlineInputBorder(
                                                  borderRadius:
                                                      const BorderRadius.all(
                                                    const Radius.circular(50.0),
                                                  ),
                                                ),
                                                filled: true,
                                                counterText: "",
                                                contentPadding:
                                                    EdgeInsets.fromLTRB(
                                                        10.0, 0.0, 20.0, 10.0),
                                                hintStyle: new TextStyle(
                                                    color: Colors.grey[800]),
                                                fillColor: Colors.white70),
                                          ),
                                        ],
                                      ),
                                    ),
                                  ],
                                ),
                                SizedBox(
                                  height: mediaQuery(context, "h", 15),
                                ),
                              ],
                            ),
                          ),
                          SizedBox(
                            width: mediaQuery(context, "w", 100),
                          ),
                          Stack(
                            children: <Widget>[
                              SizedBox(
                                width: mediaQuery(context, 'w', 200),
                                height: mediaQuery(context, 'h', 150),
                                child: RaisedButton(
                                  onPressed: () async {
                                    setState(() {
                                      isLoading = true;
                                    });
                                    Nav.push(
                                      context,
                                      MapNavigationShow(true, null, null),
                                    );
                                    setState(() {
                                      isLoading = false;
                                    });
                                  },
                                  shape: RoundedRectangleBorder(
                                    borderRadius: BorderRadius.circular(25),
                                  ),
                                  color: AppColors.PURPLE,
                                  padding: const EdgeInsets.only(
                                      top: 5, bottom: 5, left: 0),
                                  child: Row(
                                    mainAxisAlignment:
                                        MainAxisAlignment.spaceEvenly,
                                    children: [
                                      Image.asset(
                                        AppAssets.service_map_icon,
                                        fit: BoxFit.cover,
                                      ),

                                      // Container(
                                      //   width: mediaQuery(context, 'w', 100),
                                      //   height: mediaQuery(context, 'w', 100),
                                      //   decoration: BoxDecoration(
                                      //     borderRadius: BorderRadius.circular(17),
                                      //     color: Colors.white,
                                      //   ),
                                      //   child: Image.asset(
                                      //         AppAssets.service_map_icon,
                                      //         fit: BoxFit.cover,
                                      //       ),
                                      // ),
                                    ],
                                  ),
                                ),
                              ),

                              // GestureDetector(
                              //   onTap: () {
                              //     Nav.push(
                              //       context,
                              //       MapNavigationShow(true,null, null),
                              //     );
                              //   },
                              //   child: Container(
                              //     decoration: BoxDecoration(
                              //       borderRadius: BorderRadius.circular(
                              //         mediaQuery(context, 'w', 90),
                              //       ),
                              //     ),
                              //     height: mediaQuery(context, 'h', 150),
                              //     width: mediaQuery(context, 'w', 105),
                              //     child: Stack(
                              //       children: <Widget>[
                              //         GestureDetector(
                              //           onTap: () {
                              //             Nav.push(
                              //               context,
                              //               MapNavigationShow(true,null, null),
                              //             );
                              //           },
                              //           child: Center(
                              //             child: Image.asset(
                              //               AppAssets.service_map_icon,
                              //               fit: BoxFit.cover,
                              //             ),
                              //           ),
                              //         ),
                              //       ],
                              //     ),
                              //   ),
                              // )
                            ],
                          ),
                        ],
                      ),
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          AppStrings.CustomerProp_industrialArea,
                          style: TextStyle(
                              fontWeight: FontWeight.bold,
                              fontSize: mediaQuery(context, 'h', 40),
                              color: AppColors.color),
                          textAlign: TextAlign.center,
                        ),
                      ],
                    ),

                    _buildRadioIndustrialArea1(context, "ในเขตอุตสาหกรรม"),
                    Row(
                      children: <Widget>[
                        _buildTextField(context, inIndustry),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    _buildRadioIndustrialArea2(context, "นอกเขตอุตสาหกรรม"),
                    _buildRadioIndustrialArea3(context, "ไม่ระบุ"),
                    /*Row(
                      children: <Widget>[
                        _buildTextField(context, inIndustry),
                      ],
                    ),*/
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),

                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          AppStrings.CustomerProp_RuralArea,
                          style: TextStyle(
                              fontWeight: FontWeight.bold,
                              fontSize: mediaQuery(context, 'h', 40),
                              color: AppColors.color),
                          textAlign: TextAlign.center,
                        ),
                      ],
                    ),

                    _buildRadioRuralArea1(context, "เขตเมือง"),
                    _buildRadioRuralArea2(
                        context, AppStrings.CustomerProp_RuralArea_),
                    _buildRadioRuralArea3(context, "ไม่ระบุ"),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          AppStrings.CustomerProp_MainGroupFeatures,
                          style: TextStyle(
                              fontWeight: FontWeight.bold,
                              fontSize: mediaQuery(context, 'h', 40),
                              color: AppColors.color),
                          textAlign: TextAlign.center,
                        ),
                      ],
                    ),
                    _buildRow1(context, AppStrings.CustomerProp_PressureLevel),
                    _buildRow2(
                        context, AppStrings.CustomerProp_AverageElectPerMonth),
                    _buildRow3(
                        context, AppStrings.CustomerProp_RiskGroupLosingIncome),
                    _buildRow4(context, AppStrings.CustomerProp_Supplementary),
                    _buildRow5(context, AppStrings.CustomerProp_HavePotential),
                    _buildRow6(context, AppStrings.CustomerProp_nationwide),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          AppStrings.CustomerProp_SecondaryGroupFeature,
                          style: TextStyle(
                              fontWeight: FontWeight.bold,
                              fontSize: mediaQuery(context, 'h', 40),
                              color: AppColors.color),
                          textAlign: TextAlign.center,
                        ),
                      ],
                    ),
                    _buildRow8(context, AppStrings.CustomerProp_ResponseGroup),
                    _buildRow9(
                        context, AppStrings.CustomerProp_CustomersHighDamage),
                    _buildRow10(
                        context, AppStrings.CustomerProp_ExistingCustomers),
                    SizedBox(
                      height: mediaQuery(context, "h", 35),
                    ),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                      children: <Widget>[
                        _buildButton(context, "ล้างข้อมูล", Colors.white,
                            AppColors.color),
                        _buildButton(
                            context, "บันทึก", AppColors.color, Colors.white),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 100),
                    ),
//                  end
                  ],
                ),
              ),
            ),
//          _buildDropDownGroup(context,customerGroup)
          ],
        ),
      ),
    );
  }

  _buildDropDownHighValue(context) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        Container(
          height: mediaQuery(context, 'h', 110),
          width: mediaQuery(context, 'w', 1005),
          padding: EdgeInsets.symmetric(horizontal: 10.0),
          decoration: BoxDecoration(
            color: Colors.white,
            borderRadius: BorderRadius.circular(53.0),
            border: Border.all(
                color: AppColors.color_border,
                style: BorderStyle.solid,
                width: 0.80),
          ),
          child: DropdownButtonHideUnderline(
            child: new DropdownButton<String>(
              iconSize: 30,
              icon: Icon(Icons.keyboard_arrow_down),
              underline: SizedBox(),
              items: _dropdownHighValue
                  .map(
                    (data) => DropdownMenuItem<String>(
                      child: Container(
                        child: Text(
                          data.key,
                          style: TextStyle(
                            fontSize: mediaQuery(context, "h", 60),
                          ),
                          textScaleFactor: 0.7,
                        ),
                      ),
                      value: data.value,
                    ),
                  )
                  .toList(),
              isExpanded: true,
              onChanged: (String value) {
                setState(() {
                  SelectedHighValue = value;
                  for (int i = 0; i < _dropdownHighValue.length; i++)
                    if (_dropdownHighValue[i].value == SelectedHighValue)
                      hintSelectedHighValue =
                          _dropdownHighValue[i].key.toString();
                });
              },
              hint: Text(
                hintSelectedHighValue.toString(),
                style: TextStyle(
                  fontSize: mediaQuery(context, "h", 60),
                  color: AppColors.Black,
                ),
                textScaleFactor: 0.7,
              ),
            ),
          ),
        ),
      ],
    );
  }

  _buildDropDownGroup(context) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        Container(
          height: mediaQuery(context, 'h', 110),
          width: mediaQuery(context, 'w', 1005),
          padding: EdgeInsets.symmetric(horizontal: 10.0),
          decoration: BoxDecoration(
            color: Colors.white,
            borderRadius: BorderRadius.circular(53.0),
            border: Border.all(
                color: AppColors.color_border,
                style: BorderStyle.solid,
                width: 0.80),
          ),
          child: DropdownButtonHideUnderline(
            child: new DropdownButton<String>(
              iconSize: 30,
              icon: Icon(Icons.keyboard_arrow_down),
              underline: SizedBox(),
              items: _dropdownGroup
                  .map(
                    (data) => DropdownMenuItem<String>(
                      child: Container(
                        child: Text(
                          data.key,
                          style: TextStyle(
                            fontSize: mediaQuery(context, "h", 60),
                          ),
                          textScaleFactor: 0.7,
                        ),
                      ),
                      value: data.value,
                    ),
                  )
                  .toList(),
              isExpanded: true,
              onChanged: (String value) {
                setState(() {
                  SelectedGroup = value;
                  for (int i = 0; i < _dropdownGroup.length; i++)
                    if (_dropdownGroup[i].value == SelectedGroup)
                      hintSelectedGroup = _dropdownGroup[i].key.toString();
                });
              },
//                            value: SelectedGroup,
              hint: Text(
                hintSelectedGroup.toString(),
                style: TextStyle(
                  fontSize: mediaQuery(context, "h", 60),
                  color: AppColors.Black,
                ),
                textScaleFactor: 0.7,
              ),
            ),
          ),
        ),
      ],
    );
  }

  _buildDropDownStatus(context) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        Container(
          height: mediaQuery(context, 'h', 110),
          width: mediaQuery(context, 'w', 1005),
          padding: EdgeInsets.symmetric(horizontal: 10.0),
          decoration: BoxDecoration(
            color: Colors.white,
            borderRadius: BorderRadius.circular(53.0),
            border: Border.all(
                color: AppColors.color_border,
                style: BorderStyle.solid,
                width: 0.80),
          ),
          child: DropdownButtonHideUnderline(
            child: new DropdownButton<String>(
              iconSize: 30,
              icon: Icon(Icons.keyboard_arrow_down),
              underline: SizedBox(),
              items: _dropdownStatus
                  .map(
                    (data) => DropdownMenuItem<String>(
                      child: Container(
                        child: Text(
                          data.key,
                          style: TextStyle(
                            fontSize: mediaQuery(context, "h", 60),
                          ),
                          textScaleFactor: 0.7,
                        ),
                      ),
                      value: data.value,
                    ),
                  )
                  .toList(),
              isExpanded: true,
              onChanged: (String value) {
                setState(() {
                  SelectedStatus = value;
                  for (int i = 0; i < _dropdownStatus.length; i++)
                    if (_dropdownStatus[i].value == SelectedStatus)
                      hintSelectedStatus = _dropdownStatus[i].key.toString();
                });
              },
//                            value: SelectedGroup,
              hint: Text(
                hintSelectedStatus.toString(),
                style: TextStyle(
                  fontSize: mediaQuery(context, "h", 60),
                  color: AppColors.Black,
                ),
                textScaleFactor: 0.7,
              ),
            ),
          ),
        ),
      ],
    );
  }

  _buildRowNumber(context, TextEditingController controller) {
    return Container(
      height: mediaQuery(context, 'h', 110),
      width: mediaQuery(context, 'w', 1005),
      child: new TextField(
        keyboardType: TextInputType.numberWithOptions(decimal: true),
        controller: controller,
        enabled: true,
        decoration: new InputDecoration(
            border: new OutlineInputBorder(
              borderRadius: const BorderRadius.all(
                const Radius.circular(50.0),
              ),
            ),
            filled: true,
            counterText: "",
            contentPadding: EdgeInsets.fromLTRB(10.0, 0.0, 20.0, 10.0),
            hintStyle: new TextStyle(color: Colors.grey[800]),
            fillColor: Colors.white70),
      ),
    );
  }

  _buildTextField(context, controller) {
    return Container(
      height: mediaQuery(context, 'h', 110),
      width: mediaQuery(context, 'w', 1005),
      child: new TextField(
        textAlign: TextAlign.left,
        style: TextStyle(
          fontSize: mediaQuery(context, "h", 40),
        ),
        enabled: true,
        controller: controller,
        decoration: new InputDecoration(
          border: new OutlineInputBorder(
            borderRadius: const BorderRadius.all(
              const Radius.circular(50.0),
            ),
          ),
          filled: true,
          counterText: "",
          contentPadding: EdgeInsets.fromLTRB(10.0, 0.0, 20.0, 10.0),
          hintStyle: new TextStyle(color: Colors.grey[800]),
          fillColor: Colors.white70,
        ),
      ),
    );
  }

  _buildRow1(context, text) {
    return Row(
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Checkbox(
            value: monVal,
            onChanged: (bool value) {
              setState(() {
                monVal = value;
                if (monVal == true) {
                  customerInfo1 = "1";
                  mainGroup.add(customerInfo1);
                } else {
                  customerInfo1 = '';
                  mainGroup.remove("1");
                }
                print(mainGroup);
              });
            },
          ),
        ),
        Text(
          text,
          style: TextStyle(
              fontWeight: FontWeight.bold,
              fontSize: mediaQuery(context, 'h', AppFontSize.label),
              color: AppColors.Black),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRow2(context, text) {
    return Row(
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Checkbox(
            value: monVal2,
            onChanged: (bool value) {
              print(value);
              setState(() {
                monVal2 = value;
                if (monVal2 == true) {
                  customerInfo1 = "2";
                  mainGroup.add(customerInfo1);
                } else {
                  customerInfo1 = '';
                  mainGroup.remove("2");
                }
                print(mainGroup);
              });
              print(monVal2);
            },
          ),
        ),
        Text(
          text,
          style: TextStyle(
              fontWeight: FontWeight.bold,
              fontSize: mediaQuery(context, 'h', AppFontSize.label),
              color: AppColors.Black),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRow3(context, text) {
    return Row(
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Checkbox(
            value: monVal3,
            onChanged: (bool value) {
              setState(() {
                monVal3 = value;
                if (monVal3 == true) {
                  customerInfo1 = "4";
                  mainGroup.add(customerInfo1);
                } else {
                  customerInfo1 = '';
                  mainGroup.remove("4");
                }
                print(mainGroup);
              });
            },
          ),
        ),
        Text(
          text,
          style: TextStyle(
              fontWeight: FontWeight.bold,
              fontSize: mediaQuery(context, 'h', AppFontSize.label),
              color: AppColors.Black),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRow4(context, text) {
    return Row(
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Checkbox(
            value: monVal4,
            onChanged: (bool value) {
              setState(() {
                monVal4 = value;
                if (monVal4 == true) {
                  customerInfo1 = "5";
                  mainGroup.add(customerInfo1);
                } else {
                  customerInfo1 = '';
                  mainGroup.remove("5");
                }
                print(mainGroup);
              });
            },
          ),
        ),
        Text(
          text,
          style: TextStyle(
              fontWeight: FontWeight.bold,
              fontSize: mediaQuery(context, 'h', AppFontSize.label),
              color: AppColors.Black),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRow5(context, text) {
    return Row(
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Checkbox(
            value: monVal5,
            onChanged: (bool value) {
              setState(() {
                monVal5 = value;
                if (monVal5 == true) {
                  customerInfo1 = "6";
                  mainGroup.add(customerInfo1);
                } else {
                  customerInfo1 = '';
                  mainGroup.remove("6");
                }
                print(mainGroup);
              });
            },
          ),
        ),
        Text(
          text,
          style: TextStyle(
              fontWeight: FontWeight.bold,
              fontSize: mediaQuery(context, 'h', AppFontSize.label),
              color: AppColors.Black),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRow6(context, text) {
    return Row(
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Checkbox(
            value: monVal6,
            onChanged: (bool value) {
              setState(() {
                monVal6 = value;
                if (monVal6 == true) {
                  customerInfo1 = "7";
                  mainGroup.add(customerInfo1);
                } else {
                  customerInfo1 = '';
                  mainGroup.remove("7");
                }
                print(mainGroup);
              });
            },
          ),
        ),
        Text(
          text,
          style: TextStyle(
              fontWeight: FontWeight.bold,
              fontSize: mediaQuery(context, 'h', AppFontSize.label),
              color: AppColors.Black),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRow8(context, text) {
    return Row(
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Checkbox(
            value: monVal8,
            onChanged: (bool value) {
              setState(() {
                monVal8 = value;
                if (monVal8 == true) {
                  customerInfo2 = "1";
                  minorGroup.add(customerInfo2);
                } else {
                  customerInfo2 = '';
                  minorGroup.remove("1");
                }
                print(minorGroup);
              });
            },
          ),
        ),
        Text(
          text,
          style: TextStyle(
              fontWeight: FontWeight.bold,
              fontSize: mediaQuery(context, 'h', AppFontSize.label),
              color: AppColors.Black),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRow9(context, text) {
    return Row(
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Checkbox(
            value: monVal9,
            onChanged: (bool value) {
              setState(() {
                monVal9 = value;
                if (monVal9 == true) {
                  customerInfo2 = "2";
                  minorGroup.add(customerInfo2);
                } else {
                  customerInfo2 = '';
                  minorGroup.remove("2");
                }
                print(minorGroup);
              });
            },
          ),
        ),
        Text(
          text,
          style: TextStyle(
              fontWeight: FontWeight.bold,
              fontSize: mediaQuery(context, 'h', AppFontSize.label),
              color: AppColors.Black),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRow10(context, text) {
    return Row(
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Checkbox(
            value: monVal10,
            onChanged: (bool value) {
              setState(() {
                monVal10 = value;
                if (monVal10 == true) {
                  customerInfo2 = "3";
                  minorGroup.add(customerInfo2);
                } else {
                  customerInfo2 = '';
                  minorGroup.remove("3");
                }
                print(minorGroup);
              });
            },
          ),
        ),
        Text(
          text,
          style: TextStyle(
              fontWeight: FontWeight.bold,
              fontSize: mediaQuery(context, 'h', AppFontSize.label),
              color: AppColors.Black),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  void _handleRadioValueChange(int value) {
    setState(() {
      radioRuralArea = value;
      if (radioRuralArea == 1) {
        ruralArea = 'เขตเมือง';
        bIsCountryside = false;
      }
      if (radioRuralArea == 2) {
        ruralArea = 'เขตชนบท';
        bIsCountryside = true;
      }
      if (radioRuralArea == 3) {
        ruralArea = 'ไม่ระบุ';
        bIsCountryside = false;
      }
    });
  }

  void _handleRadioValueChangeIndustrialArea(int value) {
    setState(() {
      radioIndustrialArea = value;

      if (radioIndustrialArea == 1) {
        setState(() {
          industrialArea = "ในเขตอุตสาหกรรม";
          bIndustrialArea = true;
        });
      }
      if (radioIndustrialArea == 2) {
        setState(() {
          industrialArea = "นอกเขตอุตสาหกรรม";
          bIndustrialArea = false;
        });
      }

      if (radioIndustrialArea == 3) {
        setState(() {
          industrialArea = "ไม่ระบุ";
          bIndustrialArea = false;
        });
      }
    });
  }

  _buildRadioIndustrialArea1(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Radio(
            value: 1,
            groupValue: radioIndustrialArea,
            onChanged: _handleRadioValueChangeIndustrialArea,
          ),
        ),
        Text(
          text,
          style: TextStyle(
              fontSize: mediaQuery(context, 'h', AppFontSize.label),
              color: AppColors.Black),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRadioIndustrialArea2(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Radio(
            value: 2,
            groupValue: radioIndustrialArea,
            onChanged: _handleRadioValueChangeIndustrialArea,
          ),
        ),
        Text(
          text,
          style: TextStyle(
              fontSize: mediaQuery(context, 'h', AppFontSize.label),
              color: AppColors.Black),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _handleTap(LatLng tappedPoint) {
    print(tappedPoint);
    setState(() {
      myMarker = [];
      myMarker.add(Marker(
        markerId: MarkerId(tappedPoint.toString()),
        position: tappedPoint,
      ));

      latitude.text = tappedPoint.latitude.toStringAsFixed(4);
      longitude.text = tappedPoint.longitude.toStringAsFixed(4);
    });
  }

  _buildRadioIndustrialArea3(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Radio(
            value: 3,
            groupValue: radioIndustrialArea,
            onChanged: _handleRadioValueChangeIndustrialArea,
          ),
        ),
        Text(
          text,
          style: TextStyle(
              fontSize: mediaQuery(context, 'h', AppFontSize.label),
              color: AppColors.Black),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRadioRuralArea1(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Radio(
            value: 1,
            groupValue: radioRuralArea,
            onChanged: _handleRadioValueChange,
          ),
        ),
        Text(
          text,
          style: TextStyle(
              fontSize: mediaQuery(context, 'h', AppFontSize.label),
              color: AppColors.Black),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRadioRuralArea2(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Radio(
            value: 2,
            groupValue: radioRuralArea,
            onChanged: _handleRadioValueChange,
          ),
        ),
        Text(
          text,
          style: TextStyle(
              fontSize: mediaQuery(context, 'h', AppFontSize.label),
              color: AppColors.Black),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRadioRuralArea3(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Radio(
            value: 3,
            groupValue: radioRuralArea,
            onChanged: _handleRadioValueChange,
          ),
        ),
        Text(
          text,
          style: TextStyle(
              fontSize: mediaQuery(context, 'h', AppFontSize.label),
              color: AppColors.Black),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildTextMenu(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        Text(
          text + " :",
          style: TextStyle(
              fontSize: mediaQuery(context, 'h', AppFontSize.label),
              color: AppColors.color),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildButton(context, text, bgColor, fontColor) {
    return ButtonTheme(
      minWidth: mediaQuery(context, "w", 477),
      height: mediaQuery(context, "h", 120),
      child: FlatButton(
        shape: new RoundedRectangleBorder(
            borderRadius: new BorderRadius.circular(
              mediaQuery(context, "w", 50),
            ),
            side: BorderSide(color: AppColors.color)),
        color: bgColor,
        textColor: Colors.red,
        padding: EdgeInsets.all(
          mediaQuery(context, "w", 10),
        ),
        onPressed: () {
          if (text == "บันทึก") {
            saveCustomerPropertyEdit(context);
          } else if (text == "ล้างข้อมูล") {
            Navigator.of(context).pop(false);
          }
          print(text);
        },
        child: Text(
          text,
          style: TextStyle(
            fontSize: mediaQuery(context, "h", AppFontSize.label),
            color: fontColor,
          ),
        ),
      ),
    );
  }

//  ฟังชั่นบันทึก
  saveCustomerPropertyEdit(context) async {
    List<dynamic> checkNull = [
      customerGroup.text,
      highValue.text,
      averageValue.text,
      keyStatus.text,
      businessPartner.text,
      transformSize.text,
//      website.text,
//      latitude.text,
//      longitude.text,
//      inIndustry.text
    ];
    setState(() {
      isLoading = true;
    });
    Map<String, dynamic> data = {
      "customerId": CustomerInfo.data[0].customerId.toString(),
      "BusinessPartner": businessPartner.text.toString(),
      "CA": CustomerInfo.data[0].ca.toString(),
      // "CustomerName": CustomerInfo.data[0].customerName.toString(),
      // "CustomerAddress": CustomerInfo.data[0].customerAddress.toString(),
      "TsicCode": CustomerInfo.data[0].tsicCode.toString(),
      "TsicName": CustomerInfo.data[0].tsicName.toString(),
      "RegionCode": CustomerInfo.data[0].regionCode.toString(),
      "RegionText": CustomerInfo.data[0].regionText.toString(),
      "website": website.text.toString(),
      "latitude": latitude.text.toString(),
      "longitude": longitude.text.toString(),
      "haveVoltageKv": monVal,
      "haveHighElectricityBill": monVal2,
      "haveRiskLoseToSpp": monVal3,
      "haveRiskLoseToOwnElectric": monValOwn,
      "havePotentialMoreBusiness": monVal4,
      "havePotentialStrategicEconomy": monVal5,
      "haveConnection": monVal6,
      "haveGoodImageToOrganization": monVal8,
      "haveLoseMoneyFromElectricProblem": monVal9,
      "isOldKam": monVal10,
      "highValueSize": SelectedHighValue.toString(),
      "highValueAmount": averageValue.text.toString(),
      "kamType": SelectedStatus.toString(),
      "customerClassification": SelectedGroup.toString(),
      "isIndustrialArea": bIndustrialArea,
      "isCountryside": bIsCountryside,
      "industryZone": inIndustry.text.toString(),
      "authenKey": AppUrl.AuthenKey.toString(),
    };
    print(data);
    await new Future.delayed(const Duration(milliseconds: 2000));
    await CustomerInfo.saveData(context, data);
    setState(() {
      isLoading = false;
    });
  }
} //class

class KeyValueModel {
  String key;
  String value;

  KeyValueModel({this.key, this.value});
}

class CustomGroupList {
  String CustomerClassificationId;
  String CustomerClassificationName;
  String CustomerClassificationInfoList;

  CustomGroupList({
    this.CustomerClassificationId,
    this.CustomerClassificationName,
    this.CustomerClassificationInfoList,
  });
}

class StatusAccountList {
  String KamTypeId;
  String KamTypeName;

  StatusAccountList({
    this.KamTypeId,
    this.KamTypeName,
  });
}

class HighValuetList {
  String HighValueId;
  String HighValue;

  HighValuetList({
    this.HighValueId,
    this.HighValue,
  });
}
