import 'package:flutter/material.dart';
import 'package:get/get.dart';

import 'package:mwf_app/service/assets.dart';
import 'package:mwf_app/service/fontsize.dart';
import 'package:mwf_app/service/navigator.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/strings.dart';
import 'package:mwf_app/set1/schedule.dart';
import 'package:mwf_app/set2/notification.dart';
import 'package:mwf_app/set7/chat_home.dart';
import 'package:mwf_app/home.dart';

class BottomMenu extends StatefulWidget {
  final String activePage;

  const BottomMenu({
    Key key,
    this.activePage,
  }) : super(key: key);

  @override
  _BottomMenuState createState() => _BottomMenuState();
}

class _BottomMenuState extends State<BottomMenu> {
  @override
  Widget build(BuildContext context) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.spaceEvenly,
      crossAxisAlignment: CrossAxisAlignment.center,
      children: <Widget>[
        homeIcon(),
        alertIcon(),
        chatIcon(),
        scheduleIcon(),
      ],
    );
  }

  homeIcon() {
    if (widget.activePage == 'home') {
      return GestureDetector(
        onTap: () {},
        child: Container(
          width: mediaQuery(context, 'w', 200),
          height: mediaQuery(context, 'h', 200),
          decoration: BoxDecoration(
            borderRadius: BorderRadius.only(
              bottomLeft: Radius.circular(
                mediaQuery(context, 'h', 20),
              ),
              bottomRight: Radius.circular(
                mediaQuery(context, 'h', 20),
              ),
            ),
            color: Colors.white,
          ),
          child: Container(
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 35),
            ),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                Image.asset(
                  AppAssets.bottomMenu_home_purple,
                  width: mediaQuery(context, 'w', 65),
                  height: mediaQuery(context, 'h', 50),
                ),
                SizedBox(
                  height: mediaQuery(context, 'h', 15),
                ),
                Text(
                  AppStrings.menu_home,
                  style: TextStyle(
                    fontSize: mediaQuery(context, 'h', AppFontSize.menu),
                    color: Color(0xFF7F3F98),
                  ),
                )
              ],
            ),
          ),
        ),
      );
    } else {
      return GestureDetector(
        onTap: () {
          Nav.push(
            context,
            HomePage(),
          );
        },
        child: Container(
          color: Colors.transparent,
          width: mediaQuery(context, 'w', 200),
          height: mediaQuery(context, 'h', 200),
          child: Container(
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 35),
            ),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                Image.asset(
                  AppAssets.bottomMenu_home_white,
                  width: mediaQuery(context, 'w', 65),
                  height: mediaQuery(context, 'h', 50),
                ),
                SizedBox(
                  height: mediaQuery(context, 'h', 15),
                ),
                Text(
                  AppStrings.menu_home,
                  style: TextStyle(
                    fontSize: mediaQuery(context, 'h', AppFontSize.menu),
                    color: Colors.white,
                  ),
                )
              ],
            ),
          ),
        ),
      );
    }
  }

  alertIcon() {
    if (widget.activePage == 'alert') {
      return GestureDetector(
        onTap: () {},
        child: Container(
          width: mediaQuery(context, 'w', 230),
          height: mediaQuery(context, 'h', 200),
          decoration: BoxDecoration(
            borderRadius: BorderRadius.only(
              bottomLeft: Radius.circular(
                mediaQuery(context, 'h', 20),
              ),
              bottomRight: Radius.circular(
                mediaQuery(context, 'h', 20),
              ),
            ),
            color: Colors.white,
          ),
          child: Container(
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 35),
            ),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                Image.asset(
                  AppAssets.bottomMenu_alert_purple,
                  width: mediaQuery(context, 'w', 65),
                  height: mediaQuery(context, 'h', 50),
                ),
                SizedBox(
                  height: mediaQuery(context, 'h', 15),
                ),
                Text(
                  AppStrings.menu_alert,
                  style: TextStyle(
                    fontSize: mediaQuery(context, 'h', AppFontSize.menu),
                    color: Color(0xFF7F3F98),
                  ),
                )
              ],
            ),
          ),
        ),
      );
    } else {
      return GestureDetector(
        onTap: () {
          Get.offAll(NotificationPage());
          // Nav.push(
          //   context,
          //   NotificationPage(),
          // );
        },
        child: Container(
          color: Colors.transparent,
          width: mediaQuery(context, 'w', 230),
          height: mediaQuery(context, 'h', 200),
          child: Container(
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 35),
            ),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                Image.asset(
                  AppAssets.bottomMenu_alert_white,
                  width: mediaQuery(context, 'w', 65),
                  height: mediaQuery(context, 'h', 50),
                ),
                SizedBox(
                  height: mediaQuery(context, 'h', 15),
                ),
                Text(
                  AppStrings.menu_alert,
                  style: TextStyle(
                    fontSize: mediaQuery(context, 'h', AppFontSize.menu),
                    color: Colors.white,
                  ),
                )
              ],
            ),
          ),
        ),
      );
    }
  }

  chatIcon() {
    if (widget.activePage == 'chat') {
      return GestureDetector(
        onTap: () {},
        child: Container(
          width: mediaQuery(context, 'w', 200),
          height: mediaQuery(context, 'h', 200),
          decoration: BoxDecoration(
            borderRadius: BorderRadius.only(
              bottomLeft: Radius.circular(
                mediaQuery(context, 'h', 20),
              ),
              bottomRight: Radius.circular(
                mediaQuery(context, 'h', 20),
              ),
            ),
            color: Colors.white,
          ),
          child: Container(
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 40),
            ),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                Image.asset(
                  AppAssets.bottomMenu_chat_purple,
                  width: mediaQuery(context, 'w', 65),
                  height: mediaQuery(context, 'h', 50),
                ),
                SizedBox(
                  height: mediaQuery(context, 'h', 15),
                ),
                Text(
                  AppStrings.menu_chat,
                  style: TextStyle(
                    fontSize: mediaQuery(context, 'h', AppFontSize.menu),
                    color: Color(0xFF7F3F98),
                  ),
                )
              ],
            ),
          ),
        ),
      );
    } else {
      return GestureDetector(
        onTap: () {
          Nav.push(
            context,
            Chathome(),
          );
        },
        child: Container(
          color: Colors.transparent,
          width: mediaQuery(context, 'w', 200),
          height: mediaQuery(context, 'h', 200),
          child: Container(
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 40),
            ),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                Image.asset(
                  AppAssets.bottomMenu_chat_white,
                  width: mediaQuery(context, 'w', 65),
                  height: mediaQuery(context, 'h', 50),
                ),
                SizedBox(
                  height: mediaQuery(context, 'h', 15),
                ),
                Text(
                  AppStrings.menu_chat,
                  style: TextStyle(
                    fontSize: mediaQuery(context, 'h', AppFontSize.menu),
                    color: Colors.white,
                  ),
                )
              ],
            ),
          ),
        ),
      );
    }
  }

  scheduleIcon() {
    if (widget.activePage == 'schedule') {
      return GestureDetector(
        onTap: () {},
        child: Container(
          width: mediaQuery(context, 'w', 200),
          height: mediaQuery(context, 'h', 200),
          padding: EdgeInsets.only(
            top: mediaQuery(context, 'h', 40),
          ),
          decoration: BoxDecoration(
            borderRadius: BorderRadius.only(
              bottomLeft: Radius.circular(
                mediaQuery(context, 'h', 20),
              ),
              bottomRight: Radius.circular(
                mediaQuery(context, 'h', 20),
              ),
            ),
            color: Colors.white,
          ),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Image.asset(
                AppAssets.bottomMenu_calendar_purple,
                width: mediaQuery(context, 'w', 65),
                height: mediaQuery(context, 'h', 50),
              ),
              SizedBox(
                height: mediaQuery(context, 'h', 15),
              ),
              Text(
                AppStrings.menu_schedule,
                style: TextStyle(
                  fontSize: mediaQuery(context, 'h', AppFontSize.menu),
                  color: Color(0xFF7F3F98),
                ),
              )
            ],
          ),
        ),
      );
    } else {
      return GestureDetector(
        onTap: () {
          Nav.push(
            context,
            Schedule(),
          );
        },
        child: Container(
          color: Colors.transparent,
          width: mediaQuery(context, 'w', 200),
          height: mediaQuery(context, 'h', 200),
          padding: EdgeInsets.only(
            top: mediaQuery(context, 'h', 40),
          ),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Image.asset(
                AppAssets.bottomMenu_calendar_white,
                width: mediaQuery(context, 'w', 65),
                height: mediaQuery(context, 'h', 50),
              ),
              SizedBox(
                height: mediaQuery(context, 'h', 15),
              ),
              Text(
                AppStrings.menu_schedule,
                style: TextStyle(
                  fontSize: mediaQuery(context, 'h', AppFontSize.menu),
                  color: Colors.white,
                ),
              )
            ],
          ),
        ),
      );
    }
  }
}
