import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class VoiceType {
  String voiceTypeId;
  String voiceTypeName;

  VoiceType({
    this.voiceTypeId,
    this.voiceTypeName,
  });

  static getData() async {
    final response = await AppApi.apiGetRequest(
      AppUrl.VoiceType_ReadList +
          "?VoiceTypeId=" +
          AppUrl.VoiceTypeId +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.VoiceType_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String voiceTypeId,
  ) async {
    Map<String, dynamic> data = {
      "VoiceTypeId": voiceTypeId,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.VoiceType_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String voiceTypeId,
    String voiceTypeName,
  ) async {
    Map<String, dynamic> data = {
      "VoiceTypeId": voiceTypeId,
      "VoiceTypeName": voiceTypeName,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.VoiceType_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<VoiceType> data = []; // ตัวแปรที่จะเรียกใช้งาน

  VoiceType.fromJson(Map<String, dynamic> json) {
    voiceTypeId = json['VoiceTypeId'];
    voiceTypeName = json['VoiceTypeName'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['VoiceTypeId'] = this.voiceTypeId;
    data['VoiceTypeName'] = this.voiceTypeName;
    return data;
  }
}
