import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/strings.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/set6/service_report_user.dart';

class Voice {
  String complaintTag;
  String complainerID;
  String complainerNo;
  String complaintNo;
  int tagId;
  String tagName;
  String complainerName;
  String complaintStatus;
  String citizenNumber;
  String telephoneNumber;
  String email;
  int customerTypeId;
  String provinceId;
  String provinceName;
  String peaCode;
  String peaName;
  String accidentLocation;
  String caNumber;
  int complaintTypeId;
  String complaintTypeName;
  int complaintSubTypeId;
  String complaintSubtypeName;
  String voiceType;
  String contactAddress;
  String detail;
  String isSms;
  String fileContent;
  String fileName;
  String mimeType;
  String description;
  String vocCreateVocResult;
  String voiceStatus;
  String date;
  List<AttachmentFileList> files;

  Voice({
    this.complaintTag,
    this.complainerID,
    this.complainerNo,
    this.complaintNo,
    this.tagId,
    this.tagName,
    this.complainerName,
    this.complaintStatus,
    this.citizenNumber,
    this.telephoneNumber,
    this.email,
    this.customerTypeId,
    this.provinceId,
    this.provinceName,
    this.peaCode,
    this.peaName,
    this.accidentLocation,
    this.caNumber,
    this.complaintTypeId,
    this.complaintTypeName,
    this.complaintSubTypeId,
    this.complaintSubtypeName,
    this.voiceType,
    this.contactAddress,
    this.detail,
    this.isSms,
    this.fileContent,
    this.fileName,
    this.mimeType,
    this.description,
    this.vocCreateVocResult,
    this.voiceStatus,
    this.date,
    this.files,
  });

  String complainerIView;
  static getVoiceType() async {
    print(AppUrl.Voc_ListTagId + "?AuthenKey=" + AppUrl.AuthenKey);
    final response = await AppApi.apiGetRequest(
      AppUrl.Voc_ListTagId + "?AuthenKey=" + AppUrl.AuthenKey,
    ); // เรียกใช้ api
    return response;
  }

  static getVoiceProvine() async {
    final response = await AppApi.apiGetRequest(
      AppUrl.Voc_Provinelist + "?AuthenKey=" + AppUrl.AuthenKey,
    ); // เรียกใช้ api

    return response;
  }

  static getVoiceElectricity() async {
    final response = await AppApi.apiGetRequest(
      AppUrl.Voice_Electricity_ReadList + "?AuthenKey=" + AppUrl.AuthenKey,
    ); // เรียกใช้ api

    return response;
  }

  static getVoicePealist(provinceId) async {
    final response = await AppApi.apiGetRequest(
      AppUrl.Voice_Pealist + // เรียกใช้ api
          "?provinceId=" +
          provinceId +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    );
    return response;
  }

  static getVoiceSuggestion() async {
    final response = await AppApi.apiGetRequest(
      AppUrl.Voice_Suggestion_ReadList + "?AuthenKey=" + AppUrl.AuthenKey,
    ); // เรียกใช้ api

    return response;
  }

  static getVoiceComplaintSubTypeList(complaintTypeId) async {
    final response = await AppApi.apiGetRequest(
      AppUrl.Voc_ComplaintSubTypeList +
          "?complaintTypeId=" +
          complaintTypeId +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api

    return response;
  }

  static getVoiceComplaintType(tagId) async {
    final response = await AppApi.apiGetRequest(
      AppUrl.Voc_ComplaintTypeList +
          "?tagId=" +
          tagId +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api

    return response;
  }

  static getVoiceView(complainerId) async {
    print(
      AppUrl.Voice_View +
          "?complaintId=" +
          complainerId +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    );
    final response = await AppApi.apiGetRequest(
      AppUrl.Voice_View +
          "?complaintId=" +
          complainerId +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api
    return response;
  }

  static getVoiceViewAttachment(attachmentId) async {
    final response = await AppApi.apiGetRequest(
      AppUrl.Voice_View +
          "?attachmentId=" +
          attachmentId +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    );

    return response;
  }

  static getData() async {
    print(
      AppUrl.Voice_ReadList +
          "?ca=" +
          AppStrings.serviceElectricityUserNumberName +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    );
    final response = await AppApi.apiGetRequest(
      AppUrl.Voice_ReadList +
          "?ca=" +
          AppStrings.serviceElectricityUserNumberName +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    print(AppUrl.Voc_CreateVoc);

    final response =
        await AppApi.post(AppUrl.Voc_CreateVoc, data); // เรียกใช้ api
    print(response.hashCode);
    if (response.toString().isNotEmpty) {
      AppLoader.showSuccess('เพิ่มข้อมูลสำเร็จ');
      await new Future.delayed(const Duration(milliseconds: 2000));
      Navigator.pushReplacement(
        context,
        MaterialPageRoute(
          builder: (context) => ServiceReportUser(),
        ),
      );
    } else {
      AppLoader.showError('เพิ่มข้อมูลไม่สำเร็จ');
    }
  }

  static deleteData(
    context,
    String voiceID,
  ) async {
    Map<String, dynamic> data = {
      "VoiceID": voiceID,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.Voice_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String voiceID,
    String authenKey,
    String tagId,
    String complainerName,
    String citizenNumber,
    String telephoneNumber,
    String email,
    String customerTypeId,
    String provinceId,
    String peaCode,
    String peaName,
    String accidentLocation,
    String caNumber,
    String complaintTypeId,
    String voiceType,
    String contactAddress,
    String detail,
    String isSms,
    String fileContent,
    String fileName,
    String mimeType,
    String description,
    String vocCreateVocResult,
    String voiceStatus,
  ) async {
    Map<String, dynamic> data = {
      "VoiceID": voiceID,
      "tagId": tagId,
      "complainerName": complainerName,
      "citizenNumber": citizenNumber,
      "telephoneNumber": telephoneNumber,
      "email": email,
      "customerTypeId": customerTypeId,
      "provinceId": provinceId,
      "peaCode": peaCode,
      "peaName": peaName,
      "Location": accidentLocation,
      "caNumber": caNumber,
      "voiceType": voiceType,
      "complaintTypeId": complaintTypeId,
      "detail": detail,
      "contactAddress": contactAddress,
      "VoiceStatus": isSms,
      "fileContent": fileContent,
      "fileName": fileName,
      "mimeType": mimeType,
      "description": description,
      "vocCreateVocResult": vocCreateVocResult,
      "authenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.Voice_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<Voice> data = []; // ตัวแปรที่จะเรียกใช้งาน

  Voice.fromJson(Map<String, dynamic> json) {
    //new
    complainerID = json['complainerID'];
    complainerNo = json['complainerNo'];
    complaintNo = json['tagId'];
    complaintTag = json['ComplaintTag'];
    voiceType = json['voiceType'];
    voiceStatus = json['voiceStatus'];
    date = json['date'];
    peaName = json['PeaName'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['complainerID'] = this.complainerID;
    data['tagId'] = this.tagId;
    data['complainerName'] = this.complainerName;
    data['citizenNumber'] = this.citizenNumber;
    data['telephoneNumber'] = this.telephoneNumber;
    data['email'] = this.email;
    data['customerTypeId'] = this.customerTypeId;
    data['provinceId'] = this.provinceId;
    data['peaCode'] = this.peaCode;
    data['peaName'] = this.peaName;
    data['accidentLocation'] = this.accidentLocation;
    data['caNumber'] = this.caNumber;
    data['complaintTypeId'] = this.complaintTypeId;
    data['voiceType'] = this.voiceType;
    data['contactAddress'] = this.contactAddress;
    data['detail'] = this.detail;
    data['isSms'] = this.isSms;
    data['FileContent'] = this.fileContent;
    data['FileName'] = this.fileName;
    data['MimeType'] = this.mimeType;
    data['Description'] = this.description;
    data['Voc_CreateVocResult'] = this.vocCreateVocResult;
    data['date'] = this.date;
    data['voiceStatus'] = this.voiceStatus;
    return data;
  }

  static List<Voice> dataView = []; // ตัวแปรที่จะเรียกใช้งาน

  Voice.fromJsonView(Map<String, dynamic> json) {
    complainerID = json['ComplaintId'];
    complainerNo = json['ComplaintNo'];
    complaintStatus = json['ComplaintStatus'];
    tagId = json['TagId'];
    // tagName = json['TagName'];
    complainerName = json['ComplainerName'];
    citizenNumber = json['CitizenNumber'];
    telephoneNumber = json['TelephoneNumber'];
    email = json['Email'];
    customerTypeId = json['CustomerTypeId'];
    provinceId = json['ProvinceId'];
    provinceName = json['ProvinceName'];
    peaCode = json['PeaCode'];
    peaName = json['PeaName'];
    accidentLocation = json['AccidentLocation'];
    caNumber = json['CaNumber'];
    complaintTypeId = json['ComplaintTypeId'];
    complaintTypeName = json['ComplaintTypeName'];
    complaintSubTypeId = json['ComplaintSubtypeId'];
    complaintSubtypeName = json['ComplaintSubtypeName'];
    contactAddress = json['ContactAddress'];
    detail = json['Detail'];

    if (json['AttachmentFileList'] != null) {
      files = new List<AttachmentFileList>();
      json['AttachmentFileList'].forEach((v) {
        files.add(new AttachmentFileList.fromJson(v));
      });
    }
  }
}

class AttachmentFileList {
  String fileContent;
  String fileUrl;
  String fileName;
  String mimeType;
  String description;

  AttachmentFileList({
    this.fileContent,
    this.fileUrl,
    this.fileName,
    this.mimeType,
    this.description,
  });

  AttachmentFileList.fromJson(Map<String, dynamic> json) {
    fileContent = json['FileContent'];
    fileUrl = json['FileUrl'];
    fileName = json['FileName'];
    mimeType = json['MimeType'];
    description = json['Description'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['FileContent'] = this.fileContent;
    data['FileUrl'] = this.fileUrl;
    data['FileName'] = this.fileName;
    data['MimeType'] = this.mimeType;
    data['Description'] = this.description;
    return data;
  }
}
