import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class LocationType {
  String locationTypeID;
  String locationType;

  LocationType({
    this.locationTypeID,
    this.locationType,
  });

  static getData() async {
    final response = await AppApi.apiGetRequest(
      AppUrl.LocationType_ReadList + "?AuthenKey=" + AppUrl.AuthenKey,
    ); // เรียกใช้ api

    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static List<LocationType> data = []; // ตัวแปรที่จะเรียกใช้งาน

  LocationType.fromJson(Map<String, dynamic> json) {
    locationTypeID = json['LocationTypeID'];
    locationType = json['LocationType'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = Map<String, dynamic>();
    data['LocationTypeID'] = this.locationTypeID;
    data['LocationType'] = this.locationType;
    return data;
  }
}
