class FirebaseNotification {
  String title;
  String body;
  String notiType;
  String payload;

  FirebaseNotification({
    this.title,
    this.body,
    this.notiType,
    this.payload,
  });

  factory FirebaseNotification.fromJson(Map<dynamic, dynamic> json) =>
      FirebaseNotification(
        title: json["title"] ?? "",
        body: json["body"] ?? "",
        notiType: json["noti_type"] ?? "",
      );

  Map<String, dynamic> toJson() => {
        "title": title,
        "body": body,
        "noti_type": notiType,
      };
}
