import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class ElectricProblem {
  String ca;
  String authenKey;
  String reqID;
  String statName;
  String electricShutdownID;
  String detail;
  String saveStatus;
  String startDate;
  String endDate;
  String electiricType;
  String customerPhone;
  String customerName;

  ElectricProblem({
    this.ca,
    this.authenKey,
    this.reqID,
    this.statName,
    this.electricShutdownID,
    this.detail,
    this.saveStatus,
    this.startDate,
    this.endDate,
    this.electiricType,
    this.customerPhone,
    this.customerName,
  });

  static getData() async {
    final response = await AppApi.apiGetRequest(
      AppUrl.ElectricShutdown_ReadList +
          "?customerID=" +
          AppUrl.CustomerID +
          "&authenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getDataFromCustomer() async {
    final response = await AppApi.apiGetRequest(
      AppUrl.ElectricCustomerShutdown_ReadList +
          "?CustomerID=" +
          AppUrl.CustomerID +
          "&authenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    print(response);
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.ElectricShutdown_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String reqID,
  ) async {
    Map<String, dynamic> data = {"ReqID": reqID, "AuthenKey": AppUrl.AuthenKey};
    final response =
        await AppApi.post(AppUrl.ElectricShutdown_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String problemStartDate,
    String problemEndDate,
    String problemDetail,
    String personInform,
    String customerId,
    String customerName,
    String authenKey,
  ) async {
    Map<String, dynamic> data = {
      "ProblemStartDate": problemStartDate,
      "ProblemEndDate": problemEndDate,
      "ProblemDetail": problemDetail,
      "PersonInform": personInform,
      "customerId": customerId,
      "customerName": customerName,
      //"authenKey": authenKey,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.ElectricShutdown_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<ElectricProblem> data = []; // ตัวแปรที่จะเรียกใช้งาน

  ElectricProblem.fromJson(Map<String, dynamic> json) {
    ca = json['CA'];
    reqID = json['ReqID'];
    statName = json['statName'];
    electricShutdownID = json['Electric_ShutdownID'];
    detail = json['Detail'];
    saveStatus = json['SaveStatus'];
    startDate = json['Startdate'];
    endDate = json['enddate'];
    electiricType = json['ElectiricType'];
    customerPhone = json['CustomerPhone'];
    customerName = json['CustomerName'];
    authenKey = AppUrl.AuthenKey;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = Map<String, dynamic>();
    data['CA'] = this.ca;
    data['authenKey'] = this.authenKey;
    data['ReqID'] = this.reqID;
    data['statName'] = this.statName;
    data['Electric_ShutdownID'] = this.electricShutdownID;
    data['Detail'] = this.detail;
    data['SaveStatus'] = this.saveStatus;
    data['Startdate'] = this.startDate;
    data['enddate'] = this.endDate;
    data['ElectiricType'] = this.electiricType;
    data['CustomerPhone'] = this.customerPhone;
    data['CustomerName'] = this.customerName;

    return data;
  }
}

class ElectricProblemInfo {
  String startdate;
  String enddate;
  String detail;
  String customerPhone;
  String customerName;
  String customerId;

  ElectricProblemInfo({
    this.startdate,
    this.enddate,
    this.detail,
    this.customerPhone,
    this.customerName,
    this.customerId,
  });

  static getDataFromCustomer() async {
    print(AppUrl.ElectricCustomerShutdown_ReadList +
          "?CustomerID=" +
          AppUrl.CustomerID +
          "&authenKey=" +
          AppUrl.AuthenKey,);
    final response = await AppApi.apiGetRequest(
      AppUrl.ElectricCustomerShutdown_ReadList +
          "?CustomerID=" +
          AppUrl.CustomerID +
          "&authenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    //print(response);
    return response;
  }

  static List<ElectricProblemInfo> data = []; // ตัวแปรที่จะเรียกใช้งาน

  ElectricProblemInfo.fromJson(Map<String, dynamic> json) {
    startdate = json['Startdate'];
    enddate = json['enddate'];
    detail = json['Detail'];
    customerPhone = json['CustomerPhone'];
    customerName = json['CustomerName'];
    customerId = json['ca'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = Map<String, dynamic>();
    data['Startdate'] = this.startdate;
    data['enddate'] = this.enddate;
    data['Detail'] = this.detail;
    data['CustomerPhone'] = this.customerPhone;
    data['CustomerName'] = this.customerName;
    data['customerId'] = this.customerId;
    return data;
  }
}
