import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class Electric {
  String text;
  String value;

  Electric({
    this.text,
    this.value,
  });

  static getData() async {
    final response = await AppApi.apiGetRequest(
      AppUrl.Electric_ReadList +
          "?Electric_ID=" +
          AppUrl.Electric_ID +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static searchData(data) async {
    final response = await AppApi.apiPostRequest(
      AppUrl.Electric_ReadList,
      data,
    ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.Electric_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {}
  }

  static deleteData(
    context,
    String electricID,
  ) async {
    Map<String, dynamic> data = {
      "Electric_ID": electricID,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.Electric_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String electricictext,
    String value,
    String cA,
    String statisticCode,
    String authenKey,
  ) async {
    Map<String, dynamic> data = {
      "Text": electricictext,
      "Value": value,
      "CA": cA,
      "statisticCode": statisticCode,
      //"authenKey": authenKey,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
      AppUrl.Electric_Update,
      data,
    ); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<Electric> data = []; // ตัวแปรที่จะเรียกใช้งาน

  Electric.fromJson(Map<String, dynamic> json) {
    var _text = json['Text'];
    value = json['Value'].toString();
    text = _text;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['Text'] = this.text;
    data['Value'] = this.value;
    return data;
  }
}

class ElectricDropdown {
  String statisticCode;
  String statisticName;

  ElectricDropdown({
    this.statisticCode,
    this.statisticName,
  });

  ElectricDropdown.fromJson(Map<String, dynamic> json) {
    statisticCode = json['StatisticCode'];
    statisticName = json['StatisticName'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['StatisticCode'] = this.statisticCode;
    data['StatisticName'] = this.statisticName;
    return data;
  }
}
