import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class DashboardChartline {
  String text;
  String value;
  String employeeNumber;
  String authenKey;

  DashboardChartline({
    this.text,
    this.value,
    this.employeeNumber,
    this.authenKey,
  });

  static getData(String empNo) async {
    print(
      AppUrl.DashboardChartline_ReadList +
          "?employeeNumber=" +
          empNo +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    );
    final response = await AppApi.apiGetRequest(
      AppUrl.DashboardChartline_ReadList +
          "?employeeNumber=" +
          empNo +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getDataDashboardChartlineActivity(String empNo) async {
    print(
      AppUrl.DashboardChartline_Activity +
          "?employeeNumber=" +
          empNo +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    );
    final response = await AppApi.apiGetRequest(
      AppUrl.DashboardChartline_Activity +
          "?employeeNumber=" +
          empNo +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response = await AppApi.post(
        AppUrl.DashboardChartline_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String yearID,
    String monthID,
  ) async {
    Map<String, dynamic> data = {
      "YearID": yearID,
      "MonthID": monthID,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.DashboardChartline_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String text,
    String value,
    String employeeNumber,
    String authenKey,
  ) async {
    Map<String, dynamic> data = {
      "Text": text,
      "Value": value,
      "employeeNumber": employeeNumber,
      //"authenKey": authenKey,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.DashboardChartline_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<DashboardChartline> data = []; // ตัวแปรที่จะเรียกใช้งาน

  DashboardChartline.fromJson(Map<String, dynamic> json) {
    text = json['Text'];
    value = json['Value'];
    employeeNumber = json['employeeNumber'];
    authenKey = json['authenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['Text'] = this.text;
    data['Value'] = this.value;
    data['employeeNumber'] = this.employeeNumber;
    data['authenKey'] = this.authenKey;
    return data;
  }
}
