import 'package:flutter/material.dart';
import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/set5/customer_representative_list.dart';

class CustomerContact {
  String customerContactInfoId;
  String customerId;
  String contactName;
  String firstName;
  String lastName;
  String position;
  String contactTel;
  String contactEtc;
  String citizenNumber;
  bool isUsePeaSmartCare;
  String authenKey;

  CustomerContact({
    this.customerContactInfoId,
    this.customerId,
    this.contactName,
    this.firstName,
    this.lastName,
    this.position,
    this.contactTel,
    this.contactEtc,
    this.citizenNumber,
    this.authenKey,
  });

  static getData() async {
    final response = await AppApi.apiGetRequest(
      AppUrl.CustomerContact_ReadList +
          "?customerID=" +
          AppUrl.CustomerID +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน

    return response;
  }

  static updateData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.CustomerContact_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      AppLoader.showSuccess('แก้ไขสำเร็จ');
      Navigator.pushReplacement(
        context,
        MaterialPageRoute(
          builder: (context) => CustomerRepresentativeList(),
        ),
      );
    }
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.CustomerContact_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      AppLoader.showSuccess('บันทึกสำเร็จ');
      await Future.delayed(const Duration(milliseconds: 2000));
      Navigator.pushReplacement(
        context,
        MaterialPageRoute(
          builder: (context) => CustomerRepresentativeList(),
        ),
      );
    } else {
      AppLoader.showSuccess('บันทึกไม่สำเร็จ');
    }
  }

  static deleteData(context, String customerContactID, int index) async {
    Map<String, dynamic> data = {
      "customerContactInfoId": customerContactID.toString(),
      "AuthenKey": AppUrl.AuthenKey.toString()
    };

    final response = await AppApi.postWithMap(
      AppUrl.CustomerContact_Delete,
      data,
    ); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      AppLoader.showSuccess('ลบสำเร็จ');
      await Future.delayed(const Duration(milliseconds: 2000));
      return true;
    } else {
      return false;
    }
  }

  static List<CustomerContact> data = []; // ตัวแปรที่จะเรียกใช้งาน

  CustomerContact.fromJson(Map<String, dynamic> json) {
    customerContactInfoId = json['customerContactInfoId'];
    customerId = json['customerId'];
    contactName = json['contactName'];
    firstName = json['firstName'];
    lastName = json['lastName'];
    position = json['position'];
    contactTel = json['contactTel'];
    contactEtc = json['contactEtc'];
    citizenNumber = json['citizenNumber'];
    isUsePeaSmartCare = json['IsUsePeaSmartCare'];
    authenKey = json['authenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = Map<String, dynamic>();
    data['customerContactInfoId'] = this.customerContactInfoId;
    data['customerId'] = this.customerId;
    data['contactName'] = this.contactName;
    data['firstName'] = this.firstName;
    data['lastName'] = this.lastName;
    data['position'] = this.position;
    data['contactTel'] = this.contactTel;
    data['contactEtc'] = this.contactEtc;
    data['citizenNumber'] = this.citizenNumber;
    data['IsUsePeaSmartCare'] = this.isUsePeaSmartCare;
    data['authenKey'] = this.authenKey;
    return data;
  }

  static del(index, context) {
    return showDialog(
      barrierDismissible: false,
      context: context,
      builder: (BuildContext context) {
        return Center(
          child: AlertDialog(
            shape: RoundedRectangleBorder(
              borderRadius: BorderRadius.all(
                Radius.circular(
                  mediaQuery(context, 'h', 50),
                ),
              ),
            ),
            title: Column(
              children: <Widget>[
                Container(
                  child: Image.asset(
                    'assets/images/question.png',
                    width: mediaQuery(context, 'w', 200),
                    height: mediaQuery(context, 'h', 200),
                  ),
                ),
              ],
            ),
            content: Container(
              child: Column(
                mainAxisSize: MainAxisSize.min,
                children: <Widget>[
                  Text(
                    'ลบข้อมูล',
                    style: TextStyle(
                      fontWeight: FontWeight.bold,
                      fontSize: mediaQuery(context, 'h', 60),
                    ),
                    textAlign: TextAlign.center,
                  ),
                  SizedBox(
                    height: mediaQuery(context, 'h', 10),
                  ),
                  Text(
                    'คุณแน่ใจว่าต้องการลบ?',
                    style: TextStyle(
                      fontSize: mediaQuery(context, 'h', 46),
                    ),
                    textAlign: TextAlign.center,
                  ),
                  SizedBox(
                    height: mediaQuery(context, 'h', 40),
                  ),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                    children: <Widget>[
                      ButtonTheme(
                        minWidth: mediaQuery(context, 'h', 320),
                        height: mediaQuery(context, 'h', 120),
                        child: RaisedButton(
                          color: Colors.white,
                          shape: RoundedRectangleBorder(
                            borderRadius: BorderRadius.circular(
                              mediaQuery(context, 'h', 50),
                            ),
                            side: BorderSide(
                              color: AppColors.color.withOpacity(0.51),
                            ),
                          ),
                          onPressed: () {
                            deleteData(
                              context,
                              CustomerContact.data[index].customerId,
                              index,
                            );
                            Navigator.pop(context);
                          },
                          splashColor: AppColors.color,
                          child: Text(
                            'ตกลง',
                            style: TextStyle(
                              color: AppColors.color,
                              fontSize: mediaQuery(context, 'h', 46),
                            ),
                          ),
                        ),
                      ),
                      SizedBox(
                        width: mediaQuery(context, 'w', 20),
                      ),
                      ButtonTheme(
                        minWidth: mediaQuery(context, 'h', 320),
                        height: mediaQuery(context, 'h', 120),
                        child: RaisedButton(
                          color: Colors.white,
                          shape: RoundedRectangleBorder(
                            borderRadius: BorderRadius.circular(
                              mediaQuery(context, 'h', 50),
                            ),
                            side: BorderSide(
                              color: AppColors.color.withOpacity(0.51),
                            ),
                          ),
                          onPressed: () {
                            Navigator.pop(context);
                          },
                          splashColor: AppColors.color,
                          child: Text(
                            "ยกเลิก",
                            style: TextStyle(
                              color: AppColors.color,
                              fontSize: mediaQuery(context, 'h', 46),
                            ),
                          ),
                        ),
                      ),
                    ],
                  ),
                ],
              ),
            ),
          ),
        );
      },
    );
  }
}
