import 'dart:convert';
import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/navigator.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/set1/customer_property.dart';
import 'package:mwf_app/set1/serve_customers.dart';

class CustomerInfo {
  String customerId;
  String businessPartner;
  String ca;
  String customerName;
  String customerAddress;
  String tsicCode;
  String tsicName;
  String regionCode;
  String regionText;
  String website;
  String latitude;
  String longitude;
  bool haveVoltageKv;
  bool haveHighElectricityBill;
  bool haveRiskLoseToSpp;
  bool haveRiskLoseToOwnElectric;
  bool havePotentialMoreBusiness;
  bool havePotentialStrategicEconomy;
  bool haveConnection;
  bool haveGoodImageToOrganization;
  bool haveLoseMoneyFromElectricProblem;
  bool isOldKam;
  String highValueSizeID;
  String highValueSize;
  String highValueAmount;
  String kamTypeID;
  String kamType;
  String customerClassificationID;
  String customerClassification;
  bool isIndustrialArea;
  bool isCountryside;
  String industryZone;
  String keyAccountStatus;
  String sizeoftransformer;
  String customerInfo1;
  String customerInfo2;
  String authenKey;

  CustomerInfo({
    this.customerId,
    this.businessPartner,
    this.ca,
    this.customerName,
    this.customerAddress,
    this.tsicCode,
    this.tsicName,
    this.regionCode,
    this.regionText,
    this.website,
    this.latitude,
    this.longitude,
    this.haveVoltageKv,
    this.haveHighElectricityBill,
    this.haveRiskLoseToSpp,
    this.haveRiskLoseToOwnElectric,
    this.havePotentialMoreBusiness,
    this.havePotentialStrategicEconomy,
    this.haveConnection,
    this.haveGoodImageToOrganization,
    this.haveLoseMoneyFromElectricProblem,
    this.isOldKam,
    this.highValueSize,
    this.highValueAmount,
    this.kamType,
    this.customerClassification,
    this.isIndustrialArea,
    this.isCountryside,
    this.industryZone,
    this.keyAccountStatus,
    this.sizeoftransformer,
    this.customerInfo1,
    this.customerInfo2,
    this.authenKey,
  });

  static getData() async {
    print(AppUrl.CustomerInfo_Read +
        "?CustomerID=" +
        AppUrl.CustomerID +
        "&AuthenKey=" +
        AppUrl.AuthenKey);
    final response = await AppApi.apiGetRequest(
      AppUrl.CustomerInfo_Read +
          "?CustomerID=" +
          AppUrl.CustomerID +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    var json = jsonEncode(data);
    print(json);
    print(AppUrl.CustomerInfo_Update);
    final response = await AppApi.postWithMap(
        AppUrl.CustomerInfo_Update, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      AppLoader.showSuccess('บันทึกสำเร็จ');
      await Future.delayed(const Duration(milliseconds: 2000));
      Navigator.pushReplacement(
        context,
        MaterialPageRoute(
          builder: (context) => CustomerProperty(),
        ),
      );
    } else {
      AppLoader.showSuccess('บันทึกไม่สำเร็จ');
    }
  }

  static deleteData(
    context,
    String customerID,
  ) async {
    Map<String, dynamic> data = {
      "CustomerID": customerID,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.CustomerInfo_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      // AppLoader.showSuccess('Error API = ' + response['Message']);
      return false;
    }
  }

  static updateData(
    context,
    String customerId,
    String ca,
    String authenKey,
    String customerName,
    String customerAddress,
    String tsicCode,
    String tsicName,
    String regionCode,
    String regionText,
    String customerGroup,
    String highValue,
    String value,
    String keyAccountStatus,
    String businessPartner,
    String sizeoftransformer,
    String website,
    String latitude,
    String longitude,
    String industrialarea,
    String haveVoltageKv,
    String haveHighElectricityBill,
    String haveRiskLoseToSpp,
    String haveRiskLoseToOwnElectric,
    String havePotentialMoreBusiness,
    String havePotentialStrategicEconomy,
    String haveConnection,
    String haveGoodImageToOrganization,
    String haveLoseMoneyFromElectricProblem,
    String isOldKam,
    String highValueSize,
    String highValueAmount,
    String kamType,
    String customerClassification,
    String isIndustrialArea,
    String isCountryside,
    String industryZone,
    String AuthenKey,
    List customerInfo_1,
    List customerInfo_2,
  ) async {
    var customerInfo1 = "";

    for (int i = 0; i < customerInfo_1.length; i++) {
      if (i == customerInfo_1.length - 1) {
        customerInfo1 += customerInfo_1[i];
      } else {
        customerInfo1 += customerInfo_1[i] + ",";
      }
    }

    var customerInfo2 = "";

    for (int i = 0; i < customerInfo_2.length; i++) {
      if (i == customerInfo_2.length - 1) {
        customerInfo2 += customerInfo_2[i];
      } else {
        customerInfo2 += customerInfo_2[i] + ",";
      }
    }

    Map<String, dynamic> data = {
      "CustomerId": customerId,
      "Ca": ca,
      "AuthenKey": authenKey,
      "CustomerName": customerName,
      "CustomerAddress": customerAddress,
      "TsicCode": tsicCode,
      "TsicName": tsicName,
      "RegionCode": regionCode,
      "RegionText": regionText,
      "Website": website,
      "Latitude": latitude,
      "Longitude": longitude,
      "HaveVoltageKv": haveVoltageKv,
      "BusinessPartner": businessPartner,
      "HaveHighElectricityBill": haveHighElectricityBill,
      "HaveRiskLoseToSpp": haveRiskLoseToSpp,
      "HaveRiskLoseToOwnElectric": haveRiskLoseToOwnElectric,
      "HavePotentialMoreBusiness": havePotentialMoreBusiness,
      "HavePotentialStrategicEconomy": havePotentialStrategicEconomy,
      "HaveConnection": haveConnection,
      "HaveGoodImageToOrganization": haveGoodImageToOrganization,
      "HaveLoseMoneyFromElectricProblem": haveLoseMoneyFromElectricProblem,
      "IsOldKam": isOldKam,
      "HighValueSize": highValueSize,
      "HighValueAmount": highValueAmount,
      "KamType": kamType,
      "CustomerClassification": customerClassification,
      "IsIndustrialArea": isIndustrialArea,
      "IsCountryside": isCountryside,
      "IndustryZone": industryZone,
      "authenKey": AppUrl.AuthenKey
    };

    final response =
        await AppApi.post(AppUrl.CustomerInfo_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      Nav.push(context, ServeCustomer());
    } else {
      return false;
    }
  }

  static List<CustomerInfo> data = []; // ตัวแปรที่จะเรียกใช้งาน

  CustomerInfo.fromJson(Map<String, dynamic> json) {
    customerId = json['CustomerId'];
    businessPartner = json['BusinessPartner'];
    ca = json['Ca'];
    customerName = json['CustomerName'];
    customerAddress = json['CustomerAddress'];
    tsicCode = json['TsicCode'];
    tsicName = json['TsicName'];
    regionCode = json['RegionCode'];
    regionText = json['RegionText'];
    website = json['Website'];
    latitude = json['Latitude'].toString();
    longitude = json['Longitude'].toString();
    haveVoltageKv = json['HaveVoltageKv'];
    haveHighElectricityBill = json['HaveHighElectricityBill'];
    haveRiskLoseToSpp = json['HaveRiskLoseToSpp'];
    haveRiskLoseToOwnElectric = json['HaveRiskLoseToOwnElectric'];
    havePotentialMoreBusiness = json['HavePotentialMoreBusiness'];
    havePotentialStrategicEconomy = json['HavePotentialStrategicEconomy'];
    haveConnection = json['HaveConnection'];
    haveGoodImageToOrganization = json['HaveGoodImageToOrganization'];
    haveLoseMoneyFromElectricProblem = json['HaveLoseMoneyFromElectricProblem'];
    isOldKam = json['IsOldKam'];
    highValueSizeID = json['HighValueSizeId'].toString();
    highValueSize = json['HighValueSize'].toString();
    highValueAmount = json['HighValueAmount'].toString();
    kamTypeID = json['KamTypeId'].toString();
    kamType = json['KamType'].toString();
    customerClassificationID = json['CustomerClassificationId'].toString();
    customerClassification = json['CustomerClassification'].toString();
    isIndustrialArea = json['IsIndustrialArea'];
    isCountryside = json['IsCountryside'];
    industryZone = json['IndustryZone'].toString();
    authenKey = AppUrl.AuthenKey;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = Map<String, dynamic>();
    data['CustomerId'] = this.customerId;
    data['BusinessPartner'] = this.businessPartner;
    data['Ca'] = this.ca;
    data['CustomerName'] = this.customerName;
    data['CustomerAddress'] = this.customerAddress;
    data['TsicCode'] = this.tsicCode;
    data['TsicName'] = this.tsicName;
    data['RegionCode'] = this.regionCode;
    data['RegionText'] = this.regionText;
    data['Website'] = this.website;
    data['Latitude'] = this.latitude;
    data['Longitude'] = this.longitude;
    data['HaveVoltageKv'] = this.haveVoltageKv;
    data['HaveHighElectricityBill'] = this.haveHighElectricityBill;
    data['HaveRiskLoseToSpp'] = this.haveRiskLoseToSpp;
    data['HaveRiskLoseToOwnElectric'] = this.haveRiskLoseToOwnElectric;
    data['HavePotentialMoreBusiness'] = this.havePotentialMoreBusiness;
    data['HavePotentialStrategicEconomy'] = this.havePotentialStrategicEconomy;
    data['HaveConnection'] = this.haveConnection;
    data['HaveGoodImageToOrganization'] = this.haveGoodImageToOrganization;
    data['HaveLoseMoneyFromElectricProblem'] =
        this.haveLoseMoneyFromElectricProblem;
    data['IsOldKam'] = this.isOldKam;
    data['HighValueSizeId'] = this.highValueSizeID;
    data['HighValueSize'] = this.highValueSize;
    data['HighValueAmount'] = this.highValueAmount;
    data['KamTypeId'] = this.kamTypeID;
    data['KamType'] = this.kamType;
    data['CustomerClassificationId'] = this.customerClassificationID;
    data['CustomerClassification'] = this.customerClassification;
    data['IsIndustrialArea'] = this.isIndustrialArea;
    data['IsCountryside'] = this.isCountryside;
    data['IndustryZone'] = this.industryZone;
    return data;
  }
}
