import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class CompanyRepresentative {
  String companyRepresentativeID;
  String customerID;
  String companyRepresentativeName;
  String position;
  String phone;
  String channelContact;
  String authenKey;
  String activityType;

  CompanyRepresentative({
    this.companyRepresentativeID,
    this.customerID,
    this.companyRepresentativeName,
    this.position,
    this.phone,
    this.channelContact,
    this.authenKey,
    this.activityType,
  });

  static getData() async {
    final response = await AppApi.apiGetRequest(
      AppUrl.CompanyRepresentative_ReadCusIDList +
          "?customerID=" +
          AppUrl.CustomerID +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response = await AppApi.post(
        AppUrl.CompanyRepresentative_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String companyRepresentativeID,
  ) async {
    Map<String, dynamic> data = {
      "CompanyRepresentativeID": companyRepresentativeID,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
      AppUrl.CompanyRepresentative_Delete,
      data,
    ); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String companyRepresentativeID,
    String customerID,
    String companyRepresentativeName,
    String position,
    String phone,
    String channelContact,
    String authenKey,
    String activityType,
  ) async {
    Map<String, dynamic> data = {
      "CompanyRepresentativeID": companyRepresentativeID,
      "customerID": customerID,
      "CompanyRepresentativeName": companyRepresentativeName,
      "Position": position,
      "Phone": phone,
      "ChannelContact": channelContact,
      "ActivityType": activityType,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.CompanyRepresentative_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<CompanyRepresentative> data = []; // ตัวแปรที่จะเรียกใช้งาน

  CompanyRepresentative.fromJson(Map<String, dynamic> json) {
    companyRepresentativeID = json['CompanyRepresentativeID'];
    customerID = json['customerID'];
    companyRepresentativeName = json['CompanyRepresentativeName'];
    position = json['Position'];
    phone = json['Phone'];
    channelContact = json['ChannelContact'];
    authenKey = json['AuthenKey'];
    activityType = json['ActivityType'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['CompanyRepresentativeID'] = this.companyRepresentativeID;
    data['customerID'] = this.customerID;
    data['CompanyRepresentativeName'] = this.companyRepresentativeName;
    data['Position'] = this.position;
    data['Phone'] = this.phone;
    data['ChannelContact'] = this.channelContact;
    data['AuthenKey'] = this.authenKey;
    data['ActivityType'] = this.activityType;
    return data;
  }
}
