import 'dart:convert';

import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/strings.dart';
import 'package:mwf_app/service/url.dart';

class ChatDetailSend {
  String chatMasterId;
  String accountId;
  String typeAccount;
  String content;
  String type;

  ChatDetailSend({
    this.chatMasterId,
    this.accountId,
    this.typeAccount,
    this.content,
    this.type,
  });

  ChatDetailSend.fromJson(Map<String, dynamic> json) {
    chatMasterId = json['ChatMasterId'];
    accountId = json['AccountId'];
    typeAccount = json['TypeAccount'];
    content = json['content'];
    type = json['Type'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = Map<String, dynamic>();
    data['ChatMasterId'] = this.chatMasterId;
    data['AccountId'] = this.accountId;
    data['TypeAccount'] = this.typeAccount;
    data['content'] = content;
    data['Type'] = this.type;
    return data;
  }

  static sendText({String text, String filename, String fileType, int type, String room, String chatRoomType}) async {
    String firstName = AppStrings.profileFullName.split(" ")[0].trim();
    String lastName = AppStrings.profileFullName.split(" ")[1].trim();

    var data = 
      jsonEncode({
      "Id": chatRoomType == "individual" ? AppUrl.chatId : "00000000-0000-0000-0000-000000000000",
      "ChatMasterId": chatRoomType == "individual" ? AppUrl.chatMasterId : "fb0593bf-bee9-4350-845f-9aad236f7186",
      "ChatMaster": null,
      "AccountId": chatRoomType == "individual" ? AppUrl.accountId : AppUrl.userID,
      "TypeAccount": chatRoomType == "individual" ? AppUrl.typeAccount : "2ae2539c-4a49-4578-9bd3-136eab70ddfc",
      "TypeChat": chatRoomType == "individual" ? AppUrl.typeChat : "0325D48B-0E85-4FCE-854A-88328D417426",
      "content": text,
      "createAt": null,
      "Time": DateTime.now().hour.toString()+":"+DateTime.now().minute.toString(),
      "File": null,
      "FileName": filename,
      "Status": 0,
      "IDCard": null,
      "Mobile": null,
      "TSICID": chatRoomType == "individual" ? AppUrl.tsicid : "",
      "BranchID": chatRoomType == "individual" ? AppUrl.branchId : "",
      "username" : firstName + " " + lastName,
      "saleInfoId": chatRoomType == "individual" ? AppUrl.customerSeleInfo : AppUrl.userID,
      "Type": type.toString(),
      "TypeFile": (type == 2 || type == 3 ? fileType : ""),
      "CustomerId": chatRoomType == "individual" ? AppUrl.CustomerID : null,
      "CustomerName": room,
      "CustomerAddress": chatRoomType == "individual" ? AppUrl.customerAddress : "",
      "CA": chatRoomType == "individual" ? AppUrl.CA : "",
      "user" : {
        "Id":  AppUrl.userID,
        "firstname": firstName,
        "lastname": lastName,
        "avatar": null,
        "IDCard": null,
        "Mobile": null,
        "CA": chatRoomType == "individual" ? AppUrl.CA : "",
        "CustomerName": room,
        "CustomerAddress": chatRoomType == "individual" ? AppUrl.customerAddress : "",
      },
      });

    print(data);
    final response = await AppApi.postString(AppUrl.ChatDetail_Send, data);

    print(" Response ::: "+response.toString());
    return response;
  }
}
