import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/navigator.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/set1/schedule.dart';

class Voice_Provinelist {
  String proviceId;
  String proviceName;
  String authenKey;

  Voice_Provinelist({this.proviceId, this.proviceName, this.authenKey});

  static getData() async {
    final response = await AppApi.apiGetRequest(AppUrl.Voc_Provinelist +
        "?Id=" +
        AppUrl.Id +
        "&AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.Voice_Provine_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String id,
  ) async {
    Map<String, dynamic> data = {"Id": id, "AuthenKey": AppUrl.AuthenKey};
    final response =
        await AppApi.post(AppUrl.Voice_Provine_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String proviceId,
    String proviceName,
    String authenKey,
  ) async {
    Map<String, dynamic> data = {
      "ProviceId": proviceId,
      "ProviceName": proviceName,
      //"authenKey": authenKey,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.Voice_Provine_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<Voice_Provinelist> data = []; // ตัวแปรที่จะเรียกใช้งาน

  Voice_Provinelist.fromJson(Map<String, dynamic> json) {
    proviceId = json['ProviceId'];
    proviceName = json['ProviceName'];
    authenKey = json['authenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['ProviceId'] = this.proviceId;
    data['ProviceName'] = this.proviceName;
    data['authenKey'] = this.authenKey;
    return data;
  }
}
