import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/navigator.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/set1/schedule.dart';

class Voice_ComplaintTypeList {
  String complaintTypeId;
  String complaintTypeName;
  String tagId;
  String authenKey;

  Voice_ComplaintTypeList(
      {this.complaintTypeId,
      this.complaintTypeName,
      this.tagId,
      this.authenKey});

  static getData() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.Voice_ComplaintType_ReadList +
            "?Id=" +
            AppUrl.Id +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response = await AppApi.post(
        AppUrl.Voice_ComplaintType_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String id,
  ) async {
    Map<String, dynamic> data = {"Id": id, "AuthenKey": AppUrl.AuthenKey};
    final response = await AppApi.post(
        AppUrl.Voice_ComplaintType_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String complaintTypeId,
    String complaintTypeName,
    String tagId,
    String authenKey,
  ) async {
    Map<String, dynamic> data = {
      "ComplaintTypeId": complaintTypeId,
      "ComplaintTypeName": complaintTypeName,
      "tagId": tagId,
      //"authenKey": authenKey,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.Voice_ComplaintType_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<Voice_ComplaintTypeList> data = []; // ตัวแปรที่จะเรียกใช้งาน

  Voice_ComplaintTypeList.fromJson(Map<String, dynamic> json) {
    complaintTypeId = json['ComplaintTypeId'];
    complaintTypeName = json['ComplaintTypeName'];
    tagId = json['tagId'];
    authenKey = json['authenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['ComplaintTypeId'] = this.complaintTypeId;
    data['ComplaintTypeName'] = this.complaintTypeName;
    data['tagId'] = this.tagId;
    data['authenKey'] = this.authenKey;
    return data;
  }
}
