import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/set1/schedule.dart';

class TodoList {
  String todolistID;
  String employeeID;
  String saleinfoid;
  String startdate;
  String enddate;
  String detail;
  bool readFlag;
  String authenKey;
  String packageType;

  TodoList(
      {clearData(),
      this.todolistID,
      this.employeeID,
      this.saleinfoid,
      this.startdate,
      this.enddate,
      this.detail,
      this.readFlag,
      this.packageType,
      this.authenKey});

  static getData() async {
    final response = await AppApi.apiGetRequest(AppUrl.TaskListReadList +
        "?saleinfoid=" +
        AppUrl.userID +
        "&authenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getReadTodoId(id) async {
    final response = await AppApi.apiGetRequest(AppUrl.TaskListRead +
        "?TodolistID=" +
        id +
        "&authenKey=" +
        AppUrl.AuthenKey);
    data.clear();
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.TodoList_Create, data); // เรียกใช้ api
    if (response['statusCode'] == 200) {
      AppLoader.showSuccess('บันทึกสำเร็จ');
      await new Future.delayed(const Duration(milliseconds: 2000));
      Navigator.pushReplacement(
          context, MaterialPageRoute(builder: (context) => Schedule()));
    } else {
      AppLoader.showError('บันทึกไม่สำเร็จ');
      return false;
    }
  }

  static deleteData(
    context,
    String todoListID,
    String employeeID,
  ) async {
    Map<String, dynamic> data = {
      "TodolistID": todoListID,
      "EmployeeID": AppUrl.EmpID,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.TodoList_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      AppLoader.showSuccess('ลบสำเร็จ');
      Navigator.pushReplacement(
          context, MaterialPageRoute(builder: (context) => Schedule()));
      return true;
    } else {
      AppLoader.showError('ลบไม่สำเร็จ');
      return false;
    }
  }

  static updateData(
    context,
    String todoListID,
    String employeeID,
    String saleinfoid,
    String startDate,
    String endDate,
    String detail,
  ) async {
    Map<String, dynamic> data = {
      "TodolistID": todoListID,
      "EmployeeID": employeeID,
      "saleinfoid": AppUrl.EmpID,
      "startdate": startDate,
      "enddate": endDate,
      "detail": detail,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.TodoList_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      AppLoader.showSuccess('แก้ไขสำเร็จ');
      Navigator.pushReplacement(
          context, MaterialPageRoute(builder: (context) => Schedule()));
      return true;
    } else {
      AppLoader.showError('แก้ไขไม่สำเร็จ');
      return false;
    }
  }

  static List<TodoList> data = []; // ตัวแปรที่จะเรียกใช้งาน

  TodoList.fromJson(Map<String, dynamic> json) {
    todolistID = json['TodolistID'];
    employeeID = json['EmployeeID'];
    saleinfoid = json['saleinfoid'];
    startdate = json['startdate'];
    enddate = json['enddate'];
    detail = json['detail'];
    readFlag = json['readFlag'];
    authenKey = json['AuthenKey'];
    packageType = json['PackageType'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['TodolistID'] = this.todolistID;
    data['EmployeeID'] = this.employeeID;
    data['saleinfoid'] = this.saleinfoid;
    data['startdate'] = this.startdate;
    data['enddate'] = this.enddate;
    data['detail'] = this.detail;
    data['AuthenKey'] = this.authenKey;
    return data;
  }
}
