import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class TimelineModel {
  String timelineDate;
  String timelineType;
  String timelineDetail;
  String customerId;
  String authenKey;

  TimelineModel(
      {this.timelineDate,
      this.timelineType,
      this.timelineDetail,
      this.customerId,
      this.authenKey});

  static List<dynamic> timelineList = [
    {
      "timelineID": "020000039829",
      "customername": 'บริษัทสหการประมูล จำกัด (มหาชน)',
      "timelineDetail":
          '518 ซอยรามคำแหง 39 แขวงวังทองหลาง เขตวังทองหลาง กรุงเทพมหานคร 10240',
    },
    {
      "timelineID": "020000034265",
      "customername": 'ซีพี รีเทลลิงค์ จํากัด',
      "timelineDetail":
          '159 ถนนวิภาวดีรังสิต แขวงตลาดบางเขน เขตหลักสี่ กรุงเทพมหานคร 10210',
    },
    {
      "timelineID": "020000038975",
      "customername": 'ไทยเบฟเวอเรจ จํากัด (มหาชน)',
      "timelineDetail":
          '14 ถนนวิภาวดีรังสิต แขวงจอมพล เขตจตุจักร กรุงเทพมหานคร 10900',
    },
    {
      "timelineID": "020000034289",
      "customername": 'ซี.พี. ออลล์',
      "timelineDetail":
          '283 อาคารสีบุญเรือง ถนนสีลม แขวงสีลม เขตบางรัก กรุงเทพมหานคร 10500',
    },
  ]; // รายการ Timeline

  static List<dynamic> timelineListTest = [
    {
      "timelineID": "020000039829",
      "timelineDate": "08-08-2563",
      "timelineType": 'ข่าว',
      "timelineDetail": 'ข่าวประชาสัมพันธ์',
    },
    {
      "timelineID": "020000039829",
      "timelineDate": "01-08-2563",
      "timelineType": 'สัมนา',
      "timelineDetail": 'สัมนาทดแทน',
    },
  ]; //
  static getData(customerId) async {
    if (customerId == "") {
      customerId = AppUrl.CustomerID;
    }
    final response = await AppApi.apiGetRequest(AppUrl.Timeline_ReadList +
        "?customerId=" +
        customerId +
        "&AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.Timeline_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String timelineID,
  ) async {
    Map<String, dynamic> data = {
      "TimelineID": timelineID,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.Timeline_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    DateTime timelineDate,
    String timelineType,
    String timelineDetail,
    String authenKey,
    String customerId,
  ) async {
    Map<String, dynamic> data = {
      "TimelineDate": timelineDate,
      "TimelineType": timelineType,
      "TimelineDetail": timelineDetail,
      "customerId": customerId,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.Timeline_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<TimelineModel> data = []; // ตัวแปรที่จะเรียกใช้งาน

  TimelineModel.fromJson(Map<String, dynamic> json) {
    timelineDate = json['TimelineDate'];
    timelineType = json['TimelineType'];
    timelineDetail = json['TimelineDetail'];
    customerId = json['customerId'];
    authenKey = json['authenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['TimelineDate'] = this.timelineDate;
    data['TimelineType'] = this.timelineType;
    data['TimelineDetail'] = this.timelineDetail;
    data['customerId'] = this.customerId;
    data['authenKey'] = this.authenKey;
    return data;
  }
}
