import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class TSIC {
  String id;
  String tSICID;
  String tSICName;

  TSIC({this.id, this.tSICID, this.tSICName});

  static getData() async {
    final response = await AppApi.apiGetRequest(AppUrl.TSIC_ReadList +
        "?Id=" +
        AppUrl.Id +
        "&AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.TSIC_Create, data); // เรียกใช้ api
    print(response);
  }

  static deleteData(
    context,
    String id,
  ) async {
    Map<String, dynamic> data = {"Id": id, "AuthenKey": AppUrl.AuthenKey};
    final response =
        await AppApi.post(AppUrl.TSIC_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String id,
    String tSICID,
    String tSICName,
  ) async {
    Map<String, dynamic> data = {
      "Id": id,
      "TSICID": tSICID,
      "TSICName": tSICName,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.TSIC_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<TSIC> data = []; // ตัวแปรที่จะเรียกใช้งาน

  TSIC.fromJson(Map<String, dynamic> json) {
    id = json['Id'];
    tSICID = json['TSICID'];
    tSICName = json['TSICName'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['Id'] = this.id;
    data['TSICID'] = this.tSICID;
    data['TSICName'] = this.tSICName;
    return data;
  }
}
