import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/navigator.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/set1/schedule.dart';

class SumVisitNotification {
  String sumVisitNotificationID;
  String employeeID;
  String authenKey;

  SumVisitNotification(
      {this.sumVisitNotificationID, this.employeeID, this.authenKey});

  static getData() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.SumVisitNotification_ReadList +
            "?SumVisitNotificationID=" +
            AppUrl.SumVisitNotificationID +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response = await AppApi.post(
        AppUrl.SumVisitNotification_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String sumVisitNotificationID,
  ) async {
    Map<String, dynamic> data = {
      "SumVisitNotificationID": sumVisitNotificationID,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.SumVisitNotification_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String sumVisitNotificationID,
    String employeeID,
    String authenKey,
  ) async {
    Map<String, dynamic> data = {
      "SumVisitNotificationID": sumVisitNotificationID,
      "EmployeeID": employeeID,
      "AuthenKey": authenKey,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.SumVisitNotification_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<SumVisitNotification> data = []; // ตัวแปรที่จะเรียกใช้งาน

  SumVisitNotification.fromJson(Map<String, dynamic> json) {
    sumVisitNotificationID = json['SumVisitNotificationID'];
    employeeID = json['EmployeeID'];
    authenKey = json['AuthenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['SumVisitNotificationID'] = this.sumVisitNotificationID;
    data['EmployeeID'] = this.employeeID;
    data['AuthenKey'] = this.authenKey;
    return data;
  }
}
